# WinVN - A Windows Newsreader
# 04NOV95  jr  (jrugen@primenet.com)

!ifndef DEBUG
NODEBUG=1
!endif

!include <ntwin32.mak>

!ifdef DEBUG

# Debug
OUTDIR=.\Win$(CPU)_D
CFLAGS=-nologo $(cdebug) $(cflags) $(cvars) /D "DEBUG" \
       /FR$(INTDIR)/ /Fo$(INTDIR)/ /QP604 -DBRAINDEAD_ALIGNMENT_FIX
LFLAGS=-nologo $(ldebug) kernel32.lib user32.lib gdi32.lib winspool.lib \
       comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib \
       mpr.lib /SUBSYSTEM:windows /PDB:$(OUTDIR)/"winvn32.pdb" /MACHINE:PPC \
       /DEF:".\winvn32p.def"

!else

# No Debug
OUTDIR=.\Win$(CPU)_R
CFLAGS=-nologo $(cflags) $(cvars) -DBRAINDEAD_ALIGNMENT_FIX -Ogt \
       /FR$(INTDIR)/ /Fo$(INTDIR)/ /QP604
LFLAGS=-nologo kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib\
 advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib mpr.lib\
/SUBSYSTEM:windows /PDB:$(OUTDIR)/"winvn32.pdb" /MACHINE:PPC /DEF:".\winvn32p.def"

!endif

# Common Stuff

!ifndef LOCAL
INSTDIR=$(SYSTEMROOT)\SYSTEM32
!else
INSTDIR=$(LOCAL)\bin
!endif

INTDIR=$(OUTDIR)

# Implicit Rules

.c{$(INTDIR)}.obj:
   $(cc) $(CFLAGS) $<  
.cpp{$(INTDIR)}.obj:
   $(cc) $(CFLAGS) $<
.cxx{$(INTDIR)}.obj:
   $(CPP) $(CPP_PROJ) $<   
{$(INTDIR)}.Obj{$(OUTDIR)}.Exe:
    $(link) $(LFLAGS) -map:winvn.map -out:$*.Exe $**

PROJ = WinVN
OBJS =  .\wvtb\WinPPC_R\wvtb32.lib \
	$(INTDIR)/shellsor.obj \
	$(INTDIR)/version.obj \
	$(INTDIR)/winvn.obj \
	$(INTDIR)/wvart.obj \
	$(INTDIR)/wvblock.obj \
	$(INTDIR)/wvcncm.obj \
	$(INTDIR)/wvcodewn.obj \
	$(INTDIR)/wvcoding.obj \
	$(INTDIR)/wvcrypt.obj \
	$(INTDIR)/wvfile.obj \
	$(INTDIR)/wvheader.obj \
	$(INTDIR)/wvlist.obj \
	$(INTDIR)/wvmail.obj \
	$(INTDIR)/wvmapi.obj \
	$(INTDIR)/wvprint.obj \
	$(INTDIR)/wvsckgen.obj \
	$(INTDIR)/wvscreen.obj \
	$(INTDIR)/wvtxtblk.obj \
	$(INTDIR)/wvusenet.obj \
	$(INTDIR)/winvn.res \
	$(INTDIR)/wvstbar.obj \
	$(INTDIR)/wvfiler.obj \
	$(INTDIR)/wvpath.obj \
	$(INTDIR)/wvcompos.obj \
	$(INTDIR)/wvsend.obj \
	$(INTDIR)/wvfilter.obj \
	$(INTDIR)/wvgroup.obj \
	$(INTDIR)/headarry.obj \
	$(INTDIR)/ini_news.obj \
	$(INTDIR)/wvutil.obj
#LIBS = wsock32.lib netapi32.lib
#LIBS = $(olelibs) 
LIBS =  kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib\
	advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib

all: $(OUTDIR) $(PROJ) 

$(PROJ): $(OUTDIR)\$(PROJ).exe

## Simple dependencies

$(OUTDIR)\WinVN.exe: $(OBJS)

$(INTDIR)/shellsor.obj: .\shellsor.c
$(INTDIR)/version.obj:  .\version.c
$(INTDIR)/winvn.obj:    .\winvn.c .\wvglob.h .\winvn.h .\defaults.h\
			.\wvtb\wvtb.h .\wvstates.h .\wvdlg.h \
			.\version.h
$(INTDIR)/wvart.obj:    .\wvart.c .\wvglob.h .\winvn.h .\wvtb\wvtb.h\
			.\wvstates.h .\wvdlg.h .\version.h
$(INTDIR)/wvblock.obj:  .\wvblock.c
$(INTDIR)/wvcncm.obj:   .\wvcncm.c .\wvglob.h .\winvn.h .\wvtb\wvtb.h\
			.\wvstates.h .\wvdlg.h .\version.h
$(INTDIR)/wvcodewn.obj: .\wvcodewn.c
$(INTDIR)/wvcoding.obj: .\wvcoding.c
$(INTDIR)/wvcrypt.obj:  .\wvcrypt.c
$(INTDIR)/wvfile.obj:   .\wvfile.c
$(INTDIR)/wvheader.obj: .\wvheader.c
$(INTDIR)/wvlist.obj:   .\wvlist.c
$(INTDIR)/wvmail.obj:   .\wvmail.c
$(INTDIR)/wvmapi.obj:   .\wvmapi.c
$(INTDIR)/wvprint.obj:  .\wvprint.c
$(INTDIR)/wvsckgen.obj: .\wvsckgen.c
$(INTDIR)/wvscreen.obj: .\wvscreen.c
$(INTDIR)/wvtxtblk.obj: .\wvtxtblk.c
$(INTDIR)/wvusenet.obj: .\wvusenet.cpp .\wvglob.h .\winvn.h\
			.\wvtb\wvtb.h .\version.h .\version.c\
			.\wvstates.h .\wvdlg.h
$(INTDIR)/winvn.res:    .\winvn.rc .\icobmp\winvn.ico\
			.\icobmp\wvgroup.ico .\icobmp\wvart.ico\
			.\icobmp\wvpost.ico .\icobmp\wvmail.ico\
			.\icobmp\dish.ico .\icobmp\wvcstat2.ico\
			.\icobmp\wvdebugc.ico .\icobmp\wvcstat1.ico\
			.\icobmp\art_tbar.bmp .\icobmp\wvtoolbr.bmp\
			.\icobmp\viewtbar.bmp .\icobmp\floppy.bmp\
			.\icobmp\harddrv.bmp .\icobmp\netdrive.bmp\
			.\icobmp\cdrom.bmp .\icobmp\ramdrive.bmp\
			.\icobmp\fldclose.bmp .\icobmp\fldopen.bmp\
			.\icobmp\fldsel.bmp .\winvn.h .\wvstates.h\
			.\gensock\gensock.h .\wvdlg.h .\version.h               
	$(rc) $(rcvars) /l 0x409 /fo$(INTDIR)/"winvn.res" .\winvn.rc
$(INTDIR)/wvstbar.obj:  .\wvstbar.c
$(INTDIR)/wvfiler.obj:  .\wvfiler.c
$(INTDIR)/wvpath.obj:   .\wvpath.c
$(INTDIR)/wvcompos.obj: .\wvcompos.c
$(INTDIR)/wvsend.obj:   .\wvsend.c .\wvglob.h .\winvn.h .\wvstates.h\
			.\wvdlg.h .\version.h
$(INTDIR)/wvfilter.obj: .\wvfilter.c
$(INTDIR)/wvgroup.obj:  .\wvgroup.cpp
$(INTDIR)/headarry.obj: .\headarry.cpp
$(INTDIR)/ini_news.obj: .\ini_news.cpp
$(INTDIR)/wvutil.obj:   .\wvutil.cpp .\wvglob.h .\winvn.h .\wvstates.h\
			.\wvdlg.h .\version.h

# simple_libs = $(conlibsmt) advapi32.lib shell32.lib

$(OUTDIR):
    if not exist $(OUTDIR)/nul mkdir $(OUTDIR)

install:
    copy $(OUTDIR)\$(PROJ).exe $(INSTDIR)

clean:
    del $(INTDIR)\*.obj $(INTDIR)\*.res $(OUTDIR)\*.lib 
    del $(INTDIR)\*.sb? $(INTDIR)\*.exp
    
cleaner: clean
    del $(OUTDIR)\*.exe $(OUTDIR)\*.dll
	
