/* NTFS authentication */

#include <stdio.h>

#include "ntfsauth.h"

int main(int argc, char** argv)
{
	LPSTR           FileName;
	struct nfsfattr attr;
	long            newuid = 0; 
	long            newgid = 0;
	long            mask = 0;

	if( argc > 1)
		FileName = argv[1];
	else
	{
		printf( "ntfsauth.exe <filename> <newuid> <newgid> <newrights>\n");
		printf( "             <newuid>  (decimal) != 0, unchanged\n");
		printf( "             <newgid>  (decimal) != 0, unchanged\n");
		printf( "             <newrights>  (hex)  != 0, unchanged\n");
		return 0;
	}
	if( argc > 2)
	{
		newuid = atol( argv[2]);
	}
	if( argc > 3)
	{
		newgid = atol( argv[3]);
	}
	if( argc > 4)
	{
		sscanf( argv[4], "%lx", &mask);
		printf( "Mask %lx\n", mask);
	}

	NtfsInitDrive( FileName);

	printf( "Get Owner, Group and permissions on:\n");
	printf( "   %s\n", FileName);

	attr.na_uid = newuid;
	attr.na_gid = newgid;
	attr.na_mode= mask;

	NtfsGetUnixAttrib( FileName, &attr);
	printf( "    Uid %ld, Gid %ld, Mode %lx\n", 
			attr.na_uid, attr.na_gid, attr.na_mode);


	if( newuid)
		attr.na_uid = newuid;
	if( newgid)
		attr.na_gid = newgid;
	if( mask)
		attr.na_mode= mask;

	GetLastError(); //Empty

	if( FALSE == NtfsSetUnixAttrib( FileName, &attr))
		printf( "NtfsSetUnixAttrib(), %d = GetLastError()\n", 
				GetLastError());


	NtfsGetUnixAttrib( FileName, &attr);

	printf( "    Uid %ld, Gid %ld, Mode %lx\n", 
			attr.na_uid, attr.na_gid, attr.na_mode);

	return 0;

}
