/*
 *  dtime.c --
 *      Converts dos to unix time, ie. # of seconds since Jan 1, 1970.
 *
 *  Author: See-Mong Tan
 */

#ifdef RCSID
static char _rcsid_ = "$Id: dtime.c_v 1.4 1991/04/11 20:35:05 richb Exp $";
#endif

#include "common.h"


/*
 *  bool_t dtime_init() --
 *      Initialize the time module.  Should be called before any other
 *	routine in this module.  Returns TRUE if no error occurs.
 */
bool_t dtime_init()
{
        // tzset tries to use the system settings - mwr
        if (!getenv ("TZ")) {
	    fprintf (stderr, "Using system timezone settings\n");
	    //fprintf (stderr, "Timezone not set; SET TZ and try again\n");
	    //return FALSE;
	}
	_tzset();		/* set global time variables */

	DBGPRT2 (nfsdebug, "timezone is GMT-%ld minutes; daylight is %d",
		 _timezone / 60, _daylight);
	return TRUE;
}

/* cumulative count of the days in a month */
static long dayspermonth[] = {
 	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365,
};

/*
 * long unixtime(unsigned time, unsigned date) --
 *      Converts DOS style time and date to UNIX style time, ie. # of
 *	seconds since midnight, Dec 31, 1969.
 */
long unixtime(time, date)
	unsigned time, date;
{
	long t = 0;
	long sec, min, hour, day, month, year, delY;
	
	
	sec = (long) ((time & 0x1f) << 1);
	min = (long) ((time >> 5) & 0x3f);
	hour = (long) ((time >> 11) & 0x1f);
	t = sec + min * 60 + hour * 60 * 60;

	day = (long) (date & 0x1f);
	t += (day - 1) * 24 * 60 * 60;			/* day of month */
	/* calculate the month */
	month = (long) ((date >> 5) & 0xf);		/* month field */
	t += dayspermonth[(int) month - 1] * 24 * 60 * 60;

	/* calculate the year */
	year = (long) (((date >> 9) & 0x7f) + 1980);	/* year field */
	//t += (year - 1970) * 365 * 24 * 60 * 60;	/* this can overflow - mwr */
	delY = year - 1970;
	t += delY * 365 * 24 * 60 * 60;

	/* now add the number of leap days since 1970 including this */
	t += (long) ((year - 1968) >> 2) * 24 * 60 * 60;

	if (year % 4 == 0 && month < 3)			/* this year is leap */
		t -= (long) 24 * 60 * 60;		/* take way 29 feb */
	t += _timezone;		/* take away difference in secs from GMT */

	return t;
}

/*
 * void dostime(long unixtime, unsigned *time, unsigned *date) --
 *      Converts Unix time (seconds since midnight) into DOS-style
 *      time format.
 *	seconds since midnight, Dec 31, 1969.
 */
void dostime (unixtime, date, time)
     long unixtime;
     unsigned *date, *time;
{
    struct tm *t;

    /* convert secs to time struct; adjust for time zone */
    unixtime -= _timezone;
    t = gmtime((time_t *) &unixtime);
    if (t == NULL) {
	*date = 0;
	*time = 0;
    }
    else {
	*date = t->tm_mday + ((t->tm_mon + 1) << 5) + ((t->tm_year - 80) << 9);
	*time = (t->tm_sec >> 1) + (t->tm_min << 5) + (t->tm_hour << 11);
    }
}
