/*
 *  bcopy.c --
 *      Implements bcopy(2) and bzero(2) byte operations.
 *
 *  Author:
 *      See-Mong Tan, 6/26/88
 */

#include <stdio.h>

/*
 *  bcopy(char *s1, char *s2, int len) --
 *      Copies len bytes from s1 to s2
 */
void
bcopy(s1, s2, len)
	char *s1, *s2;
	int len;
{
	for(; len > 0; len--)
		*s2++ = *s1++;
}

void
bcopy_nf(s1, s2, len)
	char *s1;
	char *s2;
	int len;
{
	for(; len > 0; len--)
		*s2++ = *s1++;
}

void
bcopy_fn(s1, s2, len)
	char *s1;
	char *s2;
	int len;
{
	for(; len > 0; len--)
		*s2++ = *s1++;
}

void
bcopy_ff(s1, s2, len)
	char *s1;
	char *s2;
	int len;
{
	for(; len > 0; len--)
		*s2++ = *s1++;
}

/*
 *  bzero(char *s, int len) --
 *      Places len zero byes in s
 */
void
bzero(s, len)
	char *s;
	int len;
{
	for(; len > 0; len--)
		*s++ = (char) 0;
}
