/*
 *  Filename    : dict.h
 *  Author      : David Harvey-George
 *  Start Date  : 13 May 1994
 *
 *  Copyright (C) 1994 DB Harvey-George
 *
 *  Description:
 *  Dict data structures.  To use the dict object declare the dict node
 *  at the top of your structure:
 *
 *      struct {
 *          Node_t InheritedNode;
 *          ...
 *      } MyNode;
 *
 *  The dict code does nothing to protect itself against misuse.  That is,
 *  it adds the supplied node to the dict and returns reference to node in
 *  the dict.  This is dangerous.
 *
 *  $Log$
 */

#ifndef _DICT_
#define _DICT_

typedef void* Id;	/* an abstract data type */

typedef struct Node {
    struct Node *Next;
} Node_t;

#define NULLNODE ((Node_t *) 0)

typedef struct {
    Node_t *Head;
    int    (*Compare)();
    int    Count;
} Dict_t;


/*
 *  Function prototypes  Public Interface.
 */
void     initDict( Dict_t *Dict, int (*Compare)() );

/*
 *  Adds an element onto the dict.  The dict is sorted.
 */
int      addNode( Dict_t *Dict, Node_t *Node);

/*
 *  GetNode: returns a reference to a node.
 */
Node_t * getNode( Dict_t *Dict, Id Name );
/*
 *  Removes, and returns a reference to a node on the dict
 */
Node_t * removeNode( Dict_t *Dict, Id Name);
/*
 *  Returns a reference to the first node on the dict
 */
Node_t * getFirstNode( Dict_t *Dict );
/*
 *  Returns a reference to next node after the one supplied
 */
Node_t * getNextNode( Dict_t *Dict, Id Name );

#endif /* _DICT_ */
