#include "test.h"
#pragma hdrstop

void list_features( DWORD low, DWORD high );

void test_CTape( UINT tape_drive_number_to_test )
{
   CTape tape;

   if ( tape.Open( tape_drive_number_to_test ) != TRUE )
   {
      TRACE( "Can't open TAPE%u because\n", tape_drive_number_to_test );
      ReportError( tape.GetError() );
      return;
   }
   else
   {
      TRACE( "Tape opened\n" );
   }

   if ( tape.Lock() != TRUE )
   {
      TRACE( "Can't Lock TAPE%u because\n", tape_drive_number_to_test );
      ReportError( tape.GetError() );
      return;
   }
   else
   {
      TRACE( "Tape locked\n" );
   }

   if ( tape.Load() != TRUE )
   {
      TRACE( "Can't Load TAPE%u because\n", tape_drive_number_to_test );
      ReportError( tape.GetError() );
      return;
   }
   else
   {
      TRACE( "Tape loaded\n" );
   }

   CTapeGetDriveParameters drive_parameters;

   if ( tape.GetParameters( drive_parameters ) != TRUE )
   {
      TRACE( "Can't get drive parameters TAPE%u\n", tape_drive_number_to_test );
      ReportError( tape.GetError() );
      return;
   }

   TRACE( "Drive Parameters:\n" );
   TRACE( "  ECC                   = %s\n", ( ( drive_parameters.ECC            == TRUE ) ? "True" : "False" ) );
   TRACE( "  Compression           = %s\n", ( ( drive_parameters.Compression    == TRUE ) ? "True" : "False" ) );
   TRACE( "  DataPadding           = %s\n", ( ( drive_parameters.DataPadding    == TRUE ) ? "True" : "False" ) );
   TRACE( "  ReportSetmarks        = %s\n", ( ( drive_parameters.ReportSetmarks == TRUE ) ? "True" : "False" ) );
   TRACE( "  DefaultBlockSize      = %ld\n", drive_parameters.DefaultBlockSize );
   TRACE( "  MaximumBlockSize      = %ld\n", drive_parameters.MaximumBlockSize );
   TRACE( "  MinimumBlockSize      = %ld\n", drive_parameters.MinimumBlockSize );
   TRACE( "  MaximumPartitionCount = %ld\n", drive_parameters.MaximumPartitionCount );
   TRACE( "  FeaturesLow           = %lX\n", drive_parameters.FeaturesLow );
   TRACE( "  FeaturesHigh          = %lX\n", drive_parameters.FeaturesHigh );
   TRACE( "  EOTWarningZoneSize    = %ld\n", drive_parameters.EOTWarningZoneSize );

   list_features( drive_parameters.FeaturesLow, drive_parameters.FeaturesHigh );

   /*
   ** Lock the tape
   */

   BYTE buffer[ 256 ];

   ZeroMemory( buffer, sizeof( buffer ) );

   DWORD number_of_bytes_read = 0;

   if ( ReadFile( (HANDLE) tape.m_hFile, buffer, sizeof( buffer ), &number_of_bytes_read, NULL ) != TRUE )
   {
      TRACE( "Can't ReadFile TAPE%u\n", tape_drive_number_to_test );
      ReportError( GetLastError() );
   }
   else
   {
      DWORD index = 0;

      while( index < number_of_bytes_read )
      {
         TRACE( "%03d - %02X - %c\n", index, (int) buffer[ index ], (char) buffer[ index ] );
         index++;
      }
   }

   CTapeGetMediaParameters media_parameters;

   if ( tape.GetParameters( media_parameters ) != TRUE )
   {
      TRACE( "Can't get media parameters TAPE%u\n", tape_drive_number_to_test );
      ReportError( tape.GetError() );
      return;
   }
   else
   {
      TRACE( "Media Parameters:\n" );
      TRACE( "  Capacity.Low   = %lu\n", media_parameters.Capacity.LowPart   );
      TRACE( "  Capacity.High  = %lu\n", media_parameters.Capacity.HighPart  );
      TRACE( "  Remaining.Low  = %lu\n", media_parameters.Remaining.LowPart  );
      TRACE( "  Remaining.High = %lu\n", media_parameters.Remaining.HighPart );
      TRACE( "  PartitionCount = %lu\n", media_parameters.PartitionCount     );
      TRACE( "  WriteProtected = %s\n", ( ( media_parameters.WriteProtected == TRUE ) ? "True" : "False" ) );
   }

   if ( tape.Unlock() != TRUE )
   {
      TRACE( "Can't Unlock TAPE%u because\n", tape_drive_number_to_test );
      ReportError( tape.GetError() );
      return;
   }
   else
   {
      TRACE( "Tape unlocked\n" );
   }

   if ( tape.Unload() != TRUE )
   {
      TRACE( "Can't Unload TAPE%u because\n", tape_drive_number_to_test );
      ReportError( tape.GetError() );
      return;
   }
   else
   {
      TRACE( "Tape unloaded\n" );
   }

   tape.Close();
}

void list_features( DWORD low, DWORD high )
{
   if ( low & TAPE_DRIVE_COMPRESSION )
   {
      TRACE( "Device supports hardware data compression.\n" );
   }

   if ( low & TAPE_DRIVE_ECC )
   {
      TRACE( "Device supports hardware error correction.\n" );
   }

   if ( low & TAPE_DRIVE_ERASE_BOP_ONLY )
   {
      TRACE( "Device performs the erase operation from the beginning-of-partition marker only.\n" );
   }

   if ( low & TAPE_DRIVE_ERASE_LONG )
   {
      TRACE( "Device performs a long erase operation.\n" );
   }

   if ( low & TAPE_DRIVE_ERASE_IMMEDIATE )
   {
      TRACE( "Device performs an immediate erase operation that is, it returns when the erase operation begins.\n" );
   }

   if ( low & TAPE_DRIVE_ERASE_SHORT )
   {
      TRACE( "Device performs a short erase operation.\n" );
   }

   if ( low & TAPE_DRIVE_FIXED )
   {
      TRACE( "Device creates fixed data partitions.\n" );
   }

   if ( low & TAPE_DRIVE_FIXED_BLOCK )
   {
      TRACE( "Device supports fixed-length block mode.\n" );
   }

   if ( low & TAPE_DRIVE_INITIATOR )
   {
      TRACE( "Device creates initiator-defined partitions.\n" );
   }

   if ( low & TAPE_DRIVE_PADDING )
   {
      TRACE( "Device supports data padding.\n" );
   }

   if ( low & TAPE_DRIVE_GET_ABSOLUTE_BLK )
   {
      TRACE( "Device provides the current device-specific block address.\n" );
   }

   if ( low & TAPE_DRIVE_GET_LOGICAL_BLK )
   {
      TRACE( "Device provides the current logical block address (and logical tape partition).\n" );
   }

   if ( low & TAPE_DRIVE_REPORT_SMKS )
   {
      TRACE( "Device supports setmark reporting.\n" );
   }

   if ( low & TAPE_DRIVE_SELECT )
   {
      TRACE( "Device creates select data partitions.\n" );
   }

   if ( low & TAPE_DRIVE_SET_EOT_WZ_SIZE )
   {
      TRACE( "Device supports setting the end-of-medium warning size.\n" );
   }

   if ( low & TAPE_DRIVE_TAPE_CAPACITY )
   {
      TRACE( "Device returns the maximum capacity of the tape.\n" );
   }

   if ( low & TAPE_DRIVE_TAPE_REMAINING )
   {
      TRACE( "Device returns the remaining capacity of the tape.\n" );
   }

   if ( low & TAPE_DRIVE_VARIABLE_BLOCK )
   {
      TRACE( "Device supports variable-length block mode.\n" );
   }

   if ( low & TAPE_DRIVE_WRITE_PROTECT )
   {
      TRACE( "Device returns an error if the tape is write-enabled or write-protected.\n" );
   }

   if ( high & TAPE_DRIVE_ABS_BLK_IMMED )
   {
      TRACE( "Device moves the tape to a device-specific block address and returns as soon as the move begins.\n" );
   }

   if ( high & TAPE_DRIVE_ABSOLUTE_BLK )
   {
      TRACE( "Device moves the tape to a device specific block address.\n" );
   }

   if ( high & TAPE_DRIVE_END_OF_DATA )
   {
      TRACE( "Device moves the tape to the end-of-data marker in a partition.\n" );
   }

   if ( high & TAPE_DRIVE_FILEMARKS )
   {
      TRACE( "Device moves the tape forward (or backward) a specified number of filemarks.\n" );
   }

   if ( high & TAPE_DRIVE_LOAD_UNLOAD )
   {
      TRACE( "Device enables and disables the device for further operations.\n" );
   }

   if ( high & TAPE_DRIVE_LOAD_UNLD_IMMED )
   {
      TRACE( "Device supports immediate load and unload operations.\n" );
   }

   if ( high & TAPE_DRIVE_LOCK_UNLOCK )
   {
      TRACE( "Device enables and disables the tape ejection mechanism.\n" );
   }

   if ( high & TAPE_DRIVE_LOCK_UNLK_IMMED )
   {
      TRACE( "Device supports immediate lock and unlock operations.\n" );
   }

   if ( high & TAPE_DRIVE_LOG_BLK_IMMED )
   {
      TRACE( "Device moves the tape to a logical block address in a partition and returns as soon as the move begins.\n" );
   }

   if ( high & TAPE_DRIVE_LOGICAL_BLK )
   {
      TRACE( "Device moves the tape to a logical block address in a partition.\n" );
   }

   if ( high & TAPE_DRIVE_RELATIVE_BLKS )
   {
      TRACE( "Device moves the tape forward (or backward) a specified number of blocks.\n" );
   }

   if ( high & TAPE_DRIVE_REVERSE_POSITION )
   {
      TRACE( "Device moves the tape backward over blocks, filemarks, or setmarks.\n" );
   }

   if ( high & TAPE_DRIVE_REWIND_IMMEDIATE )
   {
      TRACE( "Device supports immediate rewind operation.\n" );
   }

   if ( high & TAPE_DRIVE_SEQUENTIAL_FMKS )
   {
      TRACE( "Device moves the tape forward (or backward) to the first occurrence of a specified number of consecutive filemarks.\n" );
   }

   if ( high & TAPE_DRIVE_SEQUENTIAL_SMKS )
   {
      TRACE( "Device moves the tape forward (or backward) to the first occurrence of a specified number of consecutive setmarks.\n" );
   }

   if ( high & TAPE_DRIVE_SET_BLOCK_SIZE )
   {
      TRACE( "Device supports setting the size of a fixed-length logical block or setting the variable-length block mode.\n" );
   }

   if ( high & TAPE_DRIVE_SET_COMPRESSION )
   {
      TRACE( "Device enables and disables hardware data compression.\n" );
   }

   if ( high & TAPE_DRIVE_SET_ECC )
   {
      TRACE( "Device enables and disables hardware error correction.\n" );
   }

   if ( high & TAPE_DRIVE_SET_PADDING )
   {
      TRACE( "Device enables and disables data padding.\n" );
   }

   if ( high & TAPE_DRIVE_SET_REPORT_SMKS )
   {
      TRACE( "Device enables and disables the reporting of setmarks.\n" );
   }

   if ( high & TAPE_DRIVE_SETMARKS )
   {
      TRACE( "Device moves the tape forward (or reverse) a specified number of setmarks.\n" );
   }

   if ( high & TAPE_DRIVE_SPACE_IMMEDIATE )
   {
      TRACE( "Device supports immediate spacing.\n" );
   }

   if ( high & TAPE_DRIVE_TENSION )
   {
      TRACE( "Device supports tape tensioning.\n" );
   }

   if ( high & TAPE_DRIVE_TENSION_IMMED )
   {
      TRACE( "Device supports immediate tape tensioning.\n" );
   }

   if ( high & TAPE_DRIVE_WRITE_FILEMARKS )
   {
      TRACE( "Device writes filemarks.\n" );
   }

   if ( high & TAPE_DRIVE_WRITE_LONG_FMKS )
   {
      TRACE( "Device writes long filemarks.\n" );
   }

   if ( high & TAPE_DRIVE_WRITE_MARK_IMMED )
   {
      TRACE( "Device supports immediate writing of short and long filemarks.\n" );
   }

   if ( high & TAPE_DRIVE_WRITE_SETMARKS )
   {
      TRACE( "Device writes setmarks.\n" );
   }

   if ( high & TAPE_DRIVE_WRITE_SHORT_FMKS )
   {
      TRACE( "Device writes short filemarks.\n" );
   }

   if ( high & TAPE_DRIVE_FORMAT )
   {
      TRACE( "TAPE_DRIVE_FORMAT\n" );
   }

   if ( high & TAPE_DRIVE_FORMAT_IMMEDIATE )
   {
      TRACE( "TAPE_DRIVE_FORMAT_IMMEDIATE\n" );
   }
}
