#include "test.h"
#pragma hdrstop

void print_information( CNetworkSessionInformation& information )
{
   printf( "\"%s\" - \"%s\" - %d - %s - %s - %d - \"%s\" - \"%s\"\n",
           (LPCTSTR) information.ClientName,
           (LPCTSTR) information.UserName,
                     information.NumberOfOpens,
           (LPCTSTR) information.Time.Format( "%H:%M:%S" ),
           (LPCTSTR) information.IdleTime.Format( "%H:%M:%S" ),
                     information.UserFlags,
           (LPCTSTR) information.ClientTypeName,
           (LPCTSTR) information.Transport );
}

void test_CNetSession( LPCTSTR machine_name )
{
   CNetworkSessions session;

   CNetworkSessionInformation information;

   session.Open( machine_name );

   if ( session.Enumerate( information ) )
   {
      print_information( information );

      while( session.GetNext( information ) )
      {
         print_information( information );
      }
   }
   else
   {
      DWORD error_code = session.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetSession.ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }
}

