#include "test.h"
#pragma hdrstop

void print_resource( CNetworkResourceInformation& information )
{
   printf( "\"%s\" - \"%s\" - \"%s\" - \"%s\"\n",
           (LPCTSTR) information.LocalName,
           (LPCTSTR) information.RemoteName,
           (LPCTSTR) information.Comment,
           (LPCTSTR) information.Provider );
}

void test_CNetResource( void )
{
   CNetworkResources net_resource;

   CNetworkResourceInformation information;

   information.Scope = CNetworkResources::scopeAll;
   information.Usage = CNetworkResources::usageConnectable | CNetworkResources::usageContainer;
   information.Type  = CNetworkResources::typeDisk;

   if ( net_resource.Enumerate( information ) )
   {
      print_resource( information );

      while( net_resource.GetNext( information ) )
      {
         print_resource( information );
      }

      DWORD error_code = net_resource.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetSession.ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }
   else
   {
      DWORD error_code = net_resource.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetSession.ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }
}

