#include "test.h"
#pragma hdrstop

void test_CNetWorkstation( LPCTSTR machine_name )
{
   CNetWorkstation workstation( machine_name );

   CWorkstationInformation workstation_information;

   if ( workstation.EnumerateInformation() == TRUE )
   {
      printf( "Workstation Machine Information:\n" );

      while( workstation.GetNext( workstation_information ) == TRUE )
      {
         printf( " PlatformID            - %d\n",               workstation_information.PlatformID            );
         printf( " Name                  - \"%s\"\n", (LPCTSTR) workstation_information.ComputerName          );
         printf( " LANGroup              - \"%s\"\n", (LPCTSTR) workstation_information.LANGroup              );
         printf( " MajorVersion          - %d\n",               workstation_information.MajorVersion          );
         printf( " MinorVersion          - %d\n",               workstation_information.MinorVersion          );
         printf( " LANRoot               - \"%s\"\n", (LPCTSTR) workstation_information.LANRoot               );
         printf( " NumberOfLoggedOnUsers - %d\n",               workstation_information.NumberOfLoggedOnUsers );
      }
   }
   else
   {
      DWORD error_code = workstation.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetWorkstation.Enumerate( workstation_information ), ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }

   CWorkstationUser user_information;

   if ( workstation.EnumerateUsers() == TRUE )
   {
      printf( "\nWorkstation User Information:\n" );

      WCHAR wide_machine_name[ 256 ];
      WCHAR wide_domain_name[ 256 ];

      LPSTR buffer = NULL;

      ZeroMemory( wide_machine_name, sizeof( wide_machine_name ) );
      ZeroMemory( wide_domain_name,  sizeof( wide_domain_name  ) );

      while( workstation.GetNext( user_information ) == TRUE )
      {
         ASCII_to_UNICODE( (LPCTSTR) user_information.LogonServer, wide_machine_name );
         ASCII_to_UNICODE( (LPCTSTR) user_information.LogonDomain, wide_domain_name  );

         NetGetDCName( wide_machine_name, wide_domain_name, (LPBYTE *) &buffer );
         UNICODE_to_ASCII( (LPCWSTR) buffer, buffer );

         printf( " User Name     - \"%s\"\n",   (LPCTSTR) user_information.UserName     );
         printf( " Logon Domain  - \"%s\" [%s]\n",   (LPCTSTR) user_information.LogonDomain, (LPSTR) buffer );
         printf( " Other Domains - \"%s\"\n",   (LPCTSTR) user_information.OtherDomains );
         printf( " Logon Server  - \"%s\"\n\n", (LPCTSTR) user_information.LogonServer  );
      }
   }
   else
   {
      DWORD error_code = workstation.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetWorkstation.Enumerate( user_information ), ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }

   user_information.Empty();

   if ( workstation.GetCurrentUser( user_information ) == TRUE )
   {
      printf( "\nWorkstation Current User Information:\n" );
      printf( " User Name     - \"%s\"\n", (LPCTSTR) user_information.UserName     );
      printf( " Logon Domain  - \"%s\"\n", (LPCTSTR) user_information.LogonDomain  );
      printf( " Other Domains - \"%s\"\n", (LPCTSTR) user_information.OtherDomains );
      printf( " Logon Server  - \"%s\"\n", (LPCTSTR) user_information.LogonServer  );
   }
   else
   {
      DWORD error_code = workstation.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetWorkstation.GetCurrentUser( user_information ), ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }

   CWorkstationTransport transport_information;

   if ( workstation.EnumerateTransports() == TRUE )
   {
      printf( "\nWorkstation Transport Information:\n" );

      while( workstation.GetNext( transport_information ) == TRUE )
      {
         printf( " Quality of Service         - %d\n", transport_information.QualityOfService        );
         printf( " Number Of Virtual Circuits - %d\n", transport_information.NumberOfVirtualCircuits );
         printf( " Name                       - \"%s\"\n", (LPCTSTR) transport_information.Name      );
         printf( " Address                    - \"%s\"\n", (LPCTSTR) transport_information.Address   );
   
         if ( transport_information.WANish == TRUE )
         {
            printf( " WANish                     - TRUE\n\n" );
         }
         else
         {
            printf( " WANish                     - FALSE\n\n" );
         }
      }
   }
   else
   {
      DWORD error_code = workstation.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetWorkstation.Enumerate( transport_information ), ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }
}

