#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#define new DEBUG_NEW
#endif

void Convert_NERR_Code_to_String( DWORD error_code, CString& error_message )
{
   switch( error_code )
   {
      case NERR_Success:

         error_message = "Success.";
         return;

      case NERR_NetNotStarted:
   
         error_message = "The workstation driver is not installed.";
         return;

      case NERR_UnknownServer:
   
         error_message = "The server could not be located.";
         return;

      case NERR_ShareMem:
   
         error_message = "An internal error occurred. The network cannot access a shared memory segment.";
         return;

      case NERR_NoNetworkResource:
   
         error_message = "A network resource shortage occurred.";
         return;

      case NERR_RemoteOnly:
   
         error_message = "This operation is not supported on workstations.";
         return;

      case NERR_DevNotRedirected:
   
         error_message = "The device is not connected.";
         return;

      case NERR_ServerNotStarted:
   
         error_message = "The Server service is not started.";
         return;

      case NERR_ItemNotFound:
   
         error_message = "The queue is empty.";
         return;

      case NERR_UnknownDevDir:
   
         error_message = "The device or directory does not exist.";
         return;

      case NERR_RedirectedPath:
   
         error_message = "The operation is invalid on a redirected resource.";
         return;

      case NERR_DuplicateShare:
   
         error_message = "The name has already been shared.";
         return;

      case NERR_NoRoom:
   
         error_message = "The server is currently out of the requested resource.";
         return;

      case NERR_TooManyItems:
   
         error_message = "Requested addition of items exceeds the maximum allowed.";
         return;

      case NERR_InvalidMaxUsers:
   
         error_message = "The Peer service supports only two simultaneous users.";
         return;

      case NERR_BufTooSmall:
   
         error_message = "The API return buffer is too small.";
         return;

      case NERR_RemoteErr:
   
         error_message = "A remote API error occurred.";
         return;

      case NERR_LanmanIniError:
   
         error_message = "An error occurred when opening or reading the configuration file.";
         return;

      case NERR_NetworkError:
   
         error_message = "A general network error occurred.";
         return;

      case NERR_WkstaInconsistentState:
   
         error_message = "The Workstation service is in an inconsistent state. Restart the computer before restarting the Workstation service.";
         return;

      case NERR_WkstaNotStarted:
   
         error_message = "The Workstation service has not been started.";
         return;

      case NERR_BrowserNotStarted:
   
         error_message = "The requested information is not available.";
         return;

      case NERR_InternalError:
   
         error_message = "An internal Windows NT error occurred.";
         return;

      case NERR_BadTransactConfig:
   
         error_message = "The server is not configured for transactions.";
         return;

      case NERR_InvalidAPI:
   
         error_message = "The requested API is not supported on the remote server.";
         return;

      case NERR_BadEventName:
   
         error_message = "The event name is invalid.";
         return;

      case NERR_DupNameReboot:
   
         error_message = "The computer name already exists on the network. Change it and restart the computer.";
         return;

      case NERR_CfgCompNotFound:
   
         error_message = "The specified component could not be found in the configuration information.";
         return;

      case NERR_CfgParamNotFound:
   
         error_message = "The specified parameter could not be found in the configuration information.";
         return;

      case NERR_LineTooLong:
   
         error_message = "A line in the configuration file is too long.";
         return;

      case NERR_QNotFound:
   
         error_message = "The printer does not exist.";
         return;

      case NERR_JobNotFound:
   
         error_message = "The print job does not exist.";
         return;

      case NERR_DestNotFound:
   
         error_message = "The printer destination cannot be found.";
         return;

      case NERR_DestExists:
   
         error_message = "The printer destination already exists.";
         return;

      case NERR_QExists:
   
         error_message = "The printer queue already exists.";
         return;

      case NERR_QNoRoom:
   
         error_message = "No more printers can be added.";
         return;

      case NERR_JobNoRoom:
   
         error_message = "No more print jobs can be added.";
         return;

      case NERR_DestNoRoom:
   
         error_message = "No more printer destinations can be added.";
         return;

      case NERR_DestIdle:
   
         error_message = "This printer destination is idle and cannot accept control operations.";
         return;

      case NERR_DestInvalidOp:
   
         error_message = "This printer destination request contains an invalid control function.";
         return;

      case NERR_ProcNoRespond:
   
         error_message = "The print processor is not responding.";
         return;

      case NERR_SpoolerNotLoaded:
   
         error_message = "The spooler is not running.";
         return;

      case NERR_DestInvalidState:
   
         error_message = "This operation cannot be performed on the print destination in its current state.";
         return;

      case NERR_QInvalidState:
   
         error_message = "This operation cannot be performed on the printer queue in its current state.";
         return;

      case NERR_JobInvalidState:
   
         error_message = "This operation cannot be performed on the print job in its current state.";
         return;

      case NERR_SpoolNoMemory:
   
         error_message = "A spooler memory allocation failure occurred.";
         return;

      case NERR_DriverNotFound:
   
         error_message = "The device driver does not exist.";
         return;

      case NERR_DataTypeInvalid:
   
         error_message = "The data type is not supported by the print processor.";
         return;

      case NERR_ProcNotFound:
   
         error_message = "The print processor is not installed.";
         return;

      case NERR_ServiceTableLocked:
   
         error_message = "The service database is locked.";
         return;

      case NERR_ServiceTableFull:
   
         error_message = "The service table is full.";
         return;

      case NERR_ServiceInstalled:
   
         error_message = "The requested service has already been started.";
         return;

      case NERR_ServiceEntryLocked:
   
         error_message = "The service does not respond to control actions.";
         return;

      case NERR_ServiceNotInstalled:
   
         error_message = "The service has not been started.";
         return;

      case NERR_BadServiceName:
   
         error_message = "The service name is invalid.";
         return;

      case NERR_ServiceCtlTimeout:
   
         error_message = "The service is not responding to the control function.";
         return;

      case NERR_ServiceCtlBusy:
   
         error_message = "The service control is busy.";
         return;

      case NERR_BadServiceProgName:
   
         error_message = "The configuration file contains an invalid service program name.";
         return;

      case NERR_ServiceNotCtrl:
   
         error_message = "The service could not be controlled in its present state.";
         return;

      case NERR_ServiceKillProc:
   
         error_message = "The service ended abnormally.";
         return;

      case NERR_ServiceCtlNotValid:
   
         error_message = "The requested pause or stop is not valid for this service.";
         return;

      case NERR_NotInDispatchTbl:
   
         error_message = "The service control dispatcher could not find the service name in the dispatch table.";
         return;

      case NERR_BadControlRecv:
   
         error_message = "The service control dispatcher pipe read failed.";
         return;

      case NERR_ServiceNotStarting:
   
         error_message = "A thread for the new service could not be created.";
         return;

      case NERR_AlreadyLoggedOn:
   
         error_message = "This workstation is already logged on to the local-area network.";
         return;

      case NERR_NotLoggedOn:
   
         error_message = "The workstation is not logged on to the local-area network.";
         return;

      case NERR_BadUsername:
   
         error_message = "The user name or group name parameter is invalid.";
         return;

      case NERR_BadPassword:
   
         error_message = "The password parameter is invalid.";
         return;

      case NERR_UnableToAddName_W:
   
         error_message = "@W The logon processor did not add the message alias.";
         return;

      case NERR_UnableToAddName_F:
   
         error_message = "The logon processor did not add the message alias.";
         return;

      case NERR_UnableToDelName_W:
   
         error_message = "@W The logoff processor did not delete the message alias.";
         return;

      case NERR_UnableToDelName_F:
   
         error_message = "The logoff processor did not delete the message alias.";
         return;

      case NERR_LogonsPaused:
   
         error_message = "Network logons are paused.";
         return;

      case NERR_LogonServerConflict:
   
         error_message = "A centralized logon-server conflict occurred.";
         return;

      case NERR_LogonNoUserPath:
   
         error_message = "The server is configured without a valid user path.";
         return;

      case NERR_LogonScriptError:
   
         error_message = "An error occurred while loading or running the logon script.";
         return;

      case NERR_StandaloneLogon:
   
         error_message = "The logon server was not specified. Your computer will be logged on as STANDALONE.";
         return;

      case NERR_LogonServerNotFound:
   
         error_message = "The logon server could not be found.";
         return;

      case NERR_LogonDomainExists:
   
         error_message = "There is already a logon domain for this computer.";
         return;

      case NERR_NonValidatedLogon:
   
         error_message = "The logon server could not validate the logon.";
         return;

      case NERR_ACFNotFound:
   
         error_message = "The security database could not be found.";
         return;

      case NERR_GroupNotFound:
   
         error_message = "The group name could not be found.";
         return;

      case NERR_UserNotFound:
   
         error_message = "The user name could not be found.";
         return;

      case NERR_ResourceNotFound:
   
         error_message = "The resource name could not be found.";
         return;

      case NERR_GroupExists:
   
         error_message = "The group already exists.";
         return;

      case NERR_UserExists:
   
         error_message = "The user account already exists.";
         return;

      case NERR_ResourceExists:
   
         error_message = "The resource permission list already exists.";
         return;

      case NERR_NotPrimary:
   
         error_message = "This operation is only allowed on the primary domain controller of the domain.";
         return;

      case NERR_ACFNotLoaded:
   
         error_message = "The security database has not been started.";
         return;

      case NERR_ACFNoRoom:
   
         error_message = "There are too many names in the user accounts database.";
         return;

      case NERR_ACFFileIOFail:
   
         error_message = "A disk I/O failure occurred.";
         return;

      case NERR_ACFTooManyLists:
   
         error_message = "The limit of 64 entries per resource was exceeded.";
         return;

      case NERR_UserLogon:
   
         error_message = "Deleting a user with a session is not allowed.";
         return;

      case NERR_ACFNoParent:
   
         error_message = "The parent directory could not be located.";
         return;

      case NERR_CanNotGrowSegment:
   
         error_message = "Unable to add to the security database session cache segment.";
         return;

      case NERR_SpeGroupOp:
   
         error_message = "This operation is not allowed on this special group.";
         return;

      case NERR_NotInCache:
   
         error_message = "This user is not cached in user accounts database session cache.";
         return;

      case NERR_UserInGroup:
   
         error_message = "The user already belongs to this group.";
         return;

      case NERR_UserNotInGroup:
   
         error_message = "The user does not belong to this group.";
         return;

      case NERR_AccountUndefined:
   
         error_message = "This user account is undefined.";
         return;

      case NERR_AccountExpired:
   
         error_message = "This user account has expired.";
         return;

      case NERR_InvalidWorkstation:
   
         error_message = "The user is not allowed to log on from this workstation.";
         return;

      case NERR_InvalidLogonHours:
   
         error_message = "The user is not allowed to log on at this time.";
         return;

      case NERR_PasswordExpired:
   
         error_message = "The password of this user has expired.";
         return;

      case NERR_PasswordCantChange:
   
         error_message = "The password of this user cannot change.";
         return;

      case NERR_PasswordHistConflict:
   
         error_message = "This password cannot be used now.";
         return;

      case NERR_PasswordTooShort:
   
         error_message = "The password is shorter than required.";
         return;

      case NERR_PasswordTooRecent:
   
         error_message = "The password of this user is too recent to change.";
         return;

      case NERR_InvalidDatabase:
   
         error_message = "The security database is corrupted.";
         return;

      case NERR_DatabaseUpToDate:
   
         error_message = "No updates are necessary to this replicant network/local security database.";
         return;

      case NERR_SyncRequired:
   
         error_message = "This replicant database is outdated; synchronization is required.";
         return;

      case NERR_UseNotFound:
   
         error_message = "The network connection could not be found.";
         return;

      case NERR_BadAsgType:
   
         error_message = "This asg_type is invalid.";
         return;

      case NERR_DeviceIsShared:
   
         error_message = "This device is currently being shared.";
         return;

      case NERR_NoComputerName:
   
         error_message = "The computer name could not be added as a message alias. The name may already exist on the network.";
         return;

      case NERR_MsgAlreadyStarted:
   
         error_message = "The Messenger service is already started.";
         return;

      case NERR_MsgInitFailed:
   
         error_message = "The Messenger service failed to start.";
         return;

      case NERR_NameNotFound:
   
         error_message = "The message alias could not be found on the network.";
         return;

      case NERR_AlreadyForwarded:
   
         error_message = "This message alias has already been forwarded.";
         return;

      case NERR_AddForwarded:
   
         error_message = "This message alias has been added but is still forwarded.";
         return;

      case NERR_AlreadyExists:
   
         error_message = "This message alias already exists locally.";
         return;

      case NERR_TooManyNames:
   
         error_message = "The maximum number of added message aliases has been exceeded.";
         return;

      case NERR_DelComputerName:
   
         error_message = "The computer name could not be deleted.";
         return;

      case NERR_LocalForward:
   
         error_message = "Messages cannot be forwarded back to the same workstation.";
         return;

      case NERR_GrpMsgProcessor:
   
         error_message = "An error occurred in the domain message processor.";
         return;

      case NERR_PausedRemote:
   
         error_message = "The message was sent, but the recipient has paused the Messenger service.";
         return;

      case NERR_BadReceive:
   
         error_message = "The message was sent but not received.";
         return;

      case NERR_NameInUse:
   
         error_message = "The message alias is currently in use. Try again later.";
         return;

      case NERR_MsgNotStarted:
   
         error_message = "The Messenger service has not been started.";
         return;

      case NERR_NotLocalName:
   
         error_message = "The name is not on the local computer.";
         return;

      case NERR_NoForwardName:
   
         error_message = "The forwarded message alias could not be found on the network.";
         return;

      case NERR_RemoteFull:
   
         error_message = "The message alias table on the remote station is full.";
         return;

      case NERR_NameNotForwarded:
   
         error_message = "Messages for this alias are not currently being forwarded.";
         return;

      case NERR_TruncatedBroadcast:
   
         error_message = "The broadcast message was truncated.";
         return;

      case NERR_InvalidDevice:
   
         error_message = "This is an invalid device name.";
         return;

      case NERR_WriteFault:
   
         error_message = "A write fault occurred.";
         return;

      case NERR_DuplicateName:
   
         error_message = "A duplicate message alias exists on the network.";
         return;

      case NERR_DeleteLater:
   
         error_message = "@W This message alias will be deleted later.";
         return;

      case NERR_IncompleteDel:
   
         error_message = "The message alias was not successfully deleted from all networks.";
         return;

      case NERR_MultipleNets:
   
         error_message = "This operation is not supported on computers with multiple networks.";
         return;

      case NERR_NetNameNotFound:
   
         error_message = "This shared resource does not exist.";
         return;

      case NERR_DeviceNotShared:
   
         error_message = "This device is not shared.";
         return;

      case NERR_ClientNameNotFound:
   
         error_message = "A session does not exist with that computer name.";
         return;

      case NERR_FileIdNotFound:
   
         error_message = "There is not an open file with that identification number.";
         return;

      case NERR_ExecFailure:
   
         error_message = "A failure occurred when executing a remote administration command.";
         return;

      case NERR_TmpFile:
   
         error_message = "A failure occurred when opening a remote temporary file.";
         return;

      case NERR_TooMuchData:
   
         error_message = "The data    returned from a remote administration command has been truncated to 64K.";
         return;

      case NERR_DeviceShareConflict:
   
         error_message = "This device cannot be shared as both a spooled and a non-spooled resource.";
         return;

      case NERR_BrowserTableIncomplete:
   
         error_message = "The information in the list of servers may be incorrect.";
         return;

      case NERR_NotLocalDomain:
   
         error_message = "The computer is not active in this domain.";
         return;

      case NERR_DevInvalidOpCode:
   
         error_message = "The operation is invalid for this device.";
         return;

      case NERR_DevNotFound:
   
         error_message = "This device cannot be shared.";
         return;

      case NERR_DevNotOpen:
   
         error_message = "This device was not open.";
         return;

      case NERR_BadQueueDevString:
   
         error_message = "This device name list is invalid.";
         return;

      case NERR_BadQueuePriority:
   
         error_message = "The queue priority is invalid.";
         return;

      case NERR_NoCommDevs:
   
         error_message = "There are no shared communication devices.";
         return;

      case NERR_QueueNotFound:
   
         error_message = "The queue you specified does not exist.";
         return;

      case NERR_BadDevString:
   
         error_message = "This list of devices is invalid.";
         return;

      case NERR_BadDev:
   
         error_message = "The requested device is invalid.";
         return;

      case NERR_InUseBySpooler:
   
         error_message = "This device is already in use by the spooler.";
         return;

      case NERR_CommDevInUse:
   
         error_message = "This device is already in use as a communication device.";
         return;

      case NERR_InvalidComputer:
   
         error_message = "This computer name is invalid.";
         return;

      case NERR_MaxLenExceeded:
   
         error_message = "The string and prefix specified are too long.";
         return;

      case NERR_BadComponent:
   
         error_message = "This path component is invalid.";
         return;

      case NERR_CantType:
   
         error_message = "Could not determine the type of input.";
         return;

      case NERR_TooManyEntries:
   
         error_message = "The buffer for types is not big enough.";
         return;

      case NERR_ProfileFileTooBig:
   
         error_message = "Profile files cannot exceed 64K.";
         return;

      case NERR_ProfileOffset:
   
         error_message = "The start offset is out of range.";
         return;

      case NERR_ProfileCleanup:
   
         error_message = "The system cannot delete current connections to network resources.";
         return;

      case NERR_ProfileUnknownCmd:
   
         error_message = "The system was unable to parse the command line in this file.";
         return;

      case NERR_ProfileLoadErr:
   
         error_message = "An error occurred while loading the profile file.";
         return;

      case NERR_ProfileSaveErr:
   
         error_message = "@W Errors occurred while saving the profile file. The profile was partially saved.";
         return;

      case NERR_LogOverflow:
   
         error_message = "Log file %1 is full.";
         return;

      case NERR_LogFileChanged:
   
         error_message = "This log file has changed between reads.";
         return;

      case NERR_LogFileCorrupt:
   
         error_message = "Log file %1 is corrupt.";
         return;

      case NERR_SourceIsDir:
   
         error_message = "The source path cannot be a directory.";
         return;

      case NERR_BadSource:
   
         error_message = "The source path is illegal.";
         return;

      case NERR_BadDest:
   
         error_message = "The destination path is illegal.";
         return;

      case NERR_DifferentServers:
   
         error_message = "The source and destination paths are on different servers.";
         return;

      case NERR_RunSrvPaused:
   
         error_message = "The Run server you requested is paused.";
         return;

      case NERR_ErrCommRunSrv:
   
         error_message = "An error occurred when communicating with a Run server.";
         return;

      case NERR_ErrorExecingGhost:
   
         error_message = "An error occurred when starting a background process.";
         return;

      case NERR_ShareNotFound:
   
         error_message = "The shared resource you are connected to could not be found.";
         return;

      case NERR_InvalidLana:
   
         error_message = "The LAN adapter number is invalid.";
         return;

      case NERR_OpenFiles:
   
         error_message = "There are open files on the connection.";
         return;

      case NERR_ActiveConns:
   
         error_message = "Active connections still exist.";
         return;

      case NERR_BadPasswordCore:
   
         error_message = "This share name or password is invalid.";
         return;

      case NERR_DevInUse:
   
         error_message = "The device is being accessed by an active process.";
         return;

      case NERR_LocalDrive:
   
         error_message = "The drive letter is in use locally.";
         return;

      case NERR_AlertExists:
   
         error_message = "The specified client is already registered for the specified event.";
         return;

      case NERR_TooManyAlerts:
   
         error_message = "The alert table is full.";
         return;

      case NERR_NoSuchAlert:
   
         error_message = "An invalid or nonexistent alert name was raised.";
         return;

      case NERR_BadRecipient:
   
         error_message = "The alert recipient is invalid.";
         return;

      case NERR_AcctLimitExceeded:
   
         error_message = "A user's session with this server has been deleted because the user's logon hours are no longer valid.";
         return;

      case NERR_InvalidLogSeek:
   
         error_message = "The log file does not contain the requested record number.";
         return;

      case NERR_BadUasConfig:
   
         error_message = "The user accounts database is not configured correctly.";
         return;

      case NERR_InvalidUASOp:
   
         error_message = "This operation is not permitted when the Netlogon service is running.";
         return;

      case NERR_LastAdmin:
   
         error_message = "This operation is not allowed on the last administrative account.";
         return;

      case NERR_DCNotFound:
   
         error_message = "Could not find domain controller for this domain.";
         return;

      case NERR_LogonTrackingError:
   
         error_message = "Could not set logon information for this user.";
         return;

      case NERR_NetlogonNotStarted:
   
         error_message = "The Netlogon service has not been started.";
         return;

      case NERR_CanNotGrowUASFile:
   
         error_message = "Unable to add to the user accounts database.";
         return;

      case NERR_TimeDiffAtDC:
   
         error_message = "This server's clock is not synchronized with the primary domain controller's clock.";
         return;

      case NERR_PasswordMismatch:
   
         error_message = "A password mismatch has been detected.";
         return;

      case NERR_NoSuchServer:
   
         error_message = "The server identification does not specify a valid server.";
         return;

      case NERR_NoSuchSession:
   
         error_message = "The session identification does not specify a valid session.";
         return;

      case NERR_NoSuchConnection:
   
         error_message = "The connection identification does not specify a valid connection.";
         return;

      case NERR_TooManyServers:
   
         error_message = "There is no space for another entry in the table of available servers.";
         return;

      case NERR_TooManySessions:
   
         error_message = "The server has reached the maximum number of sessions it supports.";
         return;

      case NERR_TooManyConnections:
   
         error_message = "The server has reached the maximum number of connections it supports.";
         return;

      case NERR_TooManyFiles:
   
         error_message = "The server cannot open more files because it has reached its maximum number.";
         return;

      case NERR_NoAlternateServers:
   
         error_message = "There are no alternate servers registered on this server.";
         return;

      case NERR_TryDownLevel:
   
         error_message = "Try down-level (remote admin protocol) version of API instead.";
         return;

      case NERR_UPSDriverNotStarted:
   
         error_message = "The UPS driver could not be accessed by the UPS service.";
         return;

      case NERR_UPSInvalidConfig:
   
         error_message = "The UPS service is not configured correctly.";
         return;

      case NERR_UPSInvalidCommPort:
   
         error_message = "The UPS service could not access the specified Comm Port.";
         return;

      case NERR_UPSSignalAsserted:
   
         error_message = "The UPS indicated a line fail or low battery situation. Service not started.";
         return;

      case NERR_UPSShutdownFailed:
   
         error_message = "The UPS service failed to perform a system shut down.";
         return;

      case NERR_BadDosRetCode:
   
         error_message = "The program below returned an MS-DOS error code:";
         return;

      case NERR_ProgNeedsExtraMem:
   
         error_message = "The program below needs more memory:";
         return;

      case NERR_BadDosFunction:
   
         error_message = "The program below called an unsupported MS-DOS function:";
         return;

      case NERR_RemoteBootFailed:
   
         error_message = "The workstation failed to boot.";
         return;

      case NERR_BadFileCheckSum:
   
         error_message = "The file below is corrupt.";
         return;

      case NERR_NoRplBootSystem:
   
         error_message = "No loader is specified in the boot-block definition file.";
         return;

      case NERR_RplLoadrNetBiosErr:
   
         error_message = "NetBIOS    returned an error: The NCB and SMB are dumped above.";
         return;

      case NERR_RplLoadrDiskErr:
   
         error_message = "A disk I/O error occurred.";
         return;

      case NERR_ImageParamErr:
   
         error_message = "Image parameter substitution failed.";
         return;

      case NERR_TooManyImageParams:
   
         error_message = "Too many image parameters cross disk sector boundaries.";
         return;

      case NERR_NonDosFloppyUsed:
   
         error_message = "The image was not generated from an MS-DOS diskette formatted with /S.";
         return;

      case NERR_RplBootRestart:
   
         error_message = "Remote boot will be restarted later.";
         return;

      case NERR_RplSrvrCallFailed:
   
         error_message = "The call to the Remoteboot server failed.";
         return;

      case NERR_CantConnectRplSrvr:
   
         error_message = "Cannot connect to the Remoteboot server.";
         return;

      case NERR_CantOpenImageFile:
   
         error_message = "Cannot open image file on the Remoteboot server.";
         return;

      case NERR_CallingRplSrvr:
   
         error_message = "Connecting to the Remoteboot server...";
         return;

      case NERR_StartingRplBoot:
   
         error_message = "Connecting to the Remoteboot server...";
         return;

      case NERR_RplBootServiceTerm:
   
         error_message = "Remote boot service was stopped; check the error log for the cause of the problem.";
         return;

      case NERR_RplBootStartFailed:
   
         error_message = "Remote boot startup failed; check the error log for the cause of the problem.";
         return;

      case NERR_RPL_CONNECTED:
   
         error_message = "A second connection to a Remoteboot resource is not allowed.";
         return;

      case NERR_BrowserConfiguredToNotRun:
   
         error_message = "The browser service was configured with MaintainServerList=No.";
         return;

      case NERR_RplNoAdaptersStarted:
   
         error_message = "Service failed to start since none of the network adapters started with this service.";
         return;

      case NERR_RplBadRegistry:
   
         error_message = "Service failed to start due to bad startup information in the registry.";
         return;

      case NERR_RplBadDatabase:
   
         error_message = "Service failed to start because its database is absent or corrupt.";
         return;

      case NERR_RplRplfilesShare:
   
         error_message = "Service failed to start because RPLFILES share is absent.";
         return;

      case NERR_RplNotRplServer:
   
         error_message = "Service failed to start because RPLUSER group is absent.";
         return;

      case NERR_RplCannotEnum:
   
         error_message = "Cannot enumerate service records.";
         return;

      case NERR_RplWkstaInfoCorrupted:
   
         error_message = "Workstation record information has been corrupted.";
         return;

      case NERR_RplWkstaNotFound:
   
         error_message = "Workstation record was not found.";
         return;

      case NERR_RplWkstaNameUnavailable:
   
         error_message = "Workstation name is in use by some other workstation.";
         return;

      case NERR_RplProfileInfoCorrupted:
   
         error_message = "Profile record information has been corrupted.";
         return;

      case NERR_RplProfileNotFound:
   
         error_message = "Profile record was not found.";
         return;

      case NERR_RplProfileNameUnavailable:
   
         error_message = "Profile name is in use by some other profile.";
         return;

      case NERR_RplProfileNotEmpty:
   
         error_message = "There are workstations using this profile.";
         return;

      case NERR_RplConfigInfoCorrupted:
   
         error_message = "Configuration record information has been corrupted.";
         return;

      case NERR_RplConfigNotFound:
   
         error_message = "Configuration record was not found.";
         return;

      case NERR_RplAdapterInfoCorrupted:
   
         error_message = "Adapter id record information has been corrupted.";
         return;

      case NERR_RplInternal:
   
         error_message = "An internal service error has occured.";
         return;

      case NERR_RplVendorInfoCorrupted:
   
         error_message = "Vendor id record information has been corrupted.";
         return;

      case NERR_RplBootInfoCorrupted:
   
         error_message = "Boot block record information has been corrupted.";
         return;

      case NERR_RplWkstaNeedsUserAcct:
   
         error_message = "The user account for this workstation record is missing.";
         return;

      case NERR_RplNeedsRPLUSERAcct:
   
         error_message = "The RPLUSER local group could not be found.";
         return;

      case NERR_RplBootNotFound:
   
         error_message = "Boot block record was not found.";
         return;

      case NERR_RplIncompatibleProfile:
   
         error_message = "Chosen profile is incompatible with this workstation.";
         return;

      case NERR_RplAdapterNameUnavailable:
   
         error_message = "Chosen network adapter id is in use by some other workstation.";
         return;

      case NERR_RplConfigNotEmpty:
   
         error_message = "There are profiles using this configuration.";
         return;

      case NERR_RplBootInUse:
   
         error_message = "There are workstations, profiles or configurations using this boot block.";
         return;

      case NERR_RplBackupDatabase:
   
         error_message = "Service failed to backup remoteboot database.";
         return;

      case NERR_RplAdapterNotFound:
   
         error_message = "Adapter record was not found.";
         return;

      case NERR_RplVendorNotFound:
   
         error_message = "Vendor record was not found.";
         return;

      case NERR_RplVendorNameUnavailable:
   
         error_message = "Vendor name is in use by some other vendor record.";
         return;

      case NERR_RplBootNameUnavailable:
   
         error_message = "(boot name, vendor id) is in use by some other boot block record.";
         return;

      case NERR_RplConfigNameUnavailable:
   
         error_message = "Configuration name is in use by some other configuration.";
         return;

      default:

         if ( error_code < NERR_BASE )
         {
            /*
            ** This ain't a LanMan error code, let's see if it'll Format...
            */

            LPVOID message_buffer = (LPVOID) NULL;

            FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
                           NULL,
                           error_code,
                           MAKELANGID( LANG_ENGLISH, SUBLANG_ENGLISH_US ),
                 (LPTSTR) &message_buffer,
                           0,
                           NULL );

            if ( message_buffer != NULL )
            {
               TCHAR temp_string[ 255 ];

               wsprintf( temp_string, "Not an NERR but it means %s", (LPCTSTR) message_buffer );

               ::LocalFree( message_buffer );

               error_message = temp_string;
            }
            else
            {
               TCHAR temp_string[ 256 ];

               wsprintf( temp_string, "Not an NERR, code is %d", error_code );
               error_message = temp_string;
            }
         }
         else
         {
            TCHAR temp_string[ 256 ];

            wsprintf( temp_string, "Unknown error %d (NERR_BASE+%d)", error_code, error_code - NERR_BASE );
            error_message = temp_string;
         }

         return;
   }
}
