#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#if defined( _DEBUG )
#define new DEBUG_NEW
#endif

CFileTime::CFileTime()
{
   Empty();
}

CFileTime::CFileTime( const CFileTime& source )
{
   Copy( source );
}

CFileTime::CFileTime( const CSystemTime& source )
{
   Copy( source );
}

CFileTime::CFileTime( const FILETIME * source )
{
   Copy( source );
}

CFileTime::CFileTime( const SYSTEMTIME * source )
{
   Copy( source );
}

CFileTime::CFileTime( WORD ms_dos_date, WORD ms_dos_time )
{
   Copy( ms_dos_date, ms_dos_time );
}

CFileTime::~CFileTime()
{
   Empty();
}

LONG CFileTime::Compare( const CFileTime& source )
{
   return( ::CompareFileTime( (const FILETIME *) this, (const FILETIME *) &source ) );
}

void CFileTime::Copy( const CFileTime& source )
{
   Copy( (const FILETIME *) &source );
}

void CFileTime::Copy( const CSystemTime& source )
{
   Copy( (const SYSTEMTIME *) &source );
}

void CFileTime::Copy( const FILETIME * source )
{
   ASSERT( source != NULL );

   if ( source == (const FILETIME *) NULL )
   {
      Empty();
      return;
   }

   dwLowDateTime  = source->dwLowDateTime;
   dwHighDateTime = source->dwHighDateTime;
}

void CFileTime::Copy( const SYSTEMTIME * source )
{
   ASSERT( source != NULL );

   if ( source == (const SYSTEMTIME *) NULL )
   {
      Empty();
      return;
   }

   FILETIME file_time;

   if ( ::SystemTimeToFileTime( source, &file_time ) == TRUE )
   {
      Copy( &file_time );
   }
   else
   {
      Empty();
   }
}

void CFileTime::Copy( WORD ms_dos_date, WORD ms_dos_time )
{
   FILETIME file_time;

   if ( ::DosDateTimeToFileTime( ms_dos_date, ms_dos_time, &file_time ) == TRUE )
   {
      Copy( &file_time );
   }
   else
   {
      Empty();
   }
}

void CFileTime::Empty( void )
{
   dwLowDateTime  = 0;
   dwHighDateTime = 0;
}

/*
** Operators
*/

CFileTime& CFileTime::operator = ( const CFileTime& source )
{
   Copy( source );
   return( *this );
}

CFileTime& CFileTime::operator = ( const CSystemTime& source )
{
   Copy( source );
   return( *this );
}

BOOL CFileTime::operator == ( const CFileTime& source )
{
   if ( Compare( source ) == 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CFileTime::operator < ( const CFileTime& source )
{
   if ( Compare( source ) < 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CFileTime::operator > ( const CFileTime& source )
{
   if ( Compare( source ) > 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

#if defined( _DEBUG )

void CFileTime::Dump( CDumpContext& dump_context ) const
{
   dump_context << "a CFileTime ar " << (VOID *) this << "\n{\n";
   dump_context << "   dwLowDateTime is " << dwLowDateTime << "\n";
   dump_context << "   dwHighDateTime is " << dwHighDateTime << "\n";
   dump_context << "}\n";
}

#endif
