#if ! defined ( SYSTEM_TIME_CLASS_HEADER )

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#define SYSTEM_TIME_CLASS_HEADER

class CFileTime;

class CSystemTime : public _SYSTEMTIME
{
   public:

      CSystemTime();
      CSystemTime( const CSystemTime& source );
      CSystemTime( const CFileTime& source );
      CSystemTime( const SYSTEMTIME * source );
      CSystemTime( const FILETIME * source );

      virtual ~CSystemTime();

      /*
      ** Unfortunately, I can't call this GetCurrentTime (like in CTime)
      ** because Microsoft #define's it in winbase.h and it royally screws me.
      */

      static CSystemTime GetTheCurrentTime( void );

      virtual void Empty( void );

      virtual LONG Compare( const CSystemTime& source );

      virtual void Copy( const CSystemTime& source );
      virtual void Copy( const CFileTime& source );
      virtual void Copy( const SYSTEMTIME * source );
      virtual void Copy( const FILETIME * source );

      /*
      ** Operators
      */

      virtual CSystemTime& operator = ( const CSystemTime& source );
      virtual CSystemTime& operator = ( const CFileTime& source );
      virtual BOOL operator == ( const CSystemTime& source );
      virtual BOOL operator > ( const CSystemTime& source );
      virtual BOOL operator < ( const CSystemTime& source );

#if defined( _DEBUG )

      virtual void Dump( CDumpContext& dump_context ) const;

#endif // _DEBUG
};

#endif // SYSTEM_TIME_CLASS_HEADER
