/*
 * ScrnSave.c -- Trigger Screen Saver.
 *
 * Simple utility to trigger the screen saver on Windows NT.
 * Works very nice when launched from RipBar (Jonathan Carroll,
 * 74017.3242@compuserve.com).
 *
 * Thanks to Alan Phillips (A.Phillips@lancaster.ac.uk), the author
 * of the Programmers File Editor (PFE), for hints on how to do this.
 *
 * Tested on Daytona Beta I and II, expect it works on NT 3.1.
 *
 * Written by Bob Beck, Sequent Computer Systems, Inc., 8/31/94.
 * rbk@sequent.com, CIS: 71674,106.
 */

#include <windows.h>

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
 {
     static char szAppName[] = "SaveScrn" ;
     HWND        hwnd ;
     WNDCLASS    wndclass ;

     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;

     RegisterClass (&wndclass) ;

     hwnd = CreateWindow (szAppName, "Screen Saver Trigger",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     DefWindowProc (hwnd, WM_SYSCOMMAND, SC_SCREENSAVE, 0) ;
	 //ExitProcess(0);
	 return 0;
 }

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
 {
     return DefWindowProc (hwnd, message, wParam, lParam) ;
 }
