/* ntwhich.c ... find first matching executable in path,
 * be it .COM .BAT .EXE or .CMD
 * Copyright (C) 1994 by
 * jack j. woehr, p.o. box 51, golden, colorado 80402-0051
 * jax@well.sf.ca.us JAX on GEnie 72203.1320@compuserve.com
 * SYSOP, RealTime Control & Forth Board [RCFB] (303) 278-0364
 * All Rights Reserved
 */

/*
 * This is free software and can be modified and redistributed under
 * certain conditions described in the file COPYING.TXT. The
 * Disclaimer of Warranty and License for this free software are also
 * contained in the file COPYING.TXT.
 */

#include <windows.h>
#include <stdio.h>
#include "ntwhich.h"

const char extensions[4][5] = { ".COM", ".EXE", ".BAT", ".CMD" };
char *pathBuffer, *pathString;

int main ( int argc, char *argv[] ) {

	int i, result = 0;

	if ( argc == 1 ) {
		printf ( "%s %s\nUsage:\t%s\n%s\n%s\n%s\n",
			*argv, "$Revision: 1.2 $", USAGE, USAGE1, USAGE2, USAGE3 );
		return 0;
	}

	pathBuffer = LocalAlloc ( LMEM_FIXED | LMEM_ZEROINIT, buffSize );
	if ( !pathBuffer ) {
		fprintf ( stderr, "%s\n", "Couldn't allocate memory." );
		return 1;
	}

	pathString = LocalAlloc ( LMEM_FIXED | LMEM_ZEROINIT, pathSize );
	if ( !pathString ) {
		fprintf ( stderr, "%s\n", "Couldn't allocate memory." );
		LocalFree ( pathBuffer );
		return 2;
	}

	for ( i = 1; i < argc; i++ ) {

		if (	!( strcmp ( argv[i], "/?" ) ) ||
			!( strcmp ( argv[i], "/H" ) ) ||
			!( strcmp ( argv[i], "/h" ) ) ||
			!( strcmp ( argv[i], "-H" ) ) ||
			!( strcmp ( argv[i], "-h" ) ) ) {

			printf ( "Usage: %s %s\n%s\n%s\n%s\n",
				 *argv, USAGE, USAGE1, USAGE2, USAGE3 );
			continue;
		}

		if (	!( strcmp ( argv[i], "/L" ) ) ||
			!( strcmp ( argv[i], "/l" ) ) ||
			!( strcmp ( argv[i], "-L" ) ) ||
			!( strcmp ( argv[i], "-l" ) ) ) {

			printf ( "%s: %s\n%s\n%s\n", *argv, LICENSE, LICENSE1, LICENSE2 );
			continue;
		}


		printf ( "%s:\n", argv[i] );

		if ( ( strchr ( argv[i], '.' ) ) )
			result |= dotwhich ( argv[i] );

		else
			result |= which ( argv[i] );
	}

	LocalFree ( pathBuffer );
	LocalFree ( pathString );
	return result;
}

/* no dot extension provided by user, check in order of execution */
int which ( char *name ) {

	int i, count = 0;
	char *dotAddress, *temp;
	HANDLE finder;
	WIN32_FIND_DATA lpffd;

	/* have to do this each time since strtok writes NULLs in the buffer */
	count = GetEnvironmentVariable ( "PATH", pathBuffer, buffSize ) ;
	if ( count > buffSize ) {
		fprintf ( stderr, "%s\n", "Path string > 16K, you must be joking." );
		LocalFree ( pathBuffer );
		LocalFree ( pathString );
		return 3;
	}

	/* check current directory first */
	/* leave room for path + "name" + "\" + ".???" + "\0" */
	strncpy ( pathString, ".", MAX ( ( pathSize - ( strlen ( name ) + 6 ) ), 0 ) );

	/* append dotless name of sought */
	strcat ( pathString, "\\" );
	strcat ( pathString, name );

	/* dotAddress is where we'll start appending executable suffixes */
	dotAddress = pathString + strlen (pathString);

	/* loop trying different extensions */
	for ( i = 0; i < 4; i++ ) {

		strcpy ( dotAddress, extensions[i] );

		/* Do we find it ? */
		if ( INVALID_HANDLE_VALUE !=
			( finder = FindFirstFile ( pathString, &lpffd ) ) ) {
			/* System files aren't executed in a CMD.EXE exe path search */
			if ( !( lpffd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM ) ) {
				/* It's a findable, print its full path */
				printf ( "\t%s\n", pathString );
				return 0;	/* if we did, return no error */
			}
			/* In any event, if we got a handle, close it.
			FindClose ( finder );	/* Close find handle */
		}
	}

	/* Wasn't in current dir, we'll loop checking path */
	/* Get first path element. */
	temp = strtok ( pathBuffer, ";" ) ;

	/* Loop while strtok() returns something */
	/* see above for more comments on functionality in this loop */
	while ( temp ) {

		/* leave room for path + "name" + "\" + ".???" + "\0" */
		strncpy ( pathString, temp, pathSize - ( strlen ( name ) + 6 ) );

		strcat ( pathString, "\\" );
		strcat ( pathString, name );

		dotAddress = pathString + strlen (pathString);

		for ( i = 0; i < 4; i++ ) {

			strcpy ( dotAddress, extensions[i] );

			/* See comments above */
			if ( INVALID_HANDLE_VALUE !=
				( finder = FindFirstFile ( pathString, &lpffd ) ) ) {

				if ( !( lpffd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM ) ) {
					printf ( "\t%s\n", pathString );
					return 0;
				}

				FindClose ( finder );	/* Close find handle */
			}
		}

		/* get next element in path in order to try again */
		temp = strtok ( 0, ";" );
	}

	return aFileNotFound;
}

/* Already has a dot extension */
int dotwhich ( char *name ) {

	int count = 0;
	char *temp;
	HANDLE finder;
	WIN32_FIND_DATA lpffd;

	/* have to do this each time since strtok writes NULLs in the buffer */
	count = GetEnvironmentVariable ( "PATH", pathBuffer, buffSize ) ;
	if ( count > buffSize ) {
		fprintf ( stderr, "%s\n", "Path string > 16K, you must be joking." );
		LocalFree ( pathBuffer );
		LocalFree ( pathString );
		return 3;
	}

	/* check current directory first */
	/* leave room for path + "name" + \0" */
	strncpy ( pathString, ".", MAX ( ( pathSize - ( strlen ( name ) + 1 ) ), 0 ) );

	strcat ( pathString, "\\" );
	strcat ( pathString, name );

	/* See comments in which(), above */
	if ( INVALID_HANDLE_VALUE != ( finder = FindFirstFile ( pathString, &lpffd ) ) ) {

		if ( !( lpffd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM ) ) {
			printf ( "\t%s\n", pathString );
			return 0;
		}

		FindClose ( finder );	/* Close find handle */
	}

	/* Not in current dir, so get first element in path */
	temp = strtok ( pathBuffer, ";" );

	while ( temp ) {

	/* leave room for path + "name" + \0" */
	strncpy ( pathString, temp, MAX ( ( pathSize - ( strlen ( name ) + 1 ) ), 0 ) );

		strcat ( pathString, "\\" );
		strcat ( pathString, name );

		if ( INVALID_HANDLE_VALUE != ( finder = FindFirstFile ( pathString, &lpffd ) ) ) {

			if ( !( lpffd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM ) ) {
				printf ( "\t%s\n", pathString );
				return 0;
			}

			FindClose ( finder );	/* Close find handle */
		}

		/* get next element in path in order to try again */
		temp = strtok ( 0, ";" );
	}

	return aFileNotFound;
}

/* End of which.c */
