/*********************************************************************/
/* file: utils.c - some utility-functions                            */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <string.h>
#include <stdlib.h>
#include "tintin.h"

#ifdef WIN32
extern int TimeToQuit;
#endif

/*********************************************/
/* return: TRUE if s1 is an abrevation of s2 */
/*********************************************/
int is_abrev(char *s1, char *s2)
{
  return(strstr(s2, s1)==s2);
}

/********************************/
/* strdup - duplicates a string */
/* return: address of duplicate */
/********************************/
char *mystrdup(const char *s)
{
  char *dup;

  if((dup=(char *)malloc(strlen(s)+1))==NULL)
    syserr("Not enought memory for strdup.");
  strcpy(dup, s);
  return dup;
}

#ifdef DUNNO_strstr
/***************************************/
/* People ought to have this function! */
/***************************************/
char *strstr(const char *s1, const char *s2)
{
  char *cp;
  int i,j=strlen(s1)-strlen(s2),k=strlen(s2);

  if(j<0)
    return NULL;
  for(i=0; i<=j && strncmp(s1++,s2, k)!=0; i++);
  return (i>j) ? NULL : (s1-1);
}
#endif

/*************************************************/
/* print system call error message and terminate */
/*************************************************/
void syserr(char *msg)
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];

  fprintf(stderr,"ERROR: %s (%d",msg, errno);
  if(errno>0 && errno<sys_nerr)
    fprintf(stderr,": %s)\n",sys_errlist[errno]);
  else
    fprintf(stderr,")\n");
#ifdef WIN32
    TimeToQuit=1;
    Sleep(1000);
    WSACleanup();
#endif
  exit(1);
}

