/*********************************************************************/
/* file: tintin.h - the include file for tintin                      */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <stdio.h>
#ifdef WIN32
#include <windows.h>
#endif

/************************/
/* The meaning of life: */
/************************/
#define TRUE 1
#define FALSE 0

/***********************************************/
/* Some default values you might wanna change: */
/***********************************************/
#define HISTORY_SIZE 15               /* history size */
#define MAX_PATH_LENGHT 50            /* max path lenght */
#define DEFAULT_TINTIN_CHAR '#'       /* tintin char */
#define DEFAULT_ECHO FALSE            /* echo */
#define DEFAULT_IGNORE FALSE          /* ignore */
#define DEFAULT_SPEEDWALK TRUE        /* speedwalk */

/**************************************************************************/
/* Whenever TINTIN has written something to the screen, the program sends */
/* a CR/LF to the diku to force a new prompt to appear. You can have      */
/* TINTIN print it's own pseudo prompt instead.                           */
/**************************************************************************/
#define PSEUDO_PROMPT FALSE

/*************************************************************************/
/* The text below is checked for. If it trickers then echo is turned off */
/* echo is turned back on the next time the user types a return          */
/*************************************************************************/
#define PROMPT_FOR_PW_TEXT "Password:"

/**************************************************************************/
/* The stuff below here shouldn't be modified unless you know what you're */
/* doing........                                                          */
/**************************************************************************/
#define BUFFER_SIZE 1024

/************************ structures *********************/
struct listnode {
  struct listnode *next;
  char *left, *right;
};

struct session {
  struct session *next;
  char *name;
  char *address;
  int tickstatus;
  int snoopstatus;
  FILE *logfile;
  struct listnode *aliases, *actions, *subs;
  char *history[HISTORY_SIZE];
  char path[MAX_PATH_LENGHT];
  int path_mark, path_now, path_lenght;
  int socket, socketbit;
};

/******************** prototypes main.c ******************/
void tintin();
void read_mud(struct session *ses);
static void myquitsig();
void tintin_puts(char *cptr, struct session *ses);
static void tick_func();
void snoop(char *buffer, struct session *ses);
#ifdef WIN32
void CALLBACK Win32TickTimerproc(HWND hwnd,UINT uMsg,UINT idEvent,DWORD dwTime);
#endif


/******************** prototypes parse.c ******************/
struct session *parse_input(char *input, struct session *ses);
struct session *parse_tintin_command(char *command, char *arg, struct session *ses);
void write_com_arg_mud(char *command, char *argument, struct session *ses);
int is_speedwalk_dirs(char *cp);
void do_speedwalk(char *cp, struct session *ses);
char *get_arg_all(char *s, char *arg);
char *get_arg_with_spaces(char *s, char *arg);
char *get_arg_stop_spaces(char *s, char *arg);
char *space_out(char *s);
void prompt(struct session *ses);

/******************* prototypes llist.c ******************/
struct listnode *init_list();
void insertnode_list(struct listnode *listhead, char *ltext, char *rtext);
void deletenode_list(struct listnode *listhead, struct listnode *nptr);
struct listnode *searchnode_list(struct listnode *listhead, char *cptr);
void shownode_list(struct listnode *nptr);
void show_list(struct listnode *listhead);
void kill_list(struct listnode *nptr);
struct listnode *copy_list(struct listnode *sourcelist);

/******************** prototypes action.c *****************/
void parse_action(char *arg, struct session *ses);
void unaction_command(char *arg, struct session *ses);
void prepare_actionalias(char *string, char *result);
void substitute_vars(char *arg, char *result);
void check_all_actions(char *line, struct session *ses);
int check_one_action(char *text, char *action);
int do_tricker(char *text, char *action);
void split_check_all_actions(char *buffer, struct session *ses);

/******************** prototypes alias.c *****************/
void alias_command(char *arg, struct session *ses);
void unalias_command(char *arg, struct session *ses);

/***************** prototypes substitute.c *****************/
void parse_sub(char *arg, struct session *ses);
void unsubstitute_command(char *arg, struct session *ses);
void do_all_subs(char *buffer, char *result, struct session *ses);
void do_one_sub(char *line, struct session *ses);

/***************** prototypes session.c *********************/
struct session *session_command(char *arg, struct session *ses);
struct session *newactive_session();
struct session *new_session(char *name, char *address, struct session *ses);
void cleanup_session(struct session *ses);
void show_session(struct session *ses);
/******************** prototypes ticks.c *****************/
void tick_command(struct session *ses);
void tickoff_command(struct session *ses);
void tickon_command(struct session *ses);
void tickset_command(struct session *ses);
void ticksize_command(char *arg, struct session *ses);

/******************** prototypes path.c ******************/
void mark_command(struct session *ses);
void path_command(struct session *ses);
void return_command(struct session *ses);
void unpath_command(struct session *ses);
void check_insert_path(char *command, struct session *ses);
void insert_path(char dir, struct session *ses);
char reverse_dir(char dir);

/******************** prototypes files.c *****************/
void log_command(char *arg, struct session *ses);
struct session *write_command(char *filename, struct session *ses);
struct session *writesession_command(char *filename, struct session *ses);
struct session *read_command(char *filename, struct session *ses);
void prepare_quotes(char *string);
void prepare_for_write(char *command, char *left, char *right, char *result);
/******************** prototypes utils.c *****************/
int is_abrev(char *s1, char *s2);
#ifdef DUNNO_strstr
 char *strstr(const char *s1, const char *s2);
#endif
char *mystrdup(const char *s);
void syserr(char *msg);
/******************** prototypes history.c ***************/
void history_command(struct session *ses);
void insert_history(char *buffer, struct session *ses);
void do_history(char *buffer, struct session *ses);
/******************** prototypes misc.c *****************/
struct session *all_command(char *arg, struct session *ses);
void bell_command(struct session *ses);
void boss_command(struct session *ses);
void char_command(char *arg, struct session *ses);
void echo_command(struct session *ses);
void end_command(char *command, struct session *ses);
void ignore_command(struct session *ses);
#ifdef WIN32
void mbox_command(char *arg, struct session *ses);
void mci_command(char *arg, struct session *ses);
#endif
void snoop_command(char *arg, struct session *ses);
void speedwalk_command(struct session *ses);
void system_command(char *arg, struct session *ses);
struct session *zap_command(struct session *ses);
void wizlist_command(struct session *ses);
void help_command(struct session *ses);

/******************** prototypes net.c *******************/
#ifdef WIN32
SOCKET connect_mud(char *host, char *port, struct session *ses);
#else
int connect_mud(char *host, char *port, struct session *ses);
#endif
void write_com_arg_mud(char *command, char *argument, struct session *ses);
void write_line_mud(char *line, struct session *ses);
int read_buffer_mud(char *buffer, struct session *ses);
void do_telnet_protecol(int dat0, int dat1, int dat2, struct session *ses);

/******************** prototypes echo.c ******************/
void term_echo();
void term_noecho();
