/*********************************************************************/
/* file: ticks.c - functions for the ticker stuff                    */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <ctype.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include "tintin.h"

#ifndef BADSIG
  #define BADSIG (void (*)())-1
#endif

/* externs */
struct session *sessionlist;

/* local globals */
int sec_to_tick, time0, tick_size=75;
int ticker_interrupted;

/*********************/
/* the #tick command */
/*********************/
void tick_command(struct session *ses)
{
  if(ses) {
    if(ses->tickstatus) {
      char buf[100];
      sprintf(buf, "THERE'S NOW %d SECONDS TO NEXT TICK.", sec_to_tick);
      tintin_puts(buf, ses);
    }
    else
      tintin_puts("MY TICKER IS OFF! DUNNO SECONDS TO TICK", ses);
  }
  else
    tintin_puts("#NO SESSION ACTIVE => NO TICKER!", ses);
}

/************************/
/* the #tickoff command */
/************************/
void tickoff_command(struct session *ses)
{
  if(ses) {
    ses->tickstatus=FALSE;
    tintin_puts("#TICKER IS NOW OFF.", ses);
  }
  else
   tintin_puts("#NO SESSION ACTIVE => NO TICKER!", ses);
}

/***********************/
/* the #tickon command */
/***********************/
void tickon_command(struct session *ses)
{
  if(ses) {
    ses->tickstatus=TRUE;
    tintin_puts("#TICKER IS NOW ON.", ses);
  }
  else
    tintin_puts("#NO SESSION ACTIVE => NO TICKER!", ses);
}

/************************/
/* the #tickset command */
/************************/
void tickset_command(struct session *ses)
{
  if(ses) 
    time0=time(NULL); /* we don't prompt! too many ticksets... */
  else
    tintin_puts("#NO SESSION ACTIVE => NO TICKER!", ses);
}

/*************************/
/* the #ticksize command */
/*************************/
void ticksize_command(char *arg, struct session *ses)
{
  if(*arg!='\0') {
    if(isdigit(*arg)) {
      tick_size=atoi(arg);
      time0=time(NULL);
      tintin_puts("#OK NEW TICKSIZE SET", ses);        
    }
    else
      tintin_puts("#SPECIFY A NUMBER!!!!TRYING TO CRASH ME EH?", ses);
  }
  else
    tintin_puts("#SET THE TICK-SIZE TO WHAT?", ses);
}     

/****************************************/
/* alarm signal handler used for ticker */
/****************************************/
static void tick_func()
{
  static int tickfoo=1;

  ticker_interrupted=TRUE;

#ifndef WIN32
  alarm(1);
  if(signal(SIGALRM, tick_func)==BADSIG)
    syserr("signal SIGALRM"); 
#endif

  sec_to_tick=tick_size-((time(NULL)-time0)%tick_size);
  if(sec_to_tick==tick_size || sec_to_tick==10) {
    struct session *sesptr;
    for(sesptr=sessionlist; sesptr; sesptr=sesptr->next)
      if(sesptr->tickstatus) 
#ifdef WIN32
        /* Since tick_func is getting called a couple times a second, we have
         * to make sure we don't print tick messages twice.
         */
        if ((sec_to_tick==tick_size)&&(!tickfoo))
		{
          tintin_puts("#TICK!!!", sesptr);
		  tickfoo = 1;
	    }
        if ((sec_to_tick!=tick_size)&&(tickfoo))
		{
          tintin_puts("#10 SECONDS TO TICK!!!", sesptr);
		  tickfoo = 0;
		}
#else
        if(sec_to_tick==tick_size)
          tintin_puts("#TICK!!!", sesptr);
        else 
          tintin_puts("#10 SECONDS TO TICK!!!", sesptr);
#endif
  }
}












