/*********************************************************************/
/* file: substitute.c - functions related to the substitute command  */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <string.h>
#include "tintin.h"

extern struct listnode *common_subs;
extern char vars[10][BUFFER_SIZE]; /* the &0, &1, &2,....&9 variables */

/***************************/
/* the #substitute command */
/***************************/
void parse_sub(char *arg, struct session *ses)
{
  char left[BUFFER_SIZE], right[BUFFER_SIZE];
  struct listnode *mysubs, *ln;

  mysubs=(ses) ? ses->subs : common_subs;

  arg=get_arg_stop_spaces(arg, left);
  arg=get_arg_with_spaces(arg, right);

  if(!*left) {
    puts("#THESE SUBSTITUTES HAS BEEN DEFINED:");
    show_list(mysubs);
    prompt(ses);
  }

  else if(*left && !*right) {
    if((ln=searchnode_list(mysubs, left))!=NULL) {
      shownode_list(ln);
      prompt(ses);
    }
    else
      tintin_puts("#THAT SUBSTITUTE IS NOT DEFINED.", ses);
  }

  else {
    if((ln=searchnode_list(mysubs, left))!=NULL)
      deletenode_list(mysubs, ln);
    insertnode_list(mysubs, left, right);
    tintin_puts("#OK. SUBSTITUTE DEFINED.", ses);
  }
}


/*****************************/
/* the #unsubstitute command */
/*****************************/
void unsubstitute_command(char *arg, struct session *ses)
{
  char left[BUFFER_SIZE];
  struct listnode *mysubs, *ln;

  mysubs=(ses) ? ses->subs : common_subs;

  arg=get_arg_with_spaces(arg, left);

  if((ln=searchnode_list(mysubs, left))!=NULL) {
    deletenode_list(mysubs, ln);
    tintin_puts("#OK. SUBSTITUTE DELETED", ses);
  }
  else
    tintin_puts("#THAT SUBSTITUTE IS NOT DEFINED.", ses);
}


/**************************************************************/
/* run through output from mud, and substitute text if needed */
/**************************************************************/
void do_all_subs(char *buffer, char *result, struct session *ses)
{
  int n;
  char *cpsource, *cpdest, linebuffer[BUFFER_SIZE];


  cpsource=buffer; 
  cpdest=linebuffer;

  while(*cpsource) {  /*cut out each of the lines and sub'em if a sub is triggered*/
    if(*cpsource=='\n' || *cpsource=='\r') {
      *cpdest='\0';      
      do_one_sub(linebuffer, ses);
      if(!(*linebuffer=='.' && !*(linebuffer+1))) {
        n=strlen(linebuffer);
        memcpy(result, linebuffer, n);
        result+=n;
        *result++=*cpsource++;
        if(*cpsource=='\n' || *cpsource=='\r') 
          *result++=*cpsource++;
      }
      else 
        if(*++cpsource=='\n' || *cpsource=='\r') 
          cpsource++;

      cpdest=linebuffer;
    }
    else
      *cpdest++=*cpsource++;
  }
  *cpdest='\0';
  do_one_sub(linebuffer, ses);
  n=strlen(linebuffer);
  memcpy(result, linebuffer, n);
  result+=n;
  *result='\0';
}


void do_one_sub(char *line, struct session *ses)
{
  struct listnode *ln=ses->subs;

  while(ln=ln->next) 
    if(check_one_action(line, ln->left))
      prepare_actionalias(ln->right, line);
}




