/*********************************************************************/
/* file: misc.c - misc commands                                      */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "tintin.h"
#ifdef WIN32
#include <process.h>

extern int TimeToQuit;
#endif

/* externs */
extern struct session *sessionlist;
extern char tintin_char;
extern int echo;
extern int ignore;
extern int speedwalk;

/********************/
/* the #all command */
/********************/
struct session *all_command(char *arg, struct session *ses)
{
  struct session *sesptr;

  if(sessionlist) {
    get_arg_with_spaces(arg, arg);
    for(sesptr=sessionlist; sesptr; sesptr=sesptr->next)
      parse_input(arg, sesptr);
  }
  else
    tintin_puts("BUT THERE ISN'T ANY SESSION AT ALL!", ses);
  return ses;
}


/*********************/
/* the #bell command */
/*********************/
void bell_command(struct session *ses)
{
  putchar('\a');
  fflush(stdout);
}


/*********************/
/* the #boss command */
/*********************/
void boss_command(struct session *ses)
{
  int i;
  for(i=0; i<50; i++)
    printf("in-order traverse of tree starting from node %d resulted in %d red nodes\n", i, 50-i);

  getchar(); /* stop screen from scrolling stuff */
}

/*********************/
/* the #char command */
/*********************/
void char_command(char *arg, struct session *ses)
{
  get_arg_stop_spaces(arg, arg);
  if(ispunct(*arg)) {
    tintin_char=*arg;
    tintin_puts("#OK. GOT NEW TINTIN-CHAR.", ses);
  }
  else
    tintin_puts("#SPECIFY A PROPER TINTIN-CHAR! SOMETHING LIKE # OR /!", ses);
}


/*********************/
/* the #echo command */
/*********************/
void echo_command(struct session *ses)
{
  echo=!echo;
  if(echo)
    tintin_puts("#ECHO IS NOW ON.", ses);
  else
    tintin_puts("#ECHO IS NOW OFF.", ses);
}

/*********************/
/* the #end command */
/*********************/
void end_command(char *command, struct session *ses)
{
  if(strcmp(command, "end"))
    tintin_puts("#YOU HAVE TO WRITE #end - NO LESS, TO END!", ses);
  else {
    struct session *sesptr;
    for(sesptr=sessionlist; sesptr; sesptr=sesptr->next)
      cleanup_session(sesptr);
      puts("\n\rTINTIN suffers from bloodlack, and the lack of a beating heart...");
      puts("TINTIN is dead! R.I.P.");
      puts("Your blood freezes as you hear TINTIN's death cry.");
#ifdef WIN32
      TimeToQuit=1;
      Sleep(1000);
      WSACleanup();
#endif
      exit(0);
  }
}

/***********************/
/* the #ignore command */
/***********************/
void ignore_command(struct session *ses)
{
  ignore=!ignore;
  if(ignore)
    tintin_puts("#ACTIONS ARE IGNORED FROM NOW ON.", ses);
  else
    tintin_puts("#ACTIONS ARE NO LONGER IGNORED.", ses);
}

#ifdef WIN32

/* Threadproc for the mbox command so we don't tie up input... */
void
mboxThreadProc(
   void *arglist
   )
{
   char **cargs=(char **)arglist;

   MessageBox(NULL,cargs[1],cargs[0],MB_OK|MB_ICONINFORMATION|MB_SETFOREGROUND);
   free(cargs[0]);
   free(cargs[1]);
   free(cargs);
   _endthread();
}


/********************************************/
/* the #mbox command - display a messagebox */
/********************************************/
void mbox_command(char *arg, struct session *ses)
{
   char buff[128];
   char **args;

   wsprintf(buff,"TinTin %s",(ses == NULL) ? "" : ses->name);
   args = malloc(2*sizeof (char *));
   args[0] = strdup(buff);
   args[1] = strdup(arg);
   _beginthread(mboxThreadProc,2048,(LPVOID) args);
   tintin_puts("",ses);

}



/****************************************************/
/* the #mci command - execute an mci string command */
/****************************************************/
void mci_command(char *arg, struct session *ses)
{
   mciSendString(arg,NULL,0,NULL);
   tintin_puts("",ses);
}


#endif /* win32 */

/**********************/
/* the #snoop command */
/**********************/
void snoop_command(char *arg, struct session *ses)
{
  char buf[100];
  struct session *sesptr=ses;

  if(ses) {
    get_arg_stop_spaces(arg, arg);
    if(*arg) {
      for(sesptr=sessionlist; sesptr && strcmp(sesptr->name, arg); sesptr=sesptr->next);
      if(!sesptr) {
        tintin_puts("#NO SESSION WITH THAT NAME!", ses);
        return;
      }
    }
    if(sesptr->snoopstatus) {
      sesptr->snoopstatus=FALSE;
      sprintf(buf, "#UNSNOOPING SESSION '%s'", sesptr->name);
      tintin_puts(buf, ses);
    }
    else {
      sesptr->snoopstatus=TRUE;
      sprintf(buf, "#SNOOPING SESSION '%s'", sesptr->name);
      tintin_puts(buf, ses);
    }
  }
  else
    tintin_puts("#NO SESSION ACTIVE => NO SNOOPING", ses);
}

/**************************/
/* the #speedwalk command */
/**************************/
void speedwalk_command(struct session *ses)
{
  speedwalk=!speedwalk;
  if(speedwalk)
    tintin_puts("#SPEEDWALK IS NOW ON.", ses);
  else
    tintin_puts("#SPEEDWALK IS NOW OFF.", ses);
}

/***********************/
/* the #system command */
/***********************/
void system_command(char *arg, struct session *ses)
{
  get_arg_with_spaces(arg, arg);
  if(*arg) {
    tintin_puts("#OK EXECUTING SHELL COMMAND.", ses);
    system(arg);
    tintin_puts("#OK COMMAND EXECUTED.", ses);
  }
  else
    tintin_puts("#EXECUTE WHAT COMMAND?", ses);
}


/********************/
/* the #zap command */
/********************/
struct session *zap_command(struct session *ses)
{
  tintin_puts("#ZZZZZZZAAAAAAAAPPPP!!!!!!!!! LET'S GET OUTTA HERE!!!!!!!!", ses);
  if(ses) {
    cleanup_session(ses);
    return newactive_session();
  }
  else
  {
#ifdef WIN32
      TimeToQuit=1;
      Sleep(1000);
      WSACleanup();
#endif
      exit(0);
  }
}




/************************/
/* the #wizlist command */
/************************/
void wizlist_command(struct session *ses)
{
  puts("\n==========================================================================");
  puts("The following people have achieved immortality and superior powers in this");
  puts("realm. They should be treated with respect, and occasional prayers are");
  puts("advisable. Stealing from these people is punishable by death.");
  puts("The Utmost Scum people should be killed at sight.");
  puts("==========================================================================");
  puts("                           Implementor:");
  puts("                              Snowy");
  puts("\n                        Wiiiiiiiiiiild ones:");
  puts("                         Jaz Jstlook Vivace");
  puts("\n                          TINTIN testers:");
  puts("  AWK DaShadow Emp Gilthan Gizmo Guru Gutz Kafka Lunitil Luke Memo");
  puts("                Silvia Sphinx Spit Switchblade Ubik Zendar");
  puts("\n                            Utmost Scum:");
  puts("                         Ali Destiny Impaler");
  prompt(ses);
}

/*********************/
/* the #help command */
/*********************/
void help_command(struct session *ses)
{
  puts("#LIST OF TINTIN-COMMANDS:");
  printf("%caction [TEXT [TEXT]]       : LIST/DISPLAY/DEFINE ACTIONS\n", tintin_char);
  printf("%calias  [TEXT [TEXT]]       : LIST/DISPLAY/DEFINE ALIASES\n", tintin_char);
  printf("%call COMMAND                : SEND COMMAND TO ALL SESSIONS\n", tintin_char);
  printf("%cbell                       : RING BELL\n", tintin_char);
  printf("%cboss                       : FILL SCREEN WITH SERIOUS STUFF\n", tintin_char);
  printf("%cchar                       : CHANGE THE TINTIN-CHAR\n", tintin_char);
  printf("%cecho                       : TURN ACTION ECHOING ON/OFF\n", tintin_char);
  printf("%cend                        : CUT ALL CONNECTIONS AND END TINTIN\n", tintin_char);
  printf("%chelp                       : THIS TEXT\n", tintin_char);
  printf("%chistory                    : SHOW COMMANDS IN HISTORY\n", tintin_char);
  printf("%cignore                     : TURN ACTION IGNORING ON/OFF\n", tintin_char);
  printf("%clog [FILENAME]             : TURN LOGGING TO 'FILENAME' ON/OFF\n", tintin_char);
  printf("%cNUMBER COMMAND             : REPEAT 'COMMAND' NUMBER TIMES\n", tintin_char);
  printf("%cmark                       : MARK BEGINNING OF A NEW PATH\n", tintin_char);
#ifdef WIN32
  printf("%cmbox [TEXT]                 : POPUP A WIN32 MESSAGE BOX SHOWING [TEXT]\n", tintin_char);
  printf("%cmci [MCI STRING]            : EXECUTE THE MCI STRING GIVEN AS ARGUMENT\n", tintin_char);
#endif
  printf("%cpath                       : SHOW THE PATH WALKED UNTIL NOW\n", tintin_char);
  printf("%creturn                     : GO ONE MOVE BACK ON THE PATH\n", tintin_char);
  printf("%cread FILENAME              : READ A COMMANDFILE AND EXECUTE IT\n", tintin_char);
  printf("%csession [NAME [MUDADDRESS]]: LIST/DISPLAY/DEFINE SESSIONS\n", tintin_char);
  printf("%cNAME COMMAND               : SEND 'COMMAND' TO SESSION 'NAME'\n", tintin_char);
  printf("%csnoop [SESSIONNAME]        : SNOOP/UNSNOOP A SESSION\n", tintin_char);
  printf("%cspeedwalk                  : TURN SPEEDWALKING ON/OFF\n", tintin_char);
  printf("%csubstitute [TEXT [TEXT]]   : LIST/DISPLAY/DEFINE SUBS\n", tintin_char);
  printf("%csystem SHELL-COMMAND       : EXECUTE SHELL COMMAND\n", tintin_char);
  printf("%ctick                       : DISPLAY #SECONDS TO NEXT TICK\n", tintin_char);
  printf("%ctickon/tickoff             : TURN TICK WARNINGS ON/OFF\n", tintin_char);
  printf("%cticksize NUMBER            : SET THE LENGTH OF A TICK\n", tintin_char);
  printf("%cunalias/unaction/unsubs    : DELETE ACTIONS/ALIASES/SUBS\n", tintin_char);
  printf("%cunpath                     : REMOVE LAST MOVE ON PATH\n", tintin_char);
  printf("%cwizlist                    : LEARN THIS LIST BY HEART!\n", tintin_char);
  printf("%cwrite FILENAME             : WRITE ALL KNOWN TO A SESSION\n", tintin_char);
  printf("%cwritesession FILENAME      : WRITE ALL SPECIAL TO A SESSION\n", tintin_char);
  printf("%czap                        : CUT CONNECTION TO CURRENT SESSION\n", tintin_char);
  prompt(ses);
}
