/*********************************************************************/
/* file: main.c - main module - signal setup/shutdown etc            */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <conio.h>
#include <time.h>
#include <string.h>
#include <signal.h>
#include "tintin.h"
#include <process.h>

#ifndef BADSIG
  #define BADSIG (void (*)())-1
#endif

/*************** globals ******************/
int term_echoing=TRUE;
int echo=DEFAULT_ECHO;
int ignore=DEFAULT_IGNORE;
int speedwalk=DEFAULT_SPEEDWALK;
int sessionsstarted;
struct session *sessionlist, *activesession;
struct listnode *common_aliases, *common_actions, *common_subs;
char vars[10][BUFFER_SIZE]; /* the &0, &1, &2,....&9 variables */
char tintin_char=DEFAULT_TINTIN_CHAR;
#ifdef WIN32
int TimeToQuit=0;
#endif

/************ externs *************/
extern int ticker_interrupted, time0;
extern int tick_size, sec_to_tick;
extern int ignore;

/**************************************************************************/
/* main() - show title - setup signals - init lists - readcoms - tintin() */
/**************************************************************************/
main(int argc, char *argv[])
{
  puts("##################################################");
  puts("#                 T I N T I N                    #");
  puts("#                 version III                    #");
  puts("#  (T)he k(I)cki(N) (T)ickin d(I)kumud clie(N)t  #");
  puts("#  a DIKU-mud client coded by peter unold 1992.  #");
  puts("##################################################");
  puts("#  (Ported to WinNt by johnmil@cs.cmu.edu 1995)  #");
  puts("##################################################");
  prompt(NULL);

#ifndef WIN32
  if(signal(SIGTERM, myquitsig)==BADSIG)
    syserr("signal SIGTERM");
  if(signal(SIGINT, myquitsig)==BADSIG)
    syserr("signal SIGINT");
  if(signal(SIGALRM, tick_func)==BADSIG)
    syserr("signal SIGALRM");
#endif
#ifdef WIN32
  {
    WORD wVersionRequested;
    WSADATA wsaData;

    wVersionRequested = MAKEWORD(1,1);
    WSAStartup(wVersionRequested,&wsaData);
  }

#endif
  time0=time(NULL);
#ifndef WIN32
  alarm(1);
#endif

  common_aliases=init_list();
  common_actions=init_list();
  common_subs=init_list();

  if(argv[1])
    activesession=read_command(argv[1], NULL);

  tintin();

  WSACleanup();
  return(0);
}

#ifdef WIN32
/****************************************/
/* Separate thread to handle user input */
/****************************************/
void
InputThreadProc(
   LPVOID vArg
   )
{
   int didget=0;
   char buffer[BUFFER_SIZE];
   HANDLE hConsoleInput;
   DWORD dwMode;

   hConsoleInput=GetStdHandle(STD_INPUT_HANDLE);

   while (TRUE) {
      GetConsoleMode(hConsoleInput,&dwMode);
      if (term_echoing)
      {
         if (!(dwMode & ENABLE_ECHO_INPUT))
         {
            SetConsoleMode(hConsoleInput,dwMode | ENABLE_ECHO_INPUT);
         }
      }
      else
      {
         if (dwMode & ENABLE_ECHO_INPUT)
         {
            SetConsoleMode(hConsoleInput,dwMode ^ ENABLE_ECHO_INPUT);
         }
      }

      didget = read(0, buffer,sizeof(buffer));
      *(buffer+didget-1)='\0';
      if(activesession && term_echoing)
         do_history(buffer, activesession);
      activesession=parse_input(buffer, activesession);
   }
   _endthread();
}

#endif

/***************************/
/* the main loop of tintin */
/***************************/
void tintin()
{
  int didget=0;
#ifdef WIN32
  fd_set readfdmask;
  struct timeval timeout={1,0};
#else
  char buffer[BUFFER_SIZE];
  int readfdmask;
#endif
  struct session *sesptr;

#ifdef WIN32
  /* establish a separate thread for user IO */
  _beginthread(InputThreadProc,4096,NULL);
  TimeToQuit=0;
#endif

  while(!TimeToQuit) {

#ifdef WIN32
    FD_ZERO(&readfdmask);
#else
    readfdmask=1;
#endif
    for(sesptr=sessionlist; sesptr; sesptr=sesptr->next)
    {
#ifdef WIN32
      FD_SET(sesptr->socket,&readfdmask);
#else
      readfdmask|=sesptr->socketbit;
#endif
    }
#ifdef WIN32
    if (sessionlist == NULL) {
        Sleep(500);
    }
#endif
    ticker_interrupted=FALSE;
    if(select(32, &readfdmask,  0, 0, &timeout)<0 && !ticker_interrupted)
    {
      syserr("select");
    }
    if(ticker_interrupted)
      ticker_interrupted=FALSE;
    else {
      didget=0;
#ifndef WIN32
      /* Since input is handled by a separate thread, we don't worry
       * about it here for winnt.
       */

      if(readfdmask&1) {
        if((didget=read(0, buffer, sizeof(buffer)))<0)
          syserr("read from fd 0");
        *(buffer+didget-1)='\0';
        if(activesession && term_echoing)
          do_history(buffer, activesession);
        activesession=parse_input(buffer, activesession);
      }
#endif

      for(sesptr=sessionlist; sesptr; sesptr=sesptr->next)
#ifdef WIN32
        if(FD_ISSET(sesptr->socket,&readfdmask))
#else
        if(sesptr->socketbit&readfdmask)
#endif
          read_mud(sesptr);
#ifdef WIN32
	tick_func();
#endif
    }

  }
}

/*************************************************************/
/* read text from mud and test for actions/snoop/substitutes */
/*************************************************************/
void read_mud(struct session *ses)
{
  char buffer[BUFFER_SIZE],
#ifdef WIN32
       subresult[BUFFER_SIZE];
#else
       subresult[BUFFER_SIZE],
       linebuffer[BUFFER_SIZE],
       *cp, *cpsource, *cpdest;
#endif
  int didget;

  if(!(didget=read_buffer_mud(buffer, ses))) {
    cleanup_session(ses);
    if(ses==activesession)
      activesession=newactive_session();
  }

  else {
    if(ses->logfile)
      fwrite(buffer, didget, 1, ses->logfile);

      do_all_subs(buffer, subresult, ses);

      if(ses==activesession)
        write(1, subresult, strlen(subresult));
      else if(ses->snoopstatus)
        snoop(buffer, ses);
      if(!ignore)
        split_check_all_actions(buffer, ses);
  }
}

/**********************************************************/
/* snoop session ses - chop up lines and put'em in buffer */
/**********************************************************/
void snoop(char *buffer, struct session *ses)
{
#ifndef WIN32
  int n;
#endif
  char *cpsource, *cpdest, linebuffer[BUFFER_SIZE];

  putchar('\n');

  cpsource=buffer;
  cpdest=linebuffer;

  while(*cpsource) {  /*cut out each of the lines and sub'em if a sub is triggered*/
    if(*cpsource=='\n' || *cpsource=='\r') {
      *cpdest='\0';
      if(*linebuffer!='\0')
        printf("%s%% %s\n", ses->name, linebuffer);
      if(*cpsource=='\n' || *cpsource=='\r')
        cpsource++;
      cpdest=linebuffer;
    }
    else
      *cpdest++=*cpsource++;
  }

  *cpdest='\0';
  if(*linebuffer!='\0')
    printf("%s%% %s\n", ses->name, linebuffer);

}

/*****************************************************/
/* output to screen should go throught this function */
/* text gets checked for actions                     */
/*****************************************************/
void tintin_puts(char *cptr, struct session *ses)
{
  if(ses==activesession || ses==NULL) {
    printf("%s\n\r", cptr);
    prompt(ses);
  }

  if(ses)
    check_all_actions(cptr, ses);
}

/****************************************/
/* alarm signal handler used for ticker */
/****************************************/
static void tick_func()
{
  static int tickfoo=1;

  ticker_interrupted=TRUE;

#ifndef WIN32
  alarm(1);
  if(signal(SIGALRM, tick_func)==BADSIG)
    syserr("signal SIGALRM");
#endif

  sec_to_tick=tick_size-((time(NULL)-time0)%tick_size);
  if(sec_to_tick==tick_size || sec_to_tick==10) {
    struct session *sesptr;
    for(sesptr=sessionlist; sesptr; sesptr=sesptr->next)
      if(sesptr->tickstatus)
#ifdef WIN32
        /* Since tick_func is getting called a couple times a second, we have
         * to make sure we don't print tick messages twice.
         */
        if ((sec_to_tick==tick_size)&&(!tickfoo))
		{
          tintin_puts("#TICK!!!", sesptr);
		  tickfoo = 1;
	    }
        if ((sec_to_tick!=tick_size)&&(tickfoo))
		{
          tintin_puts("#10 SECONDS TO TICK!!!", sesptr);
		  tickfoo = 0;
		}
#else
        if(sec_to_tick==tick_size)
          tintin_puts("#TICK!!!", sesptr);
        else
          tintin_puts("#10 SECONDS TO TICK!!!", sesptr);
#endif
  }
}

/**********************************************************/
/* Here's where we go when we wanna quit TINTIN FAAAAAAST */
/**********************************************************/
void myquitsig()
{
  struct session *sesptr;

  for(sesptr=sessionlist; sesptr; sesptr=sesptr->next)
    cleanup_session(sesptr);

  puts("\n\rYour fireball hits TINTIN with full force, causing an immediate death.");
  puts("TINTIN is dead! R.I.P.");
  puts("Your blood freezes as you hear TINTIN's death cry.");
#ifdef WIN32
  TimeToQuit=1;
  Sleep(1000);
  WSACleanup();
#endif
  exit(0);
}
