/*********************************************************************/
/* file: files.c - funtions for logfile and reading/writing comfiles */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <stdio.h>
#include <string.h>
#include "tintin.h"

struct listnode *common_aliases, *common_actions, *common_subs;

struct session *write_command(char *filename, struct session *ses);
struct session *writesession_command(char *filename, struct session *ses);

/********************/
/* the #log command */
/********************/
void log_command(char *arg, struct session *ses)
{
  if(ses) {
    if(!ses->logfile) {
      if(*arg) { 
        if(ses->logfile=fopen(arg, "w"))
          tintin_puts("#OK. LOGING.....", ses);
        else
         tintin_puts("#COULDN'T OPEN FILE.", ses);
      }
      else
        tintin_puts("#SPECIFY A FILENAME.", ses);
    }
    else {
      fclose(ses->logfile);
      ses->logfile=NULL;
      tintin_puts("#OK. LOGGING TURNED OFF.", ses);
    }
  }
  else
   tintin_puts("#THERE'S NO SESSION TO LOG.", ses);
}

/***********************************/
/* read and execute a command file */
/***********************************/
struct session *read_command(char *filename, struct session *ses)
{
  FILE *myfile;
  char buffer[BUFFER_SIZE], *cptr;

  if((myfile=fopen(filename, "rt"))==NULL) {
    tintin_puts("#ERROR - COULDN'T OPEN THAT FILE.", ses);
    return ses;
  }

  while(fgets(buffer, sizeof(buffer), myfile)) {
    for(cptr=buffer; *cptr && *cptr!='\n'; cptr++);
    *cptr='\0';
    ses=parse_input(buffer, ses); 
  }

  fclose(myfile);
  return ses;
}

/************************/
/* write a command file */
/************************/
struct session *write_command(char *filename, struct session *ses)
{
  FILE *myfile;
  char buffer[BUFFER_SIZE];
  struct listnode *nodeptr;

  if((myfile=fopen(filename, "w"))==NULL) {
    tintin_puts("#ERROR - COULDN'T OPEN THAT FILE.", ses);
    return NULL;
  }

  nodeptr=(ses) ? ses->aliases : common_aliases;
  while(nodeptr=nodeptr->next) {
    prepare_for_write("#alias", nodeptr->left, nodeptr->right, buffer);
    fputs(buffer, myfile);
  }

  nodeptr=(ses) ? ses->actions : common_actions;
  while(nodeptr=nodeptr->next) {
    prepare_for_write("#action", nodeptr->left, nodeptr->right, buffer);
    fputs(buffer, myfile);
  }

  nodeptr=(ses) ? ses->subs : common_subs;
  while(nodeptr=nodeptr->next) {
    prepare_for_write("#substitute", nodeptr->left, nodeptr->right, buffer);
    fputs(buffer, myfile);
  }

  fclose(myfile);
  tintin_puts("#COMMANDO-FILE WRITTEN.", ses);
  return ses;
}

/************************/
/* write a command file */
/************************/
struct session *writesession_command(char *filename, struct session *ses)
{
  FILE *myfile;
  char buffer[BUFFER_SIZE];
  struct listnode *nodeptr;

  if((myfile=fopen(filename, "w"))==NULL) {
    tintin_puts("#ERROR - COULDN'T OPEN THAT FILE.", ses);
    return NULL;
  }

  nodeptr=(ses) ? ses->aliases : common_aliases;
  while(nodeptr=nodeptr->next) {
    if(ses && searchnode_list(common_aliases, nodeptr->left))
      continue;
    prepare_for_write("#alias", nodeptr->left, nodeptr->right, buffer);
    fputs(buffer, myfile);
  }

  nodeptr=(ses) ? ses->actions : common_actions;
  while(nodeptr=nodeptr->next) {
    if(ses && searchnode_list(common_actions, nodeptr->left))
      continue;
    prepare_for_write("#action", nodeptr->left, nodeptr->right, buffer);
    fputs(buffer, myfile);
  }

  nodeptr=(ses) ? ses->subs : common_subs;
  while(nodeptr=nodeptr->next) {
    if(ses && searchnode_list(common_subs, nodeptr->left))
      continue;
    prepare_for_write("#substitute", nodeptr->left, nodeptr->right, buffer);
    fputs(buffer, myfile);
  }

  fclose(myfile);
  tintin_puts("#COMMANDO-FILE WRITTEN.", ses);
  return ses;
}


void prepare_for_write(char *command, char *left, char *right, char *result)
{
  char tmpbuf[BUFFER_SIZE];
  strcpy(result, command);
  strcat(result, " ");

  if(*get_arg_stop_spaces(left, tmpbuf)) {
    strcat(result, "\"");
    prepare_quotes(left);
    strcat(result, left);
    strcat(result, "\"");
  }
  else
    strcat(result, left);
  
  strcat(result, " ");

  if(*get_arg_stop_spaces(right, tmpbuf)) {
    strcat(result, "\"");
    prepare_quotes(right);
    strcat(result, right);
    strcat(result, "\"");
  }
  else
    strcat(result, right);
  strcat(result, "\n");
}

void prepare_quotes(char *string)
{
  char s[BUFFER_SIZE], *cpsource, *cpdest;

  strcpy(s, string);

  cpsource=s;
  cpdest=string;

 while(*cpsource) {
    if(*cpsource=='\\') {
      *cpdest++=*cpsource++;
      if(*cpsource)
        *cpdest++=*cpsource++;
    }
    else if(*cpsource=='\"') {
      *cpdest++='\\';
      *cpdest++=*cpsource++;
    }
    else
      *cpdest++=*cpsource++; 
  }
  *cpdest='\0';
}


