/*********************************************************************/
/* file: echo.c - funtions to turn keyboard echo on/off              */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
/* This might not work on some exotic unix versions. Nothin I can do */
/* about it, coz most of this was lifted from other programs...      */
/*********************************************************************/
#include "tintin.h"

#ifndef WIN32
#if defined(aix) || defined(hpux) || defined(_SEQUENT_) || defined(DO_TERMIO)
#include <sys/termio.h>
#else
#include <sgtty.h>
#if DIRTY_REDEFINE
#undef TIOCGETP
#undef TIOCSETP
#define TIOCGETP 0x40067408
#define TIOCSETP 0x80067409
#endif
#endif
#endif /* ! defined WIN32 */

#if defined(hpux) || defined(aix) || defined(_SEQUENT_)

/********************************/
/* turn echo on - HP-UX version */
/********************************/
void term_echo()
{
  struct  termio io;

  if(ioctl(0, TCGETA, &io)<0)
    syserr("ioctl");
  io.c_lflag|=ECHO; 
  if(ioctl(0, TCSETA, &io)<0)
    syserr("ioctl");
}

/*********************************/
/* turn echo off - HP-UX version */
/*********************************/
void term_noecho()
{
#ifndef WIN32
  struct  termio io;

  if(ioctl(0, TCGETA, &io)<0)
    syserr("ioctl");
  io.c_lflag &= ~ECHO; 
  if(ioctl(0, TCSETA, &io)<0)
    syserr("ioctl");
#endif
}

#else
/********************************/
/* turn echo on - SunOS version */
/********************************/
void term_echo()
{
#ifndef WIN32
  struct  sgttyb sgbuf;
  if(ioctl(0, TIOCGETP, &sgbuf)<0)
    syserr("ioctl");
  sgbuf.sg_flags |= ECHO;
  if(ioctl(0, TIOCSETP, &sgbuf)<0)
    syserr("ioctl");
#endif
}

/**********************************/
/* turn echo off  - SunOS version */
/**********************************/
void term_noecho()
{
#ifndef WIN32
  struct  sgttyb sgbuf;

  if(ioctl(0, TIOCGETP, &sgbuf)<0)
    syserr("ioctl");
  sgbuf.sg_flags &= ~ECHO;
  if(ioctl(0, TIOCSETP, &sgbuf)<0)
    syserr("opctl");
#endif
}
#endif












