/*********************************************************************/
/* file: alias.c - funtions related the the alias command            */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <string.h>
#include "tintin.h"

extern struct listnode *common_aliases;
extern char vars[10][BUFFER_SIZE]; /* the &0, &1, &2,....&9 variables */

/**********************/
/* the #alias command */
/**********************/
void alias_command(char *arg, struct session *ses)
{
  char left[BUFFER_SIZE], right[BUFFER_SIZE];
  struct listnode *myaliases, *ln;

  myaliases=(ses) ? ses->aliases : common_aliases;

  arg=get_arg_stop_spaces(arg, left);
  arg=get_arg_with_spaces(arg, right);

  if(!*left) {
    puts("#THESE ALIASES HAS BEEN DEFINED:");
    show_list(myaliases);
    prompt(ses);
  }

  else if(*left && !*right) {
    if((ln=searchnode_list(myaliases, left))!=NULL) {
      shownode_list(ln);
      prompt(ses);
    }
    else
      tintin_puts("#THAT ALIAS IS NOT DEFINED.", ses);
  }

  else {
    if((ln=searchnode_list(myaliases, left))!=NULL)
      deletenode_list(myaliases, ln);
    insertnode_list(myaliases, left, right);
    tintin_puts("#OK. ALIAS DEFINED.", ses);
  }
}

/************************/
/* the #unalias command */
/************************/
void unalias_command(char *arg, struct session *ses)
{
  char left[BUFFER_SIZE];
  struct listnode *myaliases, *ln;

  myaliases=(ses) ? ses->aliases : common_aliases;
  arg=get_arg_stop_spaces(arg, left);


  if((ln=searchnode_list(myaliases, left))!=NULL) {
    deletenode_list(myaliases, ln);
    tintin_puts("#OK. ALIAS DELETED", ses);
  }
  else
    tintin_puts("#THAT ALIAS IS NOT DEFINED.", ses);
}
