/*
	Copyright (C) 1991, Marcus J. Ranum. All rights reserved.
*/

#ifndef	lint
static	char	RCSid[] = "$Header: /usr/users/mjr/hacks/umud/RWHO/RCS/mudwho.c,v 1.6 91/06/16 18:33:51 mjr Exp $";
#endif


#include	<stdio.h>
#include	<sys/types.h>
#include	<errno.h>
extern	int	errno;
#include	<ctype.h>
#include	<fcntl.h>

#ifdef WIN32

#include <winsock.h>
#include <io.h>
#include <time.h>
#include <stdlib.h>

#else

#include	<sys/time.h>
#include	<sys/file.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>

#endif

#define	STREAMPORT		6889

#define	ENVHOST		"MUDWHOSERVER"
#define	ENVPORT		"MUDWHOPORT"


#ifndef	NO_HUGE_RESOLVER_CODE 
#ifndef WIN32
extern	struct	hostent	*gethostbyname();
#endif
#endif

extern	char	*getenv();
extern	char	*optarg;


int usage()
{

	fprintf(stderr,"usage: mudwho [-S server] [-P servport] [-u user] [-m mud]\n");
	fprintf(stderr,"\twhere user is someone to scan for\n");
	fprintf(stderr,"\tmud is a specific MUD to scan for\n");
	fprintf(stderr,"\t%s and %s can be set in the environment\n",ENVPORT,ENVHOST);
	return(1);
}


void main(argc,argv)
int	argc;
char	*argv[];
{
	struct	sockaddr_in	addr;
	struct	hostent		*hp;
	int			fd;
	char			*p;
	int			red;
	char			rbuf[1024];
	char			*srv;
	u_short			portnum = STREAMPORT;
	char			*checkwho = (char *)0;
	char			*checkmud = (char *)0;
	WSADATA WSAData;
	int err;

 int current_arg = 1;
   BOOLEAN more_args = TRUE;
   BOOLEAN done = FALSE;
  
	srv = getenv("ENVHOST");
	if (srv == NULL)
	   printf("get env host failed \n");

	if((p = getenv("ENVPORT")) != (char *)0)
		portnum = atoi(p);

// lgk no getopt function in win32 so write it
// what is it doing here?
   /* process arguments */
		
    do 
     {
	 // only if we have args
      /* get the first one and if it doesn't start with a - we have a problem */
	
	if (argc > current_arg)
	  {	
       switch (argv[current_arg][1])
           {

			case 'S':	// get the server
			if (argc < current_arg + 2)
			  exit(usage());
			srv = argv[current_arg+1];
			++current_arg;
			break;

		case 'P':
			if (argc < current_arg + 2)
			  exit(usage());
			portnum = atoi(argv[current_arg+1]);
			++current_arg;
			break;

		case 'u':
			if (argc < current_arg + 2)
			  exit(usage());
			checkwho = argv[current_arg+1];
			++current_arg;
			break;

		case 'm':
			if (argc < current_arg + 2)
			  exit(usage());
			checkmud = argv[current_arg+1];
			++current_arg;
			break;

		default:
			exit(usage());			 // assign paffin value 
	
	} /* end of switch */
						 
	}		   
    ++current_arg;
	if (current_arg >= argc)
	  more_args = FALSE;
	

    } while ((!done) && (more_args));



	if(srv == (char *)0) {
		fprintf(stderr,"rwho server host must be provided [-S host]\n");
		exit(1);
	}

/*	if(checkmud != (char *)0 && checkwho != (char *)0) {
		fprintf(stderr,"You can only search for one user or MUD entry\n");
		exit(1);
	}

*/    
  if ((err = WSAStartup((WORD)0x0101, &WSAData))!=0)  // register task with
  {                                         // winsock tcp/ip API
    fprintf(stderr,"ERROR: WSAStartup failed errorcode = %d\n",WSAGetLastError());
  } else 
  {

	p = srv;
	while(*p != '\0' && (*p == '.' || isdigit(*p)))
		p++;

	/* not all digits or dots */
	if(*p != '\0') 
	 {
#ifndef	NO_HUGE_RESOLVER_CODE
		if((hp = gethostbyname(srv)) == NULL)
		 {
			fprintf(stderr,"unknown host %s\n",srv);
            WSACleanup();
			exit(1);	              
		}
   
  // map host to ip, allow ip

#ifdef WIN32
         memcpy((char *)&addr.sin_addr,hp->h_addr,hp->h_length);
#else
		(void)bcopy(hp->h_addr,(char *)&addr.sin_addr,hp->h_length);
#endif

#else
		fprintf(stderr,"must use numerical notation for host name\n");
		exit(1);
#endif
	} else {
		unsigned long	f;

		if((f = inet_addr(srv)) == -1L) 
		{
			fprintf(stderr,"unknown host %s\n",srv);
			exit(1);
		}
#ifdef WIN32
	    memcpy((char *)&f,(char *)&addr.sin_addr,sizeof(f));
#else
		(void)bcopy((char *)&f,(char *)&addr.sin_addr,sizeof(f));

#endif
	}
#ifdef WIN32
	addr.sin_port = htons(portnum);
#else
	addr.sin_port = htons(portnum);
#endif
	addr.sin_family = AF_INET;

	if((fd = socket(AF_INET,SOCK_STREAM,0)) < 0) 
	{
		perror("socket");
		WSACleanup();
		exit(1);
	}
 
  printf("Connecting to %s ...\n",inet_ntoa(addr.sin_addr));
  fflush(stdout);

	if(connect(fd,
#ifdef WIN32
(struct sockaddr *)
#endif

&addr,sizeof(addr)) < 0) 
    {
		perror("connect");
		exit(1);
	}

 // lgk the mudwho servers have changed and now do not support requests but
 //on connection seem to return the data so modify program accordingly.

	/* send request if one */
	if(checkmud != (char *)0 || checkwho != (char *)0) {
		char	xuf[512];
		int	xlen;

		sprintf(xuf,"%s=%.30s",
			checkmud == (char *)0 ? "who" : "mud",
			checkmud == (char *)0 ? checkwho : checkmud);

		xlen = strlen(xuf) + 1;
// lgk cannot do write in win32 so change to send
#ifdef WIN32
		if(send(fd,xuf,xlen,0) != xlen) {
#else
		if(write(fd,xuf,xlen) != xlen) {
#endif
			perror("write to rwho server failed");
			closesocket(fd);
  		    WSACleanup();

			exit(1);
		}
	}

// lgk cannot do read in win32 so change to recv
#ifdef WIN32
	while((red = recv(fd,rbuf,sizeof(rbuf),0)) > 0)
		write(1,rbuf,red);

		closesocket(fd);
		WSACleanup();
	exit(0);
#else
	while((red = read(fd,rbuf,sizeof(rbuf))) > 0)
		write(1,rbuf,red);
	exit(0);

#endif
	
}
}

