/* 
**********************************************************************
*                      MKINDEX,  28.07.1995.                         *
*                 Directory Documentation Utility                    *
**********************************************************************/
#include <windows.h>
#include <string.h>
#include <stdio.h>

#define MAXENTRY 4096 /* MSLFiles directory would be too much for us ... */
			 
const int iVer=1,iRev=00;
const char *Copyright="(c)Pekic Zoltan, 1995. (zoltanp@rijeka.riteh.hr)\n\n";
const char *Explanation="Directory documentation utility\n";
char cXFileName[64]="INDEX.TXT";
char cYFileName[64]="\0\0\0\0";
char cStartDir[128]=".";
char cCurrDir[128];
int  bRecurse=FALSE;
int  bDeleteMode=FALSE;
int  bRenameMode=FALSE;
int  bCreateMode=TRUE; 
int  iOrd1=2;     /* BY DATE   */
int  bOrd2=FALSE; /* RECENT FILES FIRST */
int  bCatchHidden=FALSE;
int  bCatchSystem=FALSE;
HANDLE hStdError;
OSVERSIONINFO OSVI;
int  bWin95=FALSE;

int iTCntAdd=0,iTCntChg=0,iTCntDel=0,iTCntIndexDel=0,iTCntIndexRen=0,iTCntDir=0; /* global report counters */

typedef struct IndexEntry 
{
 int bIsComment;
 int iX;
 WORD     wDate;
 DWORD    nFileSizeHigh;
 DWORD    nFileSizeLow;
 TCHAR    cFileName[ MAX_PATH ];
 TCHAR    cAlternateFileName[ 14 ];
 char cComm[256];
};

struct IndexEntry FileList[MAXENTRY+1]; 

void Initialize()
{
 hStdError=GetStdHandle(STD_ERROR_HANDLE);
 GetCurrentDirectory(128,cCurrDir);
 printf("\n");
 printf("MkIndex V%i.%02i  - %s",iVer,iRev,Explanation);
 printf(Copyright);
};

void WriteHelp()
{
 printf("MKINDEX [/S] [/D|/R] [/A:HS] [/O[:]N|S|D[+|-]] [Path] [FileName] [NewFileName]\n");
 printf("\n");
 printf("/S           Recurse subdirectories\n");
 printf("/D           Delete index file(s)\n");
 printf("/R           Rename index file(s) - path and both filenames must be specified\n");
 printf("/A           Also include in documentation:\n");
 printf("             H Hidden files\n");
 printf("             S System files\n");
 printf("/O           Sort order: (+ normal, - reverse)\n");
 printf("             N by file name\n");
 printf("             S by file size\n");
 printf("             D by file date (default)\n");
 printf("Path         Starting directory (Default: Current)\n");
 printf("             Enter . for current dir if filename(s) are required\n");
 printf("FileName     Index File Name    (Default: INDEX.TXT)\n");
 printf("NewFileName  For rename mode only\n");
 printf("\n");
};

void TheEnd(UINT uRetVal,char *cMsg,char *cPar)
{
 char cErr[80];
 DWORD dwWritten;

 if (cMsg)
 {
  sprintf(cErr,cMsg,cPar);
  WriteConsole(hStdError,cErr,strlen(cErr),&dwWritten,NULL);
 }
 if (uRetVal==1) WriteHelp();
 ExitProcess(uRetVal);
}

void GetCmdLine(unsigned iParamCount, char *cParam[])
{
 enum FilePar {PAR_PATH,PAR_XNAME,PAR_YNAME,PAR_EXCESS};
 int iFilePar=PAR_PATH;
 unsigned i,j;
 char cP[64];

 for(i=1;i<iParamCount;i++)
 {
  strcpy(cP,cParam[i]);
  if ((cP[0]=='-') || (cP[0]=='/'))
  {
   switch (toupper(cP[1]))
   {
    case '?':
    case 'H':TheEnd(1,NULL,NULL);
         break;
    case 'S':
         bRecurse=TRUE;
         break;
    case 'D':
         bDeleteMode=TRUE;
		 bCreateMode=FALSE;
		 if (bRenameMode) TheEnd(1,"Error: Cannot combine rename and delete.\n",NULL);
		 break;
    case 'R':
         bRenameMode=TRUE;
		 bCreateMode=FALSE;
		 if (bDeleteMode) TheEnd(1,"Error: Cannot combine delete and rename.\n",NULL);
		 break;
    case 'A':
         for(j=2;j<strlen(cP);j++)
	     {
          switch (toupper(cP[j]))
		  {
		   case ':':break;
           case 'H':
                bCatchHidden=TRUE;
				break;
           case 'S':
                bCatchSystem=TRUE;
			    break;
           default:
                TheEnd(1,"Error: invalid file attribute option.\n",NULL);
          };
         };
		 break;
    case 'O':
         for(j=2;j<strlen(cP);j++) 
		 {
		  switch (toupper(cP[j]))
		  {
           case ':':
           case '+':break;
           case 'N':
                iOrd1=1;
                bOrd2=TRUE;
                break;
           case 'D':
                iOrd1=2;
				break;
           case 'S':
                iOrd1=3;
                bOrd2=TRUE;
                break;
           case '-':
                bOrd2 = !bOrd2;
			    break;
           default:
                TheEnd(1,"Error: invalid sort order option.\n",NULL);
          };
         };
		 break;
    default:
        TheEnd(1,"Error: invalid command line switch.\n",NULL);
    };
   }
   else 
   switch (iFilePar)
   {
    case  PAR_PATH:
          strcpy(cStartDir,cP);
		  iFilePar=PAR_XNAME;
		  break;
    case PAR_XNAME:
          strcpy(cXFileName,cP);
		  iFilePar=PAR_YNAME;
		  break;
    case PAR_YNAME:
          strcpy(cYFileName,cP);
		  iFilePar=PAR_EXCESS;
		  break;
	default:
	     TheEnd(1,"Error: excessive file specifier.\n",NULL);
   };
  }
  if (bRenameMode && (cYFileName[0]=='\0')) TheEnd(1,"Error: missing new filename.\n",NULL);
};

int LoadFileList()
{
 char cRawLine[512];
 char cPart[4][256];
 int iC,iP;
 int iLineCnt=0;
 char cThis,cLast=' ';
 int iY,iM,iD;
 long lDate,lSize;

 FILE *pfIndex=fopen(cXFileName,"r");
 if (pfIndex==NULL) TheEnd(2,"Error: Cannot open %s\n",cXFileName);
 while(fgets(cRawLine,512,pfIndex))
 {
  for(iP=0;iP<=3;iP++) memset(cPart[iP],'\0',256);
  iP=0;
  for(iC=0;(cThis=cRawLine[iC]) != '\n';iC++)
  {
   switch(cThis)
   {
    case ' ':{
			  if (iP==3) strncat(cPart[iP],&cThis,1);
		      else if (cLast != ' ') iP++;
			 };
			 break; 
	case ';':
	case '#':{
	          iP=3; 
			  strncat(cPart[iP],&cThis,1);
	         };
			 break;
	default:strncat(cPart[iP],&cThis,1);
   };
   cLast=cThis;
  };
  if ((lDate=atol(cPart[0])) && (lSize=atol(cPart[1])) && (strlen(cPart[2])))
  {
   FileList[++iLineCnt].bIsComment=FALSE;
   FileList[iLineCnt].iX=0;
   iY=lDate / 10000;
   iM=(lDate-iY*10000) / 100;
   iD=lDate-iY*10000-iM*100;
   FileList[iLineCnt].wDate=(((iY-80) & 0x3F) << 9) | ((iM & 0x0F) << 5) | (iD & 0x1F);  
   FileList[iLineCnt].nFileSizeHigh=0;
   FileList[iLineCnt].nFileSizeLow=lSize;
   strcpy(FileList[iLineCnt].cFileName,cPart[2]);
   strcpy(FileList[iLineCnt].cAlternateFileName,"\0");
   strcpy(FileList[iLineCnt].cComm,strlen(cPart[3]) ? cPart[3] : ";");
  }
  else
  {
   FileList[++iLineCnt].bIsComment=TRUE;
   FileList[iLineCnt].iX=0;
   FileList[iLineCnt].wDate=0;  
   FileList[iLineCnt].nFileSizeHigh=0;
   FileList[iLineCnt].nFileSizeLow=0;
   strcpy(FileList[iLineCnt].cFileName,"\0");
   strcpy(FileList[iLineCnt].cAlternateFileName,"\0");
   strcpy(FileList[iLineCnt].cComm,strlen(cPart[3]) ? cPart[3] : ";");
  };
 };
 fclose(pfIndex);
 return(iLineCnt);
};

void SortFileList(int iFileCount,char *pcSmallDir,char *pcXFileName)
{  /* Be patient: a lousy bubble sort ... */
 int i,j;
 struct IndexEntry FI,FJ;
 int bSwapThem;
 char cOldCT[128],cNewCT[128];
 int bPreventPanic,iOldPercent=0,iNewPercent;
 
 if (bPreventPanic=(iFileCount>128)) GetConsoleTitle(cOldCT,128);
 for(i=1;i<iFileCount;i++)
 {
  if (bPreventPanic)
  {
   iNewPercent=i*100/iFileCount;
   if (iNewPercent != iOldPercent)
   {
    sprintf(cNewCT,"MkIndex is sorting %s\\%s ... %i%%",pcSmallDir,pcXFileName,iNewPercent);
    SetConsoleTitle(cNewCT);
    iOldPercent=iNewPercent;
   };
  };
  for(j=i+1;j<=iFileCount;j++)
  {
   FI=FileList[i];
   FJ=FileList[j];
   if ((!FI.bIsComment) && (!FJ.bIsComment))
   {
    switch(iOrd1)
    {
     case 1:bSwapThem=(stricmp(FI.cFileName,FJ.cFileName)<0);
            break;
     case 2:bSwapThem=(FI.wDate < FJ.wDate);
            break;
     case 3:bSwapThem=(FI.nFileSizeHigh==FJ.nFileSizeHigh ? (FI.nFileSizeLow>FJ.nFileSizeLow) : FI.nFileSizeHigh>FJ.nFileSizeHigh);  
            break;
    }
    if(bOrd2) bSwapThem= !bSwapThem;
    if(bSwapThem)
    {
     FileList[i]=FJ;
     FileList[j]=FI;
    };  
   }; 
  };
 };	
 if (bPreventPanic) SetConsoleTitle(cOldCT);
};

void WriteFileList(int iFileCount)
{
 int i;
 HANDLE hXF;
 char cBuff[1024];
 DWORD dwWritten,dwFileSize;
 int iY,iM,iD;

 hXF=CreateFile(cXFileName,GENERIC_READ | GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
 if(hXF==INVALID_HANDLE_VALUE) TheEnd(2,"Error: Unable to create %s\n",cXFileName);
 for(i=1;i<=iFileCount;i++)
 {
  if(FileList[i].bIsComment)
  {
   sprintf(cBuff,"%s\r\n",FileList[i].cComm);
   WriteFile(hXF,cBuff,strlen(cBuff),&dwWritten,NULL);
  }
  else
  {
   if (FileList[i].iX)
   {
    dwFileSize=65536*FileList[i].nFileSizeHigh+FileList[i].nFileSizeLow;
    iY=((FileList[i].wDate & 0xFE00) >> 9)+80;
    iM=(FileList[i].wDate & 0x01E0) >> 5;
    iD=FileList[i].wDate & 0x001F;
    sprintf(cBuff,"%02i%02i%02i %9lu %13s %s\r\n",iY,iM,iD,dwFileSize,FileList[i].cFileName,FileList[i].cComm);
    WriteFile(hXF,cBuff,strlen(cBuff),&dwWritten,NULL);
   }
  };
 }; 
 CloseHandle(hXF);
};

void ProcessIndexFile(char *cDir,int bGoUp)
{
 char cThisDir[128],cSmallDir[128];
 WIN32_FIND_DATA FileDescr;
 HANDLE hSearch;
 IndexEntry *DiskList[MAXENTRY+1];
 
 int i,j;
 int iDiskCount=0,iFileCount=0;
 int iCntAdd=0,iCntChg=0,iCntDel=0;
 int bXFileFound=FALSE;
 int bMoreFiles=TRUE,bMemoryOK=TRUE;
 WORD wDOSTime;

 iTCntDir++;
 if (!SetCurrentDirectory(cDir)) TheEnd(2,"Error: The directory %s is invalid.\n",cDir);
 GetCurrentDirectory(128,cThisDir);
 if (strlen(cThisDir)<=35) strcpy(cSmallDir,cThisDir);
 else
 {
  memset(cSmallDir,'\0',128);
  strncpy(cSmallDir,cThisDir,strchr(cThisDir,'\\')-cThisDir+1);
  strcat(cSmallDir," ... ");
  strcat(cSmallDir,strrchr(cThisDir,'\\'));
 };
 hSearch=FindFirstFile("*.*",&FileDescr);
 if (hSearch==INVALID_HANDLE_VALUE) TheEnd(2,"Error: Invalid search handle in %s.\n",cDir);
 while (bMoreFiles && bMemoryOK && (iDiskCount<MAXENTRY))
 {
  int bQueerHidden=(FileDescr.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN); 
  int bQueerSystem=(FileDescr.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM);
  int bStraight=!(bQueerHidden || bQueerSystem); 
  if (bWin95 && strstr(FileDescr.cFileName,".lnk")) break;	/* skip Win95 .lnk files */ 
  if (FileDescr.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
  {
   if (bRecurse && stricmp(FileDescr.cFileName,".") && stricmp(FileDescr.cFileName,"..")) ProcessIndexFile(FileDescr.cFileName,TRUE);
  }
  else
  {
   if (stricmp(FileDescr.cFileName,cXFileName)) 
   {
    if (bStraight || (bQueerHidden && bCatchHidden) || (bQueerSystem && bCatchSystem))
	{
     iDiskCount++;
	 if (DiskList[iDiskCount]=(IndexEntry*) malloc(sizeof(IndexEntry)))
	 {
	  DiskList[iDiskCount]->bIsComment=FALSE;
	  DiskList[iDiskCount]->iX=0;
      FileTimeToDosDateTime(&FileDescr.ftLastWriteTime,&DiskList[iDiskCount]->wDate,&wDOSTime);
	  DiskList[iDiskCount]->nFileSizeHigh=FileDescr.nFileSizeHigh;
	  DiskList[iDiskCount]->nFileSizeLow=FileDescr.nFileSizeLow;
	  strcpy(DiskList[iDiskCount]->cFileName,FileDescr.cFileName);
	  strcpy(DiskList[iDiskCount]->cAlternateFileName,FileDescr.cAlternateFileName);
	  strcpy(DiskList[iDiskCount]->cComm,";\0");
	 }
	 else 
	 {
	  iDiskCount--;
	  bMemoryOK=FALSE;
	 };
	}
   }	  
   else	bXFileFound=TRUE;
  };
  bMoreFiles=FindNextFile(hSearch,&FileDescr);
 };	/* while */
 if (bMoreFiles) printf("Warning: out of memory - %s in %s incomplete.\n",cXFileName,cSmallDir);
 if (bDeleteMode)
 {
  printf(cXFileName);
  if (bXFileFound) 
  {
   if (DeleteFile(cXFileName))
   {
	printf(" deleted from ");
	iTCntIndexDel++;
   }
   else  printf(" not deleted from ");
  }
  else printf(" not found in ");
  printf("%s\n",cSmallDir);
 };
 if (bRenameMode)
 {
  printf("%s in %s",cXFileName,cSmallDir);
  if (bXFileFound) 
  {
   if (MoveFile(cXFileName,cYFileName))
   {
	printf(" renamed to %s\n",cYFileName);
	iTCntIndexRen++;
   }
   else  printf(" could not be renamed.\n");
  }
  else printf(" not found.\n");
 };
 if (bCreateMode)
 {
  if (bXFileFound)
  {
   iFileCount=LoadFileList();	 /* Load index file */
   for(i=1;i<=iFileCount;i++)	 /* Compare File vs. Disk list */
   {
    if (! FileList[i].bIsComment)
    {
     FileList[i].iX=0;
     for(j=1;j<=iDiskCount;j++)
     {
      if (! DiskList[j]->bIsComment)
	  {
	   if (stricmp(FileList[i].cFileName,DiskList[j]->cFileName)==0)
	   { 
	    FileList[i].iX=1;
	    DiskList[j]->iX=1;
	    int bFileChanged=((FileList[i].wDate != DiskList[j]->wDate) ||
	                     (FileList[i].nFileSizeHigh != DiskList[j]->nFileSizeHigh) ||
	                     (FileList[i].nFileSizeLow  != DiskList[j]->nFileSizeLow));
	    if (bFileChanged)
	    {
         FileList[i].wDate=DiskList[j]->wDate;
         FileList[i].nFileSizeHigh=DiskList[j]->nFileSizeHigh;
         FileList[i].nFileSizeLow=DiskList[j]->nFileSizeLow;
	     iCntChg++;
	    };
	   };
	  };
     };		/* next j */
    };
   };       /* next i */
  };
  for(i=1;i<=iDiskCount;i++)  /* Add new files */
  {
   if(DiskList[i]->iX==0)
   {
	DiskList[i]->iX=1;
	FileList[++iFileCount]=*DiskList[i];
	iCntAdd++;
   }; 
  };
  for(i=1;i<=iFileCount;i++) if((FileList[i].iX==0) && !FileList[i].bIsComment) iCntDel++;  /* Remove non-existent files */
  if ((iFileCount>0) || ((iCntAdd+iCntChg+iCntDel)>0))
  {
   iTCntAdd+=iCntAdd;
   iTCntChg+=iCntChg;
   iTCntDel+=iCntDel;
   SortFileList(iFileCount,cSmallDir,cXFileName);
   WriteFileList(iFileCount);
  };
  printf("%5i added %5i changed %5i removed in %s\n",iCntAdd,iCntChg,iCntDel,cSmallDir);
 };
 SetCurrentDirectory((bRecurse && bGoUp) ? ".." : cCurrDir);
 for(i=1;i<=iDiskCount;i++) if (DiskList[i]) free(DiskList[i]);
 if (!bGoUp && (iTCntDir != 1))
 {
  if (bDeleteMode) printf("\n%5i files removed from %5i directories.\n",iTCntIndexDel,iTCntDir);
  if (bRenameMode) printf("\n%5i files renamed in %5i directories.\n",iTCntIndexRen,iTCntDir);
  if (bCreateMode) printf("\n%5i added %5i changed %5i removed in %5i directories.\n",iTCntAdd,iTCntChg,iTCntDel,iTCntDir);
 }
};

int main(int argc, char *argv[], char *envp[])
{
 OSVI.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
 GetVersionEx(&OSVI);
 switch (OSVI.dwPlatformId)
 { 
  case VER_PLATFORM_WIN32s:{
                            MessageBox(NULL,
                            "Win32 Console Application.\nWin95 or Windows NT required.",
                            "Error: wrong OS.",MB_OK | MB_ICONSTOP);
                            return(1);
                           };
  case VER_PLATFORM_WIN32_NT:break;
  default:bWin95=TRUE; 
 };
 Initialize();
 GetCmdLine(argc,argv);
/*
 if (bWin95) if (MessageBox(NULL,
                  "MkIndex has not been sufficiently\n     tested under Win95",
                  "Warning: continue at your own risk ...",MB_OKCANCEL | MB_ICONEXCLAMATION)==IDCANCEL) return(0);
*/
 ProcessIndexFile(cStartDir,FALSE);
 return(0);
};
