/* uniblock.c ... convert Forth 1024-byte BLOCK files to Forth 1024-widechar BLOCK files.
 * Copyright (C) 1993 by
 * jack j. woehr, p.o. box 51, golden, colorado 80402-0051
 * jax@well.sf.ca.us JAX on GEnie 72203.1320@compuserve.com
 * SYSOP, RealTime Control & Forth Board [RCFB] (303) 278-0364
 * All Rights Reserved
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. (doc\license.txt)
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <windows.h>
#include <stdio.h>
#include <string.h>

#define USAGE	"Usage: %s sourcefile destfile\n (or %s /? for help)\n", argv[0], argv[0]

SECURITY_ATTRIBUTES myAttrib;
DWORD numRead;
DWORD numWritten;
char	buff[1024];
char	fubb[2048];

int main (int argc, char *argv[]) {

	DWORD	i;
	int	j = 0;

	DWORD temp = 0;

	HANDLE ifh;
	HANDLE ofh;

	if (argc > 3) {
		fprintf (stderr, USAGE);
		return 99;
	}

	if	(argc == 2)
		if (!(strcmp (argv[1], "/?"))) {
			fprintf (stderr, USAGE);
			fprintf (stderr, "%s\n%s\n%s\n",
				"Converts the ASCII file specified by the sourcefile argument",
				"to a Unicode file twice the size.",
				"Creates destination file or silently overwrites existing file of same name.");
			return	99;
			}

	if (argc < 3) {
		fprintf (stderr, USAGE);
		return 99;
	}

	myAttrib.nLength = sizeof (myAttrib);
	myAttrib.lpSecurityDescriptor = NULL;
	myAttrib.bInheritHandle = TRUE;

	if	(INVALID_HANDLE_VALUE == 
			(ifh = CreateFile (argv[1], GENERIC_READ, 0, &myAttrib, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,0)))
		{
		temp = GetLastError();
		fprintf (stderr, "Couldn't open source file.\n");
		return temp;
		}

	if	(INVALID_HANDLE_VALUE == 
			(ofh = CreateFile (argv[2], GENERIC_WRITE, 0, &myAttrib, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL,0)))
		{
		temp = GetLastError();
		fprintf (stderr, "Couldn't open destination file.\n");
		return temp;
		}

	while (ReadFile (ifh, &buff, 1024, &numRead, 0)) {
		if (numRead == 0)
			return 0;
		for (i = 0; i < numRead; i++) {
			fubb[i*2] = buff[i];
			fubb[(i*2)+1] = 0;
			}
		WriteFile (ofh, &fubb, numRead*2, &numWritten, 0);
		}

	return 0;
}

