#define STRICT
#define _UNICODE
#define UNICODE 

#include <windows.h>
#include <tchar.h>
#include <wchar.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <lm.h> 


/****************************************************************************\
*
* FUNCTION: Main
*
\****************************************************************************/

int main()
{
LPTSTR CommandLine, CommandName, ServerName, UserName, HomeDrive, ChPass;
USER_INFO_3 UserInfo;
DWORD ComOK, ResetPassword;
USER_INFO_3 *InfoPointer;
LPBYTE *Pointer;

CommandName=(LPTSTR) calloc(1024,sizeof(TCHAR));
UserName=CommandName+128;
HomeDrive=UserName+128;
ServerName=HomeDrive+128;
ChPass=ServerName+129;
wprintf(L"\nHome drive modification utility\n(c) Neil Ferguson, Linacre College, Oxford\n\n");
CommandLine=GetCommandLine();
swscanf(CommandLine,L"%s %s %s %s %s",CommandName, ServerName, UserName,HomeDrive, ChPass);
ComOK=ResetPassword=0;
if ((!wcscmp(ChPass,L"/p"))||(!wcscmp(ChPass,L"/P")))
		ResetPassword=1;
else if ((!wcscmp(HomeDrive,L"/p"))||(!wcscmp(HomeDrive,L"/P")))
		{
		ResetPassword=1;
		HomeDrive[0]=0;
		} 
if((wcslen(ServerName)==0)||(wcslen(UserName)==0))
        ComOK=1;
else if(ServerName[0]!=TEXT('\\'))
        {
        ServerName--;ServerName[0]=TEXT('\\');
        ServerName--;ServerName[0]=TEXT('\\');
        }
else if(ServerName[1]!=TEXT('\\'))
        {
        ServerName--;ServerName[0]=TEXT('\\');
        }
if (ComOK==0)
        ComOK=NetUserGetInfo(ServerName,UserName,3,Pointer);
if (ComOK==1)
        wprintf(L"Usage:\tHOMEDRV ServerName UserName [HomeDrive] [/p]\n    (/p forces password change at next logon)\n");
else if((ComOK==53)||(ComOK==123))
        wprintf(L"Computer %s not found.\n",ServerName);
else if(ComOK==2221)
        wprintf(L"Username %s not defined on %s.\n",UserName,ServerName);
else  if(ComOK!=0)
        wprintf(L"The command terminated abnormally with error code %i\n",ComOK);
else
        {
        InfoPointer=(USER_INFO_3 *) (*Pointer); 
        UserInfo=*InfoPointer;
        if (wcslen(HomeDrive)==0)
				{
                wprintf(L"Current home drive for %s on %s is %s\n",UserName,ServerName,UserInfo.usri3_home_dir_drive);
  				}
        if((wcslen(HomeDrive)>0)&&((wcslen(HomeDrive)>2)||(HomeDrive[1]!=TEXT(':'))||(! IsCharAlpha(HomeDrive[0]))))
                wprintf(L"Incorrectly specified drive letter.\n");
        else
                {
                ComOK=CharUpperBuff(HomeDrive,1);
				if (ResetPassword)
						UserInfo.usri3_password_expired=1;
				if (wcslen(HomeDrive)>0)
                		UserInfo.usri3_home_dir_drive=HomeDrive;
                ComOK=NetUserSetInfo(ServerName,UserName,3,(LPBYTE) (&UserInfo),NULL);
                if(ComOK==0)
						{
						if (wcslen(HomeDrive)>0)
                        		wprintf(L"Home drive for %s successfully changed to %s on %s\n",UserName,HomeDrive,ServerName);
						if (ResetPassword)
								wprintf(L"Account set so that %s must change password at next logon.\n",UserName);
						}
                else if(ComOK==2226)
                        wprintf(L"Operation can only be performed on the primary domain controller\n");
                else
                        wprintf(L"The command terminated abnormally with error code %i",ComOK);
                }
        }
return ComOK;
}
