#ifndef __TERM_P_H__
#define __TERM_P_H__

extern _VOID_ ring_bell _P_((void));
extern _VOID_ set_terminal_modes _P_((void));
extern _VOID_ reset_terminal_modes _P_((void));
extern _VOID_ set_terminal_window _P_((int size));
extern _VOID_ set_scroll_region _P_((int start, int stop));
extern _VOID_ turn_on_insert _P_((void));
extern _VOID_ turn_off_insert _P_((void));
extern _VOID_ turn_off_highlight _P_((void));
extern _VOID_ turn_on_highlight _P_((void));
extern _VOID_ background_highlight _P_((void));
extern _VOID_ write_standout_marker _P_((int flag, int vpos));
extern _VOID_ reassert_line_highlight _P_((int highlight, int vpos));
extern _VOID_ change_line_highlight _P_((int new_highlight, int vpos,
                                         int first_unused_hpos));
extern _VOID_ cursor_to _P_((int row, int col));
extern _VOID_ raw_cursor_to _P_((int row, int col));
extern _VOID_ clear_to_end _P_((void));
extern _VOID_ clear_frame _P_((void));
extern _VOID_ clear_end_of_line _P_((int first_unused_hpos));
extern _VOID_ clear_end_of_line_raw _P_((int first_unused_hpos));
extern _VOID_ write_glyphs _P_((register GLYPH *string,
                                register int len));
extern _VOID_ insert_glyphs _P_((register GLYPH *start,
                                 register int len));
extern _VOID_ delete_glyphs _P_((register int n));
extern _VOID_ ins_del_lines _P_((int vpos, int n));
extern int string_cost _P_((char *str));
extern int per_line_cost _P_((register char *str));
extern _VOID_ term_get_fkeys _P_((char **address));
extern _VOID_ _VARARGS_ fatal _P_((char *str, ...));
extern _VOID_ term_init _P_((char *terminal_type));

#endif
