#ifndef __INTERVALS_P_H__
#define __INTERVALS_P_H__

extern INTERVAL create_root_interval _P_((Lisp_Object parent));
extern _VOID_ copy_properties _P_((register INTERVAL source,
                                   register INTERVAL target));
extern int intervals_equal _P_((INTERVAL i0, INTERVAL i1));
extern _VOID_ traverse_intervals _P_((INTERVAL tree, int position, int depth,
                                      void (*function)(INTERVAL tree,
                                                       Lisp_Object arg),
                                      Lisp_Object arg));
extern _VOID_ check_for_interval _P_((register INTERVAL i));
extern INTERVAL search_for_interval _P_((register INTERVAL i,
                                         register INTERVAL tree));
extern int count_intervals _P_((register INTERVAL i));
extern INTERVAL split_interval_right _P_((INTERVAL interval, int offset));
extern INTERVAL split_interval_left _P_((INTERVAL interval, int offset));
extern INLINE INTERVAL find_interval _P_((register INTERVAL tree,
                                          register int position));
extern INTERVAL next_interval _P_((register INTERVAL interval));
extern INTERVAL previous_interval _P_((register INTERVAL interval));
extern _VOID_ delete_interval _P_((register INTERVAL i));
extern INLINE void offset_intervals _P_((struct buffer *buffer, int start,
                                         int length));
extern INTERVAL merge_interval_right _P_((register INTERVAL i));
extern INTERVAL merge_interval_left _P_((register INTERVAL i));
extern _VOID_ graft_intervals_into_buffer _P_((INTERVAL source, int position,
                                               struct buffer *buffer));
extern Lisp_Object textget _P_((Lisp_Object plist,
                                register Lisp_Object prop));
extern _VOID_ set_point _P_((register int position,
                             register struct buffer *buffer));
extern INLINE void temp_set_point _P_((int position,
                                       struct buffer *buffer));
extern Lisp_Object get_local_map _P_((register int position,
                                      register struct buffer *buffer));
extern _VOID_ verify_interval_modification _P_((struct buffer *buf,
                                                int start, int end));
extern INTERVAL balance_intervals _P_((register INTERVAL tree));
extern INTERVAL copy_intervals _P_((INTERVAL tree, int start, int length));
extern INLINE void copy_intervals_to_string _P_((Lisp_Object string,
                                                 Lisp_Object buffer,
                                                 int position, int length));

#endif
