!include <ntwin32.mak>

PROJ=deskfont

DEPEND=$(PROJ).obj

SYSDIR=\winnt\system32
LIBS=\msvcnt\lib\*.lib

CC=cl
LINK=link32
LIB=lib32

!ifdef NODEBUG
CCOPTS=-c -Ox -Gs3 -Zpe -D_X86_ -DWIN32 -D_DLL -nologo
LINKOPTS=-debug:none -subsystem:windows -base:0x1C000000 -dll \
-entry:DLLEntryPoint$(DLLENTRY)
!else
CCOPTS=-c -Od -Gs3 -Zpei -D_X86_ -DWIN32 -D_DLL -nologo
LINKOPTS=-debug:full -debugtype:cv -subsystem:windows -base:0x1C000000 -dll \
-entry:DLLEntryPoint$(DLLENTRY)
!endif

all: $(PROJ).cpl
   @echo.
	@echo nmake deskfont.mak NODEBUG=1 builds a non-debug version
	@echo nmake deskfont.mak builds a debug version
	@echo.

$(PROJ).res: $(PROJ).rc
   rc -r -fo $(PROJ).tmp $(PROJ).rc
   cvtres -i386 -o $(PROJ).res $(PROJ).tmp
   del $(PROJ).tmp

$(PROJ).obj: $(PROJ).c
	$(CC) $(CCOPTS) $(PROJ).c

$(PROJ).lib: $(DEPEND) $(PROJ).def
	$(LIB) -machine:i386 -def:$(PROJ).def $(DEPEND) -out:$(PROJ).lib

$(PROJ).cpl: $(PROJ).res $(DEPEND) $(PROJ).def $(PROJ).lib
	$(LINK) $(LINKOPTS) -out:$(PROJ).cpl $(DEPEND) $(PROJ).exp $(PROJ).res ctl3d32.lib $(LIBS)
	copy $(PROJ).cpl $(SYSDIR)
