set hamilton = `whereis csh.exe`:h:h
while (1)
cls
echo 'Welcome to the Hamilton C shell demo!'
echo
echo
echo 1 D% ^# First, go to the Hamilton C shell directory...
echo 2 D% cd +c $hamilton
cd +c $hamilton
sleep
echo
echo
echo 3 D% ^# List the contents of the directory.  Notice how subdirectories
echo 4 D% ^# are shown highlighted. The C shell makes extensive use of color
echo 5 D% ^# all colors are completely user-customizable.
echo 6 D% ls -l
ls -l
sleep 4
echo 
echo
echo 7 D% ^# Now list the bin directory, showing all the utilities. Notice
echo 8 D% ^# that all the usual favorites such as grep, fgrep, head, tail,
echo 9 D% ^# etc., are included.
echo 10 D% ls bin
ls bin
sleep 6
echo
echo
echo 11 D% ^# Hamilton C shell has aliases.  Here^'s an alias for the more
echo 12 D% ^# filter, starting it up in interactive mode ^(so it^'ll first
echo 13 D% ^# clear the screen and stay around even if it^'s less than a
echo 14 D% ^# screenful.^)
echo 15 D% alias mi
alias mi
sleep 4
echo
echo
echo 16 D% ^# Everything always has online help with the -h option.  Here
echo 17 D% ^# we^'ll pipe the help for grep into head, which will print just
echo 18 D% ^# the first 10 lines.
echo '19 D% grep -h | head'
grep -h | head
sleep 1
echo
echo
echo 20 D% ^# The C shell is a powerful scripting lanuguage. Here^'s an
echo 21 D% ^# example, factoring a large number.  Notice that we can time
echo 22 D% ^# any command to see how long it takes.
echo 23 D% time factor 1234123412
time factor 1234123412
sleep 6
echo
echo
echo 24 D% ^# factor is really a C shell script.  We can find it with the
echo 25 D% ^# whereis command ...
echo 26 D% whereis factor
whereis factor
sleep 6
echo
echo

set f = `whereis factor`
if ($#f > 1) then
echo 27 D% ^# Let^'s go browse factor.  Here we^'ll use the history facility
echo 28 D% ^# to pick up the text of the previous command ^(the whereis
echo 29 D% ^# factor^) by typing '!!'.  The backquotes around it are command
echo 30 D% ^# substitution, meaning run the command and paste the output
echo 31 D% ^# back on the command line as an argument to more, using the
echo 32 D% ^# :0 operator to pick off just the first occurrence we found.
echo 33 D% more ^`!!^`:0
echo 'more `whereis factor`:0'
more $f:0
else
echo 27 D% ^# Let^'s go browse factor.  Here we^'ll use the history facility
echo 28 D% ^# to pick up the text of the previous command ^(the whereis
echo 29 D% ^# factor^) by typing '!!'.  The backquotes around it are command
echo 30 D% ^# substitution, meaning run the command and paste the output
echo 31 D% ^# ^(the d:\hamilton\bin\factor.csh pathname^) back on the command
echo 32 D% ^# line as an argument to more...
echo 33 D% more ^`!!^`
echo 'more `whereis factor`'
more `whereis factor`
endif
echo 34 D% ^# Notice that Hamilton C shell has procedures, a genuine numeric
echo 35 D% ^# for loop, built-in functions like floor and sqrt and procedures
echo 36 D% ^# can even be recursive.  Not surprisingly, a lot of customers
echo 37 D% ^# are using Hamilton C shell with thousands of lines of scripts.
echo 38 D% ^# For example, Sybase uses it to run the build for SQL Server,
echo 39 D% ^# Microsoft^'s languages group uses it to run nightly regression
echo 40 D% ^# tests, etc.
sleep 15
echo
echo
@ S = char(driveno(SystemRoot) + code('A') - 1)
echo 41 D% ^# Finally, the C shell has a lot of creature comforts such as
echo 42 D% ^# filename and command completion, command line editing and
echo 43 D% ^# advanced wildcarding.  Here we^'ll search the entire $S^: disk
echo 44 D% ^# looking for all the DLL^'s whose names start with ^'d^' ...
echo 45 D% "time ls -L $S^:\...\d*.dll"
time ls -L $S^:\...\d*.dll
sleep 8
echo
echo
echo 46 D% ^# For folks coming from a UNIX background -- or anyone looking
echo 47 D% ^# simply for a more powerful scripting or development environment,
echo 48 D% ^# Hamilton C shell can be very attractive, offering instant
echo 49 D% ^# productivity gains.
sleep 15
end
