/*
//	$Id: YGREP.H 1.9 1995/11/23 06:36:35 Y.Roumazeilles Exp $
//
//	(C) 1992-93-94-95-96 Yves Roumazeilles
//
//      Version 4.06
*/

#ifndef	__YGREP_H__
#define	__YGREP_H__	
#ifdef __cplusplus
extern "C" {
#endif


#ifdef	WINVER
#define	YGCALL	FAR PASCAL
#else
#define	YGCALL	
#endif

WORD	YGCALL	YGrepVersion( void );
BOOL	YGCALL	YGrepIsDebug( void );


/* YGrep Search Engine Error Codes */
#define AGERR_UNKNOWN_TYPE		-1
#define AGERR_NO_ERROR			0
#define AGERR_STATE			1
#define AGERR_ALLOC_MEM			2
#define AGERR_TOO_SHORT			3
#define AGERR_TOO_LONG			4
#define AGERR_NO_PREVIOUS		5
#define AGERR_NO_PATTERN		6

#define RGERR_MUNGED_AUTO		20
#define RGERR_MISS_BRACKET		25
#define RGERR_EMPTY_ENCL		26
#define RGERR_ILLEGAL_ENCL		27
#define RGERR_TOO_MANY_PAR		28
#define RGERR_NULL_IN_PAR		29
#define RGERR_UNMATCHED			30
#define RGERR_NULL_IN_CRO		31
#define RGERR_CYCLICAL_REF		32
#define RGERR_UNDETERM_REF		33
#define RGERR_UNMATCHED_PAR		34

#define	MATCH		0
#define	MISMATCH	1
#define	EXACTMATCH	2
#define	MAXSYM		256	/* Size of the alphabet (in chars) */
#define	WORD_SIZE	512	/* (in bits) */
#define MAXTAG		10

#include	<bitlist.h>

typedef struct tagAGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	int	bMatchCase;
	BLIST	uMask;		/* internal structures */
	BLIST	uOvMask;
	BLIST	uLimit;
	BLIST	blState;	/* temporary AGrep() structures */
	BLIST	blOverflow;
	BLIST	blTemp;
	BLIST	uTable[MAXSYM];	/* characteristic vector table */
	int	iBitsPerState;
	int	iWordSize;	/* actual word size of BLIST's */
	int	iType;		/* MATCH or MISMATCH */
	char	cUPat[WORD_SIZE];
} AGREPINFO;
#ifdef	WINVER
typedef	AGREPINFO*	PAGREPINFO;
typedef	AGREPINFO FAR*	LPAGREPINFO;
#else
typedef	AGREPINFO*	PAGREPINFO;
typedef	AGREPINFO*	LPAGREPINFO;
#endif


int	YGCALL	CompileAGrep( LPCSTR GrepString, int k, BOOL bMatchCase, LPAGREPINFO pGI );
int	YGCALL	AGrep( LPCSTR StringToSearch, LPAGREPINFO pGI );
int	YGCALL	AGrepInit( LPAGREPINFO pGI );
int	YGCALL	AGrepEmpty( LPAGREPINFO pGI );
int	YGCALL	AGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPAGREPINFO pGI );
int	YGCALL	AGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPAGREPINFO pGI );
int	YGCALL	SCompileAGrep( LPCSTR GrepString, int k, BOOL bMatchCase );
int	YGCALL	SAGrep( LPCSTR StringToSearch );
int	YGCALL	SAGrepInit( void );
int	YGCALL	SAGrepEmpty( void );
int	YGCALL	SAGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, int iSize );
int	YGCALL	SAGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, int iSize );



#define	MAXDFA	2*WORD_SIZE

#define CHRBIT	8
#define BITBLK	MAXSYM/CHRBIT

typedef struct tagRGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	int	bMatchCase;
	int	iCircf;		/* internal structures */
	char	cDFA[MAXDFA];
} RGREPINFO;
#ifdef	WINVER
typedef	RGREPINFO*	PRGREPINFO;
typedef	RGREPINFO FAR*	LPRGREPINFO;
#else
typedef	RGREPINFO*	PRGREPINFO;
typedef	RGREPINFO*	LPRGREPINFO;
#endif

int	YGCALL	CompileRGrep( LPCSTR GrepString, BOOL bMatchCase, LPRGREPINFO pGI );
int	YGCALL	RGrep( LPCSTR StringToSearch, LPRGREPINFO pGI );
int	YGCALL	RGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPRGREPINFO pGI );
int	YGCALL	RGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPRGREPINFO pGI );
void	YGCALL	InitWordCharTable( void );
void	YGCALL	AddWordChar( LPSTR s );
void	YGCALL	RemoveWordChar( LPSTR s );
int	YGCALL	SCompileRGrep( LPCSTR GrepString, BOOL bMatchCase );
int	YGCALL	SRGrep( LPCSTR StringToSearch );
int	YGCALL	SRGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, int iSize );
int	YGCALL	SRGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, int iSize );



typedef	struct tagYGrepInfo {
	union {
		AGREPINFO	aGI;
		RGREPINFO	rGI;
	} y;
	int	iTypeofINFO;	/* 0: empty, 1:AGREP, 2:RGREP */
} YGREPINFO;


#ifdef __cplusplus
} /* extern "C" */
#endif
#endif	/* __YGREP_H__ */
