// cntritem.h : interface of the CVogonCntrItem class
//
#include "Webster.h"

class CVogonDoc;
class CVogonView;

class CVogonCntrItem : public COleClientItem
{
   DECLARE_SERIAL(CVogonCntrItem)

// Constructors
public:
   CVogonCntrItem(CVogonDoc* pContainer = NULL);
      // Note: pContainer is allowed to be NULL to enable IMPLEMENT_SERIALIZE.
      //  IMPLEMENT_SERIALIZE requires the class have a constructor with
      //  zero arguments.  Normally, OLE items are constructed with a
      //  non-NULL document pointer.

// Attributes
public:
   CVogonDoc* GetDocument()
      { return (CVogonDoc*)COleClientItem::GetDocument(); }
   CVogonView* GetActiveView()
      { return (CVogonView*)COleClientItem::GetActiveView(); }

   _DWebster       m_dWebster;

/////////////// CONTAINR code starts here
// Attributes
public:  
   // Event Information
   DISPPARAMS m_LastParams;              
   DISPID     m_EventID;   

   DISPPARAMS FAR* GetParams()   {return &m_LastParams;};

protected:                          
   // Attributes for the event connection and information
   LPCONNECTIONPOINT m_pConnPt;
   DWORD             m_dwEventConnection;
   USHORT            m_nEvents;
   EVENTINFO*        m_pEventInfo;

public:
   // Attributes for the OLE event interface
   virtual LPUNKNOWN GetInterfaceHook(const void FAR* iid);
   LPUNKNOWN         GetCtlInterface(IID iidRequested);
	
protected:	
   IID m_iidEvents;

/////////////// CONTAINR code ends here

// Operations
public:
	// Handler routines for Events and Property Notifications
	// At some point, this could be replaced by maps, but not here.
	virtual void 	OnEvent(DISPID dispID, DISPPARAMS FAR* pDispParams);

	void			CleanUpParams();
	void			CopyParams(DISPPARAMS FAR* lpDispparams);
	
// Overrides
protected:
    virtual 		BOOL FinishCreate(HRESULT hr);
    virtual 		void Release(OLECLOSE dwCloseOption = OLECLOSE_NOSAVE);

// Implementation
public:
   ~CVogonCntrItem();
#ifdef _DEBUG
   virtual void AssertValid() const;
   virtual void Dump(CDumpContext& dc) const;
#endif
   virtual void Serialize(CArchive& ar);
   virtual void OnGetItemPosition(CRect& rPosition);
   virtual void OnDeactivateUI(BOOL bUndoable);

protected:
   virtual void       OnChange(OLE_NOTIFICATION wNotification, DWORD dwParam);
   virtual BOOL       OnChangeItemPosition(const CRect& rectPos);
   virtual void       OnActivate();
   virtual void       OnDeactivate();
   virtual LPDISPATCH GetIDispatch();

/////////////// CONTAINR code starts here
      // Control Initialization Routines
      void 		InitControlInfo();
      void 		InitEventInfo(LPTYPEINFO);

      // Control Maintenance Routines
      void 		FreeControlInfo();
      EVENTINFO* 	GetEventInfo(MEMBERID memid);


// Implemented Interfaces
protected:

	// Interface for Event Handling
    BEGIN_INTERFACE_PART(EventHandler, IDispatch)
        STDMETHOD(GetTypeInfoCount)(unsigned int FAR*);
        STDMETHOD(GetTypeInfo)(unsigned int, LCID, ITypeInfo FAR* FAR*);
        STDMETHOD(GetIDsOfNames)(REFIID, LPTSTR FAR*, unsigned int, LCID, DISPID FAR*);
        STDMETHOD(Invoke)(DISPID, REFIID, LCID, unsigned short, DISPPARAMS FAR*,
                          VARIANT FAR*, EXCEPINFO FAR*, unsigned int FAR*);
    END_INTERFACE_PART(EventHandler)

	DECLARE_INTERFACE_MAP()
/////////////// CONTAINR code ends here
};

/////////////////////////////////////////////////////////////////////////////
