VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "CompressIT/VBX"
   ClientHeight    =   4560
   ClientLeft      =   1140
   ClientTop       =   1425
   ClientWidth     =   6255
   Height          =   4965
   Left            =   1080
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4560
   ScaleWidth      =   6255
   Top             =   1080
   Width           =   6375
   Begin CMPRSVBX comprsit1 
      EncryptionKey   =   ""
      Left            =   5520
      Top             =   1680
   End
   Begin OptionButton Option1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "High Compression (slower)"
      Height          =   375
      Index           =   2
      Left            =   2760
      TabIndex        =   9
      Top             =   2280
      Width           =   3255
   End
   Begin OptionButton Option1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Medium Compression"
      Height          =   375
      Index           =   1
      Left            =   2760
      TabIndex        =   8
      Top             =   1920
      Width           =   3255
   End
   Begin OptionButton Option1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Low Compression (faster)"
      Height          =   375
      Index           =   0
      Left            =   2760
      TabIndex        =   7
      Top             =   1560
      Width           =   3255
   End
   Begin CommandButton cmd_start 
      Caption         =   "Start!"
      Height          =   615
      Left            =   240
      TabIndex        =   4
      Top             =   1800
      Width           =   1695
   End
   Begin TextBox Text2 
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   1200
      Width           =   1935
   End
   Begin TextBox Text1 
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   360
      Width           =   1935
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Optimized for (Source Data Type)"
      Height          =   1215
      Left            =   2640
      TabIndex        =   10
      Top             =   120
      Width           =   3375
      Begin OptionButton dattype 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Random Data (binary)"
         Height          =   255
         Index           =   0
         Left            =   360
         TabIndex        =   12
         Top             =   360
         Width           =   2415
      End
      Begin OptionButton dattype 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Character Data (text)"
         Height          =   255
         Index           =   1
         Left            =   360
         TabIndex        =   11
         Top             =   720
         Width           =   2415
      End
   End
   Begin Label Label9 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Output Compressed Data:"
      Height          =   195
      Left            =   2640
      TabIndex        =   19
      Top             =   3120
      Width           =   2190
   End
   Begin Label lbl_compressed 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   195
      Left            =   5040
      TabIndex        =   18
      Top             =   3120
      Width           =   1095
   End
   Begin Label Label7 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Data sent for Compression:"
      Height          =   195
      Left            =   2640
      TabIndex        =   17
      Top             =   2880
      Width           =   2310
   End
   Begin Label lbl_sent 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   195
      Left            =   5040
      TabIndex        =   16
      Top             =   2880
      Width           =   1095
   End
   Begin Label lbl_ratio 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   195
      Left            =   1920
      TabIndex        =   15
      Top             =   3120
      Width           =   375
   End
   Begin Label Label6 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Compression Ratio:"
      Height          =   195
      Left            =   120
      TabIndex        =   14
      Top             =   3120
      Width           =   1650
   End
   Begin Label Label5 
      BackColor       =   &H00C0C0C0&
      Caption         =   "With CompressIT/VBX/OCX you have total control and no File I/O is required.  This application is a programming example that creates a compressed output file from a source file data.  Look at all the CompressIT events where all the Event Driven Compression occurs."
      Height          =   855
      Left            =   120
      TabIndex        =   13
      Top             =   3600
      Width           =   6015
   End
   Begin Label lbl_percent 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   195
      Left            =   1920
      TabIndex        =   6
      Top             =   2880
      Width           =   375
   End
   Begin Label Label3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Percent Completion:"
      Height          =   195
      Left            =   120
      TabIndex        =   5
      Top             =   2880
      Width           =   1725
   End
   Begin Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Output File Name:"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   960
      Width           =   1935
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Source File Name:"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   1935
   End
End
' This is a sample demo Visual Basic 3.0 application showing how the CompressIT/VBX can be used
' You can modify this application at your will.
' Sylvain Faust Inc. (SFI)
' Technical support: 819 778-5045  Fax: 819 778-7943  BBS: 819 778-8556
Option Explicit
DefInt A-Z
Const ProgName$ = "CompressIT/VBX Compression Example"
Dim zip_new%
Dim TotalLength&, LengthRemain&, TotalRead&, TotalWritten&
Dim cratio%, dtype%

Sub cmd_start_Click ()
    COMPRSIT1.DataType = dtype%
    COMPRSIT1.CompressionRatio = cratio%

    Open text1.Text For Binary Access Read As #1
    Open text2.Text For Binary Access Write As #2
    TotalLength& = LOF(1)
    If TotalLength& = 0 Then
	MsgBox "Input file " & text1.Text & " is empty!", 48, ProgName$
	Close #1
	Close #2
	Exit Sub
    End If
    LengthRemain& = TotalLength&
    Screen.MousePointer = 11

    TotalRead& = 0
    TotalWritten& = 0
    ' Tell CompressIT to Start Compressiong Events!!!
    COMPRSIT1.Action = 0

    Close #1
    Close #2

    Screen.MousePointer = 0
    If COMPRSIT1.Status <> 0 Then MsgBox "Error in Compression/Decompression:" + Str$(COMPRSIT1.Status), 48, "CompressIT! Demo"
End Sub

Sub COMPRSIT1_CompressRead (CompressBuffer As String, CompressBufferBytes As Integer)
    ' This event is generated by CompressIT so you can start feeding the Compression Engine.
    ' CompressIT will request data for compression until you return 0 in the CompressBufferBytes
    ' parameter.
    ' As soon as compressed data is available, CompressIT will generate "CompressWrite" events.
    '
    ' In this example, we read data from a source file for compression.  In reality, the source
    ' data can be taken from a Modem communication, or from a database, or else, at your will.
    Dim x%, Buffer$
    If Not EOF(1) Then
	If LengthRemain& > CompressBufferBytes Then
	    x% = CompressBufferBytes
	Else
	    x% = LengthRemain&
	End If
	Buffer$ = Space$(x%)
	Get #1, , Buffer$
	CompressBuffer = Buffer$
	CompressBufferBytes = x%
	LengthRemain& = LengthRemain& - x%
	' Update the number of bytes read on Window
	TotalRead& = TotalRead& + x%
	Lbl_Sent.Caption = Str$(TotalRead&)
	Lbl_Sent.Refresh
    End If
End Sub

Sub COMPRSIT1_CompressWrite (CompressBuffer As String)
    ' This event is generated when CompressIT has compressed data ready for you.
    ' This event will be generated as many time as necessary so you get all the available
    ' compressed data "on the fly" asynchronously with the "CompressRead" event.
    ' In this example we write to a file the compressed data as soon as it is available.
    ' In reality, you can keep it in memory, send it to a Modem or save it to a database, or anything
    ' else you want, at your will.
    Dim DoneInPercent%
    ' Put available compressed data to disk (or elsewhere)
    Put #2, , CompressBuffer
    ' Compute % Completion
    DoneInPercent% = ((TotalLength& - LengthRemain&) / TotalLength&) * 100
    lbl_Percent.Caption = Str$(DoneInPercent%)
    lbl_Percent.Refresh
    ' Update Compressed bytes on Window
    TotalWritten& = TotalWritten& + Len(CompressBuffer)
    lbl_Compressed.Caption = Str$(TotalWritten&)
    lbl_Compressed.Refresh
    ' Compute Compression ratio so far
    lbl_Ratio.Caption = Str$(Int(((TotalRead& - TotalWritten&) / TotalRead&) * 100))
    lbl_Ratio.Refresh
End Sub

Sub dattype_Click (index As Integer)
    dtype% = index
End Sub

Sub Form_Load ()
    ' Center Form
    Move (Screen.Width - Form1.Width) \ 2, (Screen.Height - Form1.Height) \ 3
    Form1.Caption = ProgName$
    ' Set Default values
    option1(1).Value = True
    dattype(0).Value = True
End Sub

Sub Option1_Click (index As Integer)
    cratio% = index + 1
End Sub

