/*****************************************************************************\
*                                                                             *
* wingnuc.h  -  Macros for GNU C Compiler to include non-ansi <windows.h>     *
*                                                                             *
*            -  Define RETURN_WINAPI for patching _stdcall in text by ntbind  *
*                                                                             *
*                                                                             *
*               Copyright (c) 1995  Rainer Schnitker.  All rights reserved.   *
*                                                                             *
\*****************************************************************************/

#ifndef _WINGNUC_H
#define _WINGNUC_H

#ifdef __GNUC__

#ifndef _WCHAR_T
#define _WCHAR_T
#define _WCHAR_T_DEFINED
typedef unsigned short wchar_t;
#endif

#define __cdecl
#define __pascal
#define __stdcall

#define _CFRONT_PASS_       /* don't get errors */
#define MIDL_PASS
/* #define __midl */
#define _X86_
#define I386_HOST	1
#ifndef _M_IX86
#define _M_IX86		300
#endif

/* define missing structured exception handlers */
struct _EXCEPTION_RECORD;
struct _CONTEXT;
struct _RTL_CRITICAL_SECTION;
struct tagCREATESTRUCTA;
struct tagCREATESTRUCTW;

/* define WINAPI return command */
#define RETURN_WINAPI(PAR) \
    __asm__ ("1:nop\n\tnop\n\t.stabs \"__RetNT\",36," #PAR ",0,1b-2\n");
#define RETURN_CALLBACK(PAR) \
    __asm__ ("1:nop\n\tnop\n\t.stabs \"__RetNT\",36," #PAR ",0,1b-2\n");
#define RETURN_EXPORT(PAR) \
    __asm__ ("1:nop\n\tnop\n\t.stabs \"__RetNT\",36," #PAR ",0,1b-2\n");

#else  /* not __GNUC__ */

#define RETURN_WINAPI(PAR)
#define RETURN_CALLBACK(PAR)
#define RETURN_EXPORT(PAR)

#endif /* __GNUC__ */

#endif /* _WINGNUC_H */
