//@doc		VIEWX
//@module	VIEWX.H - Auxiliary view declarations |
//	
//	This file contains the declaration of the auxiliary view classes.
//	
//@devnote	1.0 beta
//@normal	Copyright <cp> 1996 Meta Four Software. All rights reserved.

#ifndef __K4VIEW_H__
	#error This file is included by "k4view.h", it cannot be used standalone
#endif

/////////////////////////////////////////////////////////////////////////////
// Declarations in this file

	class c4_Sequence;                  // a collection of rows

	class c4_Reference;                 // refers to the actual data values
		class c4_IntRef;
		class c4_FloatRef;
		class c4_StringRef;
		class c4_ViewRef;

	class c4_Bytes;						// not defined here
	class c4_Handler;					// not defined here

/////////////////////////////////////////////////////////////////////////////
//@class A sequence is the base class for views on ranges of records.

class d4_export c4_Sequence
{
public: //@access Public members
	c4_Sequence ();
	
	virtual int Compare(int, c4_Cursor);
	virtual void SetAt(int, c4_Cursor);
	
	c4_String Describe() const;

	void IncRef();
	void DecRef();
	int NumRefs() const;

	virtual int Size() const = 0;
	virtual void Resize(int, int =-1);
	
	virtual void InsertAt(int, c4_Cursor, int =1);
	virtual void RemoveAt(int, int =1);
	
	int NthProperty(int) const;
	int PropIndex(int, bool =false);
	
	virtual int NumHandlers() const = 0;
	virtual c4_Handler& NthHandler(int) const = 0;
	virtual int AddHandler(c4_Property&, c4_Handler*) = 0;

	virtual bool Get(int, int, c4_Bytes&);
	virtual void Set(int, int, const c4_Bytes&);
	
protected:
	virtual ~c4_Sequence ();

public: //! for c4_Table::Sequence setup
	virtual void SetSize(int size_) = 0;

private:
	c4_Sequence (const c4_Sequence&);   // not implemented
	void operator= (const c4_Sequence&); // not implemented
	
	int _refCount;
};

/////////////////////////////////////////////////////////////////////////////
//@class A reference is used to get or set typed data, using derived classes.
//@xref <c c4_IntRef>, <c c4_FloatRef>, <c c4_StringRef>, <c c4_ViewRef>

class d4_export c4_Reference
{
public: //@access Public members
	c4_Reference (c4_RowRef, int);

	c4_Reference& operator= (const c4_Reference&);

	bool GetData(c4_Bytes&) const;
	void SetData(const c4_Bytes&) const;
	
private:
	void operator& () const;			// not implemented
	
	c4_Cursor _cursor;
	int _propId;
};

/////////////////////////////////////////////////////////////////////////////

	//@class Used to get or set integer values.
	//@base public | <c c4_Reference>
class d4_export c4_IntRef : public c4_Reference
{
public: //@access Public members
	//@cmember Constructor.
	c4_IntRef (const c4_Reference&);
	operator long () const;
	c4_IntRef& operator= (long);
};

	//@class Used to get or set floating point values.
	//@base public | <c c4_Reference>
class d4_export c4_FloatRef : public c4_Reference
{
public: //@access Public members
	//@cmember Constructor.
	c4_FloatRef (const c4_Reference&);
	operator double () const;
	c4_FloatRef& operator= (double);
};

	//@class Used to get or set string values.
	//@base public | <c c4_Reference>
class d4_export c4_StringRef : public c4_Reference
{
public: //@access Public members
	//@cmember Constructor.
	c4_StringRef (const c4_Reference&);
	operator c4_String () const;
	c4_StringRef& operator= (const char*);
};

	//@class Used to get or set view values.
	//@base public | <c c4_Reference>
class d4_export c4_ViewRef : public c4_Reference
{
public: //@access Public members
	//@cmember Constructor.
	c4_ViewRef (const c4_Reference&);
	operator c4_View () const;
	c4_ViewRef& operator= (const c4_View&);
};

/////////////////////////////////////////////////////////////////////////////
