//@doc		TABLE
//@module	TABLE.INL - Table inline declarations |
//	
//	This file contains inline definitions for the table classes.
//		
//	Only very small members are selected for inline code.
//	See the class listing for a description of these functions.
//	
//@devnote	1.0 beta
//@normal	Copyright <cp> 1996 Meta Four Software. All rights reserved.

/////////////////////////////////////////////////////////////////////////////
// c4_Bytes

d4_inline c4_Bytes::c4_Bytes ()
	: _contents (0), _size (0), _copy (false)
{
	d4_assertThis;
}

d4_inline c4_Bytes::~c4_Bytes ()
{
	d4_assertThis;
	
	_LoseCopy();
}
	
d4_inline const uchar* c4_Bytes::Contents() const
{
	d4_assertThis;
    
	return _contents;
}

d4_inline int c4_Bytes::Size() const
{
	d4_assertThis;
    
	return _size;
}

d4_inline void c4_Bytes::_LoseCopy()
{
	d4_assertThis;
	
	if (_copy)
	{
		d4_assert(_size > 0);
		
		delete [] (char*) _contents;
	}
}

/////////////////////////////////////////////////////////////////////////////
// c4_Column

d4_inline uchar* c4_Column::Contents() const
{
	d4_assertThis;
	d4_assert(_pointer || !_size);

	return _pointer;
}
    
d4_inline ulong c4_Column::Size() const
{
	d4_assertThis;

	return _size;
}

d4_inline void c4_Column::SetDirty()
{
	d4_assertThis;

	_position = 1;
}

d4_inline bool c4_Column::IsDirty() const
{
	d4_assertThis;

	return _position <= 1;
}

/////////////////////////////////////////////////////////////////////////////
// c4_Table
	
d4_inline c4_Persist* c4_Table::Persist() const
{
	d4_assertThis;

	return _persist;
}

d4_inline c4_Field& c4_Table::Definition() const
{
	d4_assertThis;
	d4_assert(_field);

	return *_field;
}

d4_inline c4_Table& c4_Table::Owner() const
{
	d4_assertThis;
	d4_assert(_owner);

	return *_owner;
}

d4_inline int c4_Table::OwnerRow() const
{
	d4_assertThis;

	return _ownerRow;
}

d4_inline void c4_Table::SetOwnerRow(int row_)
{
	d4_assertThis;

	_ownerRow = row_;
}

d4_inline c4_Column& c4_Table::Column(int index_) const
{
	d4_assertThis;
	d4_assert(_columns[index_]);

	return *(c4_Column*) _columns[index_];
}

d4_inline int c4_Table::NumColumns() const
{
	d4_assertThis;
	
	return _columns.GetSize();
}

d4_inline c4_HandlerSeq& c4_Table::Sequence()
{
	d4_assertThis;
	d4_assert(_sequence);

	return *_sequence;
}

d4_inline uchar* c4_Table::LoadColumn(int index_) const
{
	d4_assertThis;
	d4_assert(_persist);

	return Column(index_).LoadNow(*_persist); 
}

/////////////////////////////////////////////////////////////////////////////
