//@doc		FIELD
//@module	FIELD.INL - Field inline declarations |
//	
//	This file contains inline definitions for the field classes.
//		
//	Only very small members are selected for inline code.
//	See the class listing for a description of these functions.
//	
//@devnote	1.0 beta
//@normal	Copyright <cp> 1996 Meta Four Software. All rights reserved.

/////////////////////////////////////////////////////////////////////////////
// c4_Field

d4_inline bool c4_Field::IsRoot() const
{
	d4_assertThis;

	return _parent == this;
}

d4_inline c4_Field& c4_Field::Parent() const
{
	d4_assertThis;
	d4_assert(_parent);

	return *_parent;
}

d4_inline int c4_Field::Index() const
{
	d4_assertThis;

	return _index;
}

d4_inline bool c4_Field::IsRepeating() const
{
	d4_assertThis;

	return _repeating;
}

d4_inline int c4_Field::NumSubFields() const
{
	d4_assertThis;

	return _subFields.GetSize();
}

d4_inline c4_Field& c4_Field::SubField(int index_) const
{
	d4_assertThis;

	return *(c4_Field*) _subFields[index_];
}

d4_inline int c4_Field::NumSubColumns() const
{
	d4_assertThis;

	return _subColumns.GetSize();
}

d4_inline c4_Field& c4_Field::SubColumn(int index_) const
{
	d4_assertThis;

	return *(c4_Field*) _subColumns[index_];
}

d4_inline c4_String c4_Field::Name(bool full_) const
{
	d4_assertThis;
	
	return full_ ? _name : _name.Left(_nameLen);
}
	
d4_inline c4_String c4_Field::Type() const
{
	d4_assertThis;
	
	return _name.Mid(_nameLen + 1, 255);
}
	
d4_inline int c4_Field::Offset() const
{
	d4_assertThis;

	return _offset;
}

d4_inline int c4_Field::Width() const
{
	d4_assertThis;

	return _width;
}

d4_inline int c4_Field::Depth() const
{
	d4_assertThis;

	return _depth;
}

/////////////////////////////////////////////////////////////////////////////
