//	discat.cpp  -  disk catalog sample code  -  1.0
//
//	This is a part of the MetaKit library.
//	Copyright (c) 1996 Meta Four Software.
//	All rights reserved.
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "discat.h"
#include "catalog.h"

CMyApp ThisApp;		// the global application object

/////////////////////////////////////////////////////////////////////////////
// CMyApp

BOOL CMyApp::InitInstance()
{
	CMainDlgWindow mainDlg;
	m_pMainWnd = &mainDlg;
	mainDlg.DoModal();

	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainDlgWindow

BEGIN_MESSAGE_MAP(CMainDlgWindow, CDialog)
	//{{AFX_MSG_MAP(CMainDlgWindow)
	ON_BN_CLICKED(IDC_SCAN_BTN, OnScanBtn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////

CMainDlgWindow::CMainDlgWindow()
	: CDialog (CMainDlgWindow::IDD)
{
	//{{AFX_DATA_INIT(CMainDlgWindow)
	//}}AFX_DATA_INIT
}

void CMainDlgWindow::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDlgWindow)
	DDX_Control(pDX, IDC_PATH, m_path);
	DDX_Control(pDX, IDC_STATUS, m_status);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// [JCW]  This code added for MetaKit DISCAT

BOOL CMainDlgWindow::OnInitDialog() 
{
	CDialog::OnInitDialog();

		// use the application directory as the default scan path
	CString appDir = ThisApp.m_pszHelpFilePath;
	int n = appDir.ReverseFind('\\');
	if (n >= 0)
		m_path.SetWindowText(appDir.Left(n));
	
	return TRUE;  // return TRUE unless you set the focus to a control
}

void CMainDlgWindow::OnScanBtn() 
{
		// find out which directory we should scan
	CString path;
	m_path.GetWindowText(path);
	if (path.Right(1) == '\\')
		path = path.Left(path.GetLength() - 1);

		// indicate what is going on
	m_status.SetWindowText("Scanning, please wait...");

		// scan the directory tree, see CATALOG.CPP
	c4_Row tree = fScanDirectories(path);
	c4_View dirs = pDirs(tree);
	
		// show what happened
	char buf [30];
	wsprintf(buf, "%d directories were scanned.", dirs.GetSize());
	m_status.SetWindowText(buf);
	
		// save results to file
	CFileDialog dlg (FALSE, NULL, "dirs");
	if (dlg.DoModal() == IDOK)
	{
#if 1
		#define dFormat "dirs[parent:I,name:S,files[name:S,size:I,date:I]]"
		c4_Storage storage (dlg.GetPathName(), dFormat);
#else
		c4_Storage storage (dlg.GetPathName());
#endif
		storage.Set("dirs", dirs);
		storage.Commit();
	}
}  

/////////////////////////////////////////////////////////////////////////////
