//	catalog.h  -  recursive directory scanner sample code  -  1.0
//
//	This is a part of the MetaKit library.
//	Copyright (c) 1996 Meta Four Software.
//	All rights reserved.
/////////////////////////////////////////////////////////////////////////////

	// The following properties are used in this code
extern c4_ViewProp		pDirs, pFiles;
extern c4_IntProp		pParent, pSize, pDate;
extern c4_StringProp	pFormat, pName;

	// format & version identifier of object returned by fScanDirectories
#define dCatalogFormat	"DISCAT 1.0"

	// Scan a directory tree and return a corresponding structure for it.
	// The data structure of the object returned by this routine is:
	//		format:s, dirs [parent:i, name:s, files [name:s, size:i, date:i]]
extern c4_Row			fScanDirectories(const char* path_);

	// Reconstruct the full path name from a subdirectory index in the tree
extern CString			fFullPath(c4_Row& tree_, int dirNum_);

/////////////////////////////////////////////////////////////////////////////

