  
' Doubling with interpolation
 
' Input:	1-4-8-24 bit
' Output:	idem

' Author:	Andrea Benoni			 rev:	1.2


string    	inpFile,outFile
DevCon	Ibmp,Obmp,Dbmp
RGB	pix,pixs,pixt,pixq
float  	x,y

inpFile="Testi.bmp"
outFile="Testo.bmp"

Ibmp=LoadImage(inpFile)
Obmp=CreateImage(Ibmp.Width*2,Ibmp.Height*2,Ibmp.BitCount)
Dbmp=CreateImage(Ibmp.Width*2,Ibmp.Height*2,Ibmp.BitCount)

if((Ibmp.BitCount=8)	|(Ibmp.BitCount=4))
   For y=0  to 255
      pix=GetPalette(Ibmp,y)
      SetPalette(Obmp,y,pix)
      SetPalette(Dbmp,y,pix)
   next y
endif

For y=0 to Ibmp.Height-1
   For x=0 to Ibmp.Width-1
      pix=GetPixel(Ibmp,x,y)
      pixs=GetPixel(Ibmp,x+1,y)
      pixt=GetPixel(Ibmp,x,y+1)
      pixq=GetPixel(Ibmp,x+1,y+1)

      pixs.red=pixs.red+pix.red/2
      pixt.red=pixt.red+pix.red/2
      pixq.red=pixq.red+pix.red/2

      pixs.green=pixs.green+pix.green/2
      pixt.green=pixt.green+pix.green/2
      pixq.green=pixq.green+pix.green/2

      pixs.blue=pixs.blue+pix.blue/2
      pixt.blue=pixt.blue+pix.blue/2
      pixq.blue=pixq.blue+pix.blue/2

      SetPixel(Obmp,x*2,y*2,pix)
      SetPixel(Obmp,x*2+1,y*2,pixs)
      SetPixel(Obmp,x*2,y*2+1,pixt)
      SetPixel(Obmp,x*2+1,y*2+1,pixq)

      'Clear this for better performance
      SetPixel(Dbmp,x*2,y*2,pix)
      SetPixel(Dbmp,x*2+1,y*2,pix)
      SetPixel(Dbmp,x*2,y*2+1,pix)
      SetPixel(Dbmp,x*2+1,y*2+1,pix)

   Next x
   if ( y%16=0)
      Preview(Obmp,"Output",5,5,Obmp.Width+10,Obmp.Height+30)	
      'Clear this for better performance
      Preview(Dbmp,"Output",400,5,Obmp.Width+10,Obmp.Height+30)	
   endif
   DspWhile("Convert",100/ Ibmp.Height*y)
Next y

SaveImage(Obmp,outFile)
DspWhile("",0)
DspMes("End")