  
' Catode
' Use cosin function to modify input image simulating a flag,
' using also y differential to modify brightness.

' Input:	4-8-24 bit
' Output:	8 bit

' Author:	Andrea Benoni			 rev:	1.0


string	inpFile,outFile
DevCon	Ibmp,Obmp
RGB	pix
float  	x,y

inpFile="testi.bmp"
outFile="testo.bmp"

Ibmp=LoadImage(inpFile)
Obmp=CreateImage(Ibmp.Width*2,Ibmp.Height*2,8) 

For y=0 to 63
   pix.Lum=y*4
   SetPalette(Obmp,y,pix)
   pix.Lum=0
   pix.Red=y*4
   SetPalette(Obmp,64+y,pix)
   pix.Lum=0
   pix.Green=y*4
   SetPalette(Obmp,128+y,pix)
   pix.Lum=0
   pix.Blue=y*4
   SetPalette(Obmp,192+y,pix)
Next y

For y=0 to Ibmp.Height-1
   For x=0 to Ibmp.Width-1
      pix=GetPixel(Ibmp,x,y)			' get input image pixel
      SetPixelVal(Obmp,x*2+1,y*2+1,pix.Lum/4)	' put lum pixel
      SetPixelVal(Obmp,x*2+1,y*2,pix.Red/4+64)	' put red pixel
      SetPixelVal(Obmp,x*2,y*2,pix.Green/4+128)	' put green pixel
      SetPixelVal(Obmp,x*2,y*2+1,pix.Blue/4+192)	' put blue pixel
   Next x
   if(y%10=0)
      Preview(Obmp,"Output",0,0)
      DspWhile("Filtering",100/Ibmp.Height*y)
   endif
Next y
DspWhile("",0)
SaveImage(Obmp,outFile)
DspMes("End")