// vogondoc.cpp : implementation of the CVogonDoc class
//

#include "stdafx.h"
#include "vogon.h"

#include "CntrInfo.h"
#include "CntrItem.h"
#include "Filter.h"
#include "Slides.h"
#include "vogondoc.h"
#include "vogonvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVogonDoc

IMPLEMENT_DYNCREATE(CVogonDoc, COleDocument)

BEGIN_MESSAGE_MAP(CVogonDoc, COleDocument)
   //{{AFX_MSG_MAP(CVogonDoc)
	ON_COMMAND(ID_VIEW_SLIDESHOW_SETUP, OnSlideShowSetup)
	ON_COMMAND(ID_VIEW_URLFILTER, OnUrlFilter)
	ON_UPDATE_COMMAND_UI(ID_VIEW_URLFILTER, OnUpdateUrlFilter)
	//}}AFX_MSG_MAP
   // Enable default OLE container implementation
   ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, COleDocument::OnUpdatePasteMenu)
   ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_LINK, COleDocument::OnUpdatePasteLinkMenu)
   ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, COleDocument::OnUpdateEditLinksMenu)
   ON_COMMAND(ID_OLE_EDIT_LINKS, COleDocument::OnEditLinks)
   ON_UPDATE_COMMAND_UI(ID_OLE_VERB_FIRST, COleDocument::OnUpdateObjectVerbMenu)
   ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_CONVERT, COleDocument::OnUpdateObjectVerbMenu)
   ON_COMMAND(ID_OLE_EDIT_CONVERT, COleDocument::OnEditConvert)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVogonDoc construction/destruction

CVogonDoc::CVogonDoc()
{
   // For most containers, using compound files is a good idea.
   EnableCompoundFile();
   // Default to 120-sec interval for the slide show, with loop
   m_uintInterval = 120;
   m_doLoop       = TRUE;
   // Start out unfiltered
   m_filterURL    = FALSE;
   // TODO: add one-time construction code here
}

CVogonDoc::~CVogonDoc()
{
}

BOOL CVogonDoc::OnNewDocument()
{
   if (!COleDocument::OnNewDocument())
      return FALSE;

   // TODO: add reinitialization code here
   // (SDI documents will reuse this document)

   return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CVogonDoc serialization

void CVogonDoc::Serialize(CArchive& ar)
{
   if (ar.IsStoring())
   {  // Store slide-show items
      ar << m_uintInterval << m_doLoop;
      m_stringSlides.Serialize(ar);
   }
   else
   {  // Load slide-show items
      ar >> m_uintInterval >> m_doLoop;
      m_stringSlides.Serialize(ar);
   }

   // Calling the base class COleDocument enables serialization
   //  of the container document's COleClientItem objects.
   COleDocument::Serialize(ar);
}


/////////////////////////////////////////////////////////////////////////////
// CVogonDoc diagnostics

#ifdef _DEBUG
void CVogonDoc::AssertValid() const
{
   COleDocument::AssertValid();
}

void CVogonDoc::Dump(CDumpContext& dc) const
{
   COleDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVogonDoc commands
BOOL CVogonDoc::SaveModified() 
{  // We modify too many things, avoid irritating the user.
   return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnSlideShowSetup() 
{  // Show the dialog box
   CSlideShowDlg dlgSlideShow;
   // Initialize: interval, loop flag and slide array pointer
   dlgSlideShow.m_uintInterval = m_uintInterval;
   dlgSlideShow.m_doLoop       = m_doLoop;
   dlgSlideShow.m_pSlideList   = &m_stringSlides;
   // Show the current URL in the edit box
   POSITION pos = GetStartPosition();
   CVogonCntrItem* pItem = (CVogonCntrItem*) GetNextClientItem(pos);
   dlgSlideShow.m_stringSlideName = pItem->m_dWebster.GetPageURL();
   // Show it
   if (dlgSlideShow.DoModal())
   {  // User selected OK: get the results back
      m_uintInterval = dlgSlideShow.m_uintInterval;
      m_doLoop       = dlgSlideShow.m_doLoop;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnUrlFilter() 
{  // Toggle filtering state
   m_filterURL = !m_filterURL;
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnUpdateUrlFilter(CCmdUI* pCmdUI) 
{  // Show filtering state
   pCmdUI->SetCheck(m_filterURL);
}

/////////////////////////////////////////////////////////////////////////////
//
// These are the Webster event handlers: they are hand-coded to match reality
//

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::eventDoClickURL(BSTR* SelectedURL, SHORT* Cancel)
{  // User has selected a URL: are we filtering ?
   if (m_filterURL)
   {  // Filter is active: show the URL filter dialog
      CFilterDialog dlgFilter;
      // Set up the URL
      dlgFilter.m_editURL = *((LPCTSTR*) SelectedURL);
      // Let the user decide
      if (dlgFilter.DoModal() == IDOK)
      {  // Approval: get the latest user-entered value, could be new
         SysReAllocString(SelectedURL, dlgFilter.m_editURL);
      }
      else
      {  // User says Cancel:
         *Cancel = TRUE;
      }
      // Did user check the "Stop Me before I Show Again" box ?
      m_filterURL = !dlgFilter.m_stopShowingMe;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::eventKeyDown(short* KeyCode, short Shift)
{  // Ignore for now
}

