VERSION 2.00
Begin Form FMain 
   BackColor       =   &H8000000C&
   Caption         =   "Whisper Terminal for Windows (sample)"
   ClientHeight    =   4080
   ClientLeft      =   1560
   ClientTop       =   1680
   ClientWidth     =   7230
   ClipControls    =   0   'False
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "Terminal"
   FontSize        =   9
   FontStrikethru  =   0   'False
   FontTransparent =   0   'False
   FontUnderline   =   0   'False
   Height          =   4800
   Icon            =   WSPRTERM.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   1485
   LinkTopic       =   "DPTWS4W"
   ScaleHeight     =   4080
   ScaleWidth      =   7230
   Top             =   1035
   Width           =   7380
   Begin Timer TPaste 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   1215
      Top             =   135
   End
   Begin PictureBox Portal 
      ClipControls    =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Terminal"
      FontSize        =   9
      FontStrikethru  =   0   'False
      FontTransparent =   0   'False
      FontUnderline   =   0   'False
      Height          =   1905
      Left            =   2385
      ScaleHeight     =   1875
      ScaleWidth      =   1875
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   720
      Width           =   1905
      Begin PictureBox Scrn 
         ClipControls    =   0   'False
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Terminal"
         FontSize        =   9
         FontStrikethru  =   0   'False
         FontTransparent =   0   'False
         FontUnderline   =   0   'False
         Height          =   1590
         Left            =   135
         ScaleHeight     =   1560
         ScaleWidth      =   1560
         TabIndex        =   15
         TabStop         =   0   'False
         Top             =   135
         Width           =   1590
      End
   End
   Begin VScrollBar VScrollBar 
      Height          =   2040
      LargeChange     =   5
      Left            =   5985
      Max             =   23
      TabIndex        =   10
      TabStop         =   0   'False
      Top             =   1125
      Value           =   23
      Width           =   240
   End
   Begin HScrollBar HScrollBar 
      Height          =   240
      LargeChange     =   10
      Left            =   3150
      Max             =   10000
      SmallChange     =   100
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   3105
      Width           =   2805
   End
   Begin CommonDialog CMDialog1 
      Left            =   135
      Top             =   1215
   End
   Begin Timer cursorBlinkTimer 
      Enabled         =   0   'False
      Interval        =   300
      Left            =   675
      Top             =   135
   End
   Begin Timer CurTimeTimer 
      Interval        =   1000
      Left            =   135
      Top             =   135
   End
   Begin MSComm CommPort 
      CommPort        =   2
      DTREnable       =   0   'False
      Handshaking     =   2  'RTS
      Interval        =   100
      Left            =   135
      RThreshold      =   1
      Settings        =   "2400,e,7,2"
      SThreshold      =   1
      Top             =   675
   End
   Begin SSPanel StatusBar 
      Align           =   2  'Align Bottom
      BevelOuter      =   1  'Inset
      BevelWidth      =   2
      BorderWidth     =   0
      ForeColor       =   &H00FFFF80&
      Height          =   660
      Left            =   0
      TabIndex        =   0
      Top             =   3420
      Width           =   7230
      Begin SSPanel ModemPanel 
         BevelWidth      =   2
         ForeColor       =   &H00FFFF80&
         Height          =   240
         Left            =   45
         TabIndex        =   1
         Top             =   45
         Width           =   3165
         Begin Label LedDSR 
            AutoSize        =   -1  'True
            BackStyle       =   0  'Transparent
            Caption         =   "DSR"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "Terminal"
            FontSize        =   9
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00808080&
            Height          =   180
            Left            =   1080
            TabIndex        =   2
            Top             =   45
            Width           =   360
         End
         Begin Label LedCTS 
            AutoSize        =   -1  'True
            BackStyle       =   0  'Transparent
            Caption         =   "CTS"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "Terminal"
            FontSize        =   9
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00808080&
            Height          =   180
            Left            =   1980
            TabIndex        =   3
            Top             =   45
            Width           =   360
         End
         Begin Label LedTX 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            BackStyle       =   0  'Transparent
            Caption         =   "TX"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "Terminal"
            FontSize        =   9
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00808080&
            Height          =   180
            Left            =   2790
            TabIndex        =   8
            Top             =   45
            Width           =   255
         End
         Begin Label LedRX 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            BackStyle       =   0  'Transparent
            Caption         =   "RX"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "Terminal"
            FontSize        =   9
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00808080&
            Height          =   180
            Left            =   2475
            TabIndex        =   7
            Top             =   45
            Width           =   240
         End
         Begin Label LedDTR 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            BackStyle       =   0  'Transparent
            Caption         =   "DTR"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "Terminal"
            FontSize        =   9
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00808080&
            Height          =   180
            Left            =   135
            TabIndex        =   6
            Top             =   45
            Width           =   360
         End
         Begin Label LedRTS 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            BackStyle       =   0  'Transparent
            Caption         =   "RTS"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "Terminal"
            FontSize        =   9
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00808080&
            Height          =   180
            Left            =   585
            TabIndex        =   5
            Top             =   45
            Width           =   360
         End
         Begin Label LedCD 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            BackStyle       =   0  'Transparent
            Caption         =   "DCD"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "Terminal"
            FontSize        =   9
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00808080&
            Height          =   180
            Left            =   1530
            TabIndex        =   4
            Top             =   45
            Width           =   360
         End
      End
      Begin SSPanel ElapsedTime 
         BackColor       =   &H00808080&
         BevelOuter      =   1  'Inset
         BorderWidth     =   1
         Caption         =   "elapsed time"
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00C0C0C0&
         Height          =   195
         Left            =   6075
         TabIndex        =   13
         Top             =   45
         Width           =   1095
      End
      Begin SSPanel CurrentTime 
         BackColor       =   &H00808080&
         BevelOuter      =   1  'Inset
         BorderWidth     =   1
         Caption         =   "current time"
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00C0C0C0&
         Height          =   195
         Left            =   4905
         TabIndex        =   11
         Top             =   45
         Width           =   1095
      End
      Begin SSPanel StatusPanel 
         BackColor       =   &H00000000&
         BevelOuter      =   1  'Inset
         BevelWidth      =   2
         BorderWidth     =   2
         Caption         =   "Status Info"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   45
         TabIndex        =   9
         Top             =   315
         Width           =   7125
      End
   End
   Begin Menu MFile 
      Caption         =   "&File"
      Begin Menu MFileRefresh 
         Caption         =   "&Refresh Screen"
         Shortcut        =   ^R
      End
      Begin Menu MFilePrintScreen 
         Caption         =   "&Print Screen"
         Shortcut        =   ^P
      End
      Begin Menu MFileScrCaptureBegin 
         Caption         =   "Screen &Capture Begin"
      End
      Begin Menu MFileScrCaptureEnd 
         Caption         =   "Screen &Capture End"
         Enabled         =   0   'False
         Visible         =   0   'False
      End
      Begin Menu MFileScrCaptureSetup 
         Caption         =   "Screen Capture Se&tup..."
         Enabled         =   0   'False
         Visible         =   0   'False
      End
      Begin Menu MSFileSave 
         Caption         =   "-"
      End
      Begin Menu MFileLoad 
         Caption         =   "&Load Setup..."
      End
      Begin Menu MFileSave 
         Caption         =   "&Save Setup..."
      End
      Begin Menu MSFileExit 
         Caption         =   "-"
      End
      Begin Menu MFileExit 
         Caption         =   "E&xit WSPRTERM"
      End
   End
   Begin Menu MEdit 
      Caption         =   "&Edit"
      Begin Menu MEditUnselect 
         Caption         =   "&Unselect Text"
         Enabled         =   0   'False
      End
      Begin Menu MSEditCopy 
         Caption         =   "-"
      End
      Begin Menu MEditCopy 
         Caption         =   "&Copy New"
         Enabled         =   0   'False
         Shortcut        =   ^C
      End
      Begin Menu MEditCopyAppend 
         Caption         =   "Copy &Append"
         Enabled         =   0   'False
         Shortcut        =   ^A
      End
      Begin Menu MEditPaste 
         Caption         =   "&Paste"
         Enabled         =   0   'False
         Shortcut        =   ^V
      End
      Begin Menu MSEditPasteInterval 
         Caption         =   "-"
         Visible         =   0   'False
      End
      Begin Menu MEditPasteRate 
         Caption         =   "Paste &Rate"
         Enabled         =   0   'False
         Visible         =   0   'False
      End
      Begin Menu MSEditShowClipboard 
         Caption         =   "-"
      End
      Begin Menu MEditShowClipboard 
         Caption         =   "&Show Clipboard"
      End
   End
   Begin Menu MSession 
      Caption         =   "&Session"
      Begin Menu MSessionConnect 
         Caption         =   "&Connect"
         Shortcut        =   +{INSERT}
      End
      Begin Menu MSessionDisconnect 
         Caption         =   "&Disconnect"
         Shortcut        =   +{DEL}
      End
      Begin Menu MSSessionSetup 
         Caption         =   "-"
      End
      Begin Menu MSessionAsync 
         Caption         =   "&Async Select/Setup..."
         Checked         =   -1  'True
      End
      Begin Menu MSSessionAutoStart 
         Caption         =   "-"
      End
      Begin Menu MSessionAutoConnect 
         Caption         =   "Auto Connect At &Startup"
      End
   End
   Begin Menu MPref 
      Caption         =   "&Preferences"
      Begin Menu MPrefFont 
         Caption         =   "&Font"
         Begin Menu MPrefFontScreen 
            Caption         =   "&Screen"
         End
         Begin Menu MPrefFontPrinter 
            Caption         =   "&Printer"
         End
      End
      Begin Menu MPrefColor 
         Caption         =   "&Color"
         Begin Menu MPrefColorFg 
            Caption         =   "&Foreground (text)..."
         End
         Begin Menu MPrefColorBg 
            Caption         =   "&Background..."
         End
         Begin Menu MPrefColorHi 
            Caption         =   "&Highlight (bold)..."
         End
         Begin Menu MPrefColorCursor 
            Caption         =   "&Cursor..."
         End
         Begin Menu MSColorSelected 
            Caption         =   "-"
         End
         Begin Menu MColorSelectedText 
            Caption         =   "&Selected Text"
            Begin Menu MColorSelTextFg 
               Caption         =   "&Foreground (text)..."
            End
            Begin Menu MColorSelTextBg 
               Caption         =   "&Background..."
            End
         End
      End
      Begin Menu MSPrefLineSpacing 
         Caption         =   "-"
      End
      Begin Menu MPrefLineSpacing 
         Caption         =   "&Line Spacing..."
      End
      Begin Menu MPrefCursorBlink 
         Caption         =   "Cursor &Blink Rate..."
      End
      Begin Menu MSPrefRoll 
         Caption         =   "-"
      End
      Begin Menu MPrefRollStyle 
         Caption         =   "&Roll Up/Down style"
         Begin Menu MPrefRollBuffered 
            Caption         =   "&Buffered"
         End
         Begin Menu MPrefRollImmediate 
            Caption         =   "&Immediate"
         End
         Begin Menu MPrefRollSmart 
            Caption         =   "&Smart"
            Checked         =   -1  'True
         End
      End
   End
   Begin Menu MMouse 
      Caption         =   "&Mouse"
      Begin Menu MMouseMenu 
         Caption         =   "&Menu Style"
         Checked         =   -1  'True
      End
      Begin Menu MMouseEditor 
         Caption         =   "&Editor Style"
      End
      Begin Menu MMouseOff 
         Caption         =   "&Off"
      End
   End
   Begin Menu MHelp 
      Caption         =   "&Help"
      Begin Menu MHelpAbout 
         Caption         =   "&About WSPRTERM..."
      End
   End
End

Option Explicit

Declare Function MatchCount Lib "WSPRTERM.DLL" (ByVal attrStr$, ByVal colorStr$, ByVal attr$, ByVal Color$, ByVal maxLen%) As Integer

Declare Function IsCharUpper Lib "User" (ByVal cChar As Integer) As Integer

Declare Function GetBkColor Lib "GDI" (ByVal hDC As Integer) As Long
Declare Function SetBkColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long

Declare Function SetBkMode Lib "GDI" (ByVal hDC As Integer, ByVal nBkMode As Integer) As Integer

Declare Function GetTextColor Lib "GDI" (ByVal hDC As Integer) As Long
Declare Function SetTextColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long

Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName As Any, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%) As Integer
Declare Function WriteProfileString Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpString$) As Integer

Declare Function SndPlaySound Lib "MMSYSTEM.DLL" (ByVal lpszSoundName As Any, ByVal wFlags%) As Integer
Const SND_SYNC = &H0
Const SND_ASYNC = &H1
Const SND_NODEFAULT = &H2
Const SND_LOOP = &H8
Const SND_NOSTOP = &H10

Declare Sub ScrollWindow Lib "User" (ByVal hWnd As Integer, ByVal XAmount As Integer, ByVal YAmount As Integer, lpRect As RECT, lpClipRect As RECT)
Declare Function ScrollDC Lib "User" (ByVal hDC As Integer, ByVal dx As Integer, ByVal dy As Integer, lprcScroll As RECT, lprcClip As RECT, ByVal hRgnUpdate As Integer, lprcUpdate As RECT) As Integer
Dim lprcScroll As RECT
Dim liveClip As RECT
Dim fullClip As RECT
Dim hRgnUpdate As Integer
Dim lprcUpdate As RECT


Dim rollCnt As Integer
Dim scrollLR As Integer
Dim windowWidth As Integer
Dim lastWindowState As Integer

Dim mouseDwnX As Integer
Dim mouseDwnY As Integer
Dim mouseUpX As Integer
Dim mouseUpY As Integer

Dim dataEnd As Integer
Dim dataIndex As Integer

Static Sub BldScrn (Dta$)

' This routine parses the incoming data stream.
' Most codes received are for a Datapoint 735x terminal type.  I have
' left most of them in to demonstrate what functions are used for the
' type of operation required.

    On Error Resume Next
    Dim opChar$, opVal%, saveCursState%, dummyInt%

    rollCnt = 0
    partialScrnUpdate = (rollStyle <> IMMEDIATE)
    
    saveCursState = textCursorOn
    If textCursorOn Then
	cursorBlinkTimer.Enabled = False
	textCursorOn = False
	SetCursorOff
    End If
    shortStr = ""

    If textSelected Then MEditUnselect_Click

    dataIndex = 1
    dataEnd = Len(Dta$)
    Do
	opChar = Mid(Dta$, dataIndex, 1)
	opVal = Asc(opChar)

	Select Case cmdSeq
	    Case EscSeq
		BldScrnEsc (opVal)

	    Case ExtendedSeq        ' VT100 like cmds
		BldScrnExtended (opVal)

	    Case Else
		If opVal < &H32 Then
		    Scrn.Print shortStr;
		    shortStr = ""
		End If

		Select Case opVal
		    Case &H3    ' RollDown
			RollDown margin.top, margin.bottom
			If localCapture Then FlushCapturedLine

		    Case &H7    ' Bell (beep)
			If beepWav = "" Then
			    Beep
			Else
			    dummyInt = SndPlaySound(beepWav, SND_ASYNC)
			End If

		    Case &H8    ' Backspace
			If curX > margin.left Then
			    curX = curX - 1
			    MoveCursor curX, curY
			End If

		    Case &HA    ' Linefeed
			If curY < margin.bottom Then
			    curY = curY + 1
			Else
			    RollUp margin.top, margin.bottom
			End If
			MoveCursor curX, curY
			If localCapture Then FlushCapturedLine

		    Case &HB    ' RollUp
			RollUp margin.top, margin.bottom
			If localCapture Then FlushCapturedLine

		    Case &HD    ' Carriage Return
			curX = margin.left
			MoveCursor curX, curY

		    Case &H15   ' HomeUp
			curX = margin.left
			curY = margin.top
			MoveCursor curX, curY
			If localCapture Then FlushCapturedLine

		    Case &H16   ' EraseToEOL
			EraseToEOL

		    Case &H17   ' EraseToEOF
			EraseToEOF

		    Case &H18   ' CursorOn
			saveCursState = True

		    Case &H19   ' CursorOff
			saveCursState = False

		    Case &H1B   ' Esc sequence
			cmdSeq = EscSeq
			seqPhase = 0

		    Case Else   ' Must be something else.
			If opVal <> &H1F Then
			    DisplayChar opChar
			End If
		End Select
	End Select
	dataIndex = dataIndex + 1
    Loop While dataIndex <= dataEnd

    If rollCnt < 0 Then         ' Roll Down
	dummyInt = ScrollDC(Scrn.hDC, 0, -(pixelHeight * rollCnt), lprcScroll, liveClip, hRgnUpdate, lprcUpdate)
	rollCnt = 0
    ElseIf rollCnt > 0 Then     ' Roll Up
	dummyInt = ScrollDC(Scrn.hDC, 0, -(pixelHeight * rollCnt), lprcScroll, fullClip, hRgnUpdate, lprcUpdate)
	rollCnt = 0
    End If
    If partialScrnUpdate Then
	ReDisplayScreen qX1, qY1, qX2, qY2
    Else
	Scrn.Print shortStr;
    End If

    textCursorOn = saveCursState
    If textCursorOn Then
	SetCursorOn
	cursorBlinkTimer.Enabled = True
    End If

End Sub

Sub BldScrnEsc (ByVal byte As Integer)
    Dim dummyColor&, rv%

    If seqPhase = 0 Then subCmdSeq = byte

    Select Case subCmdSeq
	Case &H4    ' StandardVideoMode
	    curAttr = curAttr And ANormal
	    If localCapture Then SetCapturedLineAttr
	    SetAttributes curAttr, curColor
	    cmdSeq = 0
 
	Case &H5    ' InverseVideoMode
	    curAttr = curAttr Or AInverse
	    SetAttributes curAttr, curColor
	    cmdSeq = 0

	Case &H6    ' HighIntensityVideoMode
	    curAttr = curAttr Or ABold
	    If localCapture Then SetCapturedLineAttr
	    SetAttributes curAttr, curColor
	    cmdSeq = 0

	Case &H7    ' Click
	    If clickWav <> "" Then
		rv = SndPlaySound(clickWav, SND_ASYNC)
	    End If
	    cmdSeq = 0

	Case &H8    ' OpenLine
	    OpenLine

	Case &H9    ' CloseLine
	    CloseLine

	Case &HC    ' ResetMargins
	    ResetMargins
	    cmdSeq = 0

	Case &HE    ' SetMargins
	    SetMargins (byte)

	Case &HF    ' SetTopBtmMargins
	    SetTBMargins (byte)

	Case &H11   ' InsertChar
	    InsertChar (byte)

	Case &H12   ' DeleteChar
	    DeleteChar (byte)

	Case &H13   ' DuplicateChar
	    DupChar (byte)

	Case &H14   ' InsertLine
	    RollDown curY, margin.bottom
	    cmdSeq = 0

	Case &H1A   ' DeleteLine
	    RollUp curY, margin.bottom
	    cmdSeq = 0

	Case &H1B   ' ForceNextChar
	    If seqPhase = 0 Then
		seqPhase = seqPhase + 1
	    Else
		DisplayChar Chr$(byte)
		cmdSeq = 0
	    End If

	Case &H5B   ' ExtendedCmdSeq
	    cmdSeq = ExtendedSeq
	    paramCnt = 0

	Case &H63   ' Reset (RIS)
	    ResetMargins
	    curX = 0
	    curY = 0
	    curAttr = ANormal
	    EraseToEOF
	    cmdSeq = 0

	Case Else   ' Illegal sequence
	    Beep
	    cmdSeq = 0

    End Select

End Sub

Sub BldScrnExtended (ByVal byte As Integer)
    Dim i%

    Select Case byte
	Case &H41   ' CursorUp
	    cmdSeq = 0
	    If localCapture Then FlushCapturedLine
	Case &H42   ' CursorDown
	    cmdSeq = 0
	    If localCapture Then FlushCapturedLine
	Case &H43   ' CursorForward
	    cmdSeq = 0
	Case &H44   ' CursorBackward
	    cmdSeq = 0
	Case &H48   ' CursorPos
	    cmdSeq = 0
	Case &H66   ' HorVerPos (HVP)
	    cmdSeq = 0
	Case &H69   ' ReadLogicalScreen
	    cmdSeq = 0
	Case &H6D   ' SelectAttrib
	    For i = 1 To paramCnt
		Select Case param(i)
		    Case &H30
			curAttr = curAttr And ANormal
			If localCapture Then SetCapturedLineAttr
			SetAttributes curAttr, curColor
		    Case &H31
			If (i = paramCnt) Or (param(i + 1) = &H3B) Then
			    curAttr = curAttr Or ABold
			    If localCapture Then SetCapturedLineAttr
			    SetAttributes curAttr, curColor
			Else
			    i = i + 1
			End If
		    Case &H34
			curAttr = curAttr Or AUnderline
			If localCapture Then SetCapturedLineAttr
			SetAttributes curAttr, curColor
		    Case &H35
			curAttr = curAttr Or ABlink
			SetAttributes curAttr, curColor
		    Case &H37
			curAttr = curAttr Or AInverse
			SetAttributes curAttr, curColor
		   Case &H3F
			curAttr = curAttr Or ABlank
			SetAttributes curAttr, curColor
		End Select
	    Next i
	    cmdSeq = 0

	Case Else   ' Parameter
	    If paramCnt < MaxParam Then
		paramCnt = paramCnt + 1
		param(paramCnt) = byte
	    End If
    End Select
End Sub

Sub CalculateYPosValues ()
    Dim i%

    yPos(MaxRow) = Scrn.Height - Scrn.TextHeight("M")
    For i = MaxRow - 1 To MinRow Step -1
	yPos(i) = yPos(i + 1) - Scrn.TextHeight("M") - lineSpacingExt
    Next i

End Sub

Sub CloseLine ()
    Dim i%

    cmdSeq = 0
    If curY < margin.bottom Then
	i = sdI(curY)
	Mid(scrnData(i), curX + 1, margin.right - curX + 1) = Mid(scrnData(sdI(curY + 1)), curX + 1, margin.right - curX + 1)
	Mid(scrnAttr(i), curX + 1, margin.right - curX + 1) = Mid(scrnAttr(sdI(curY + 1)), curX + 1, margin.right - curX + 1)
	Mid(scrnColor(i), curX + 1, margin.right - curX + 1) = Mid(scrnColor(sdI(curY + 1)), curX + 1, margin.right - curX + 1)
	RollUp curY + 1, margin.bottom
	QScreenUpdate curX, curY, margin.right, curY
    Else
	EraseToEOL
    End If

End Sub

Sub CommPort_OnComm ()
    Dim EVMsg$, ERMsg$
    
    Select Case CommPort.CommEvent

	Case MSCOMM_EV_RECEIVE
	    LedRX.ForeColor = LedOnColor
	    BldScrn (CommPort.Input)
	    If CommPort.InBufferCount = 0 Then
		LedRX.ForeColor = LedOffColor
	    End If

	Case MSCOMM_EV_SEND
	    LedTX.ForeColor = LedOffColor
	    If Len(queueTxData) > 0 Then
		SendString ""
	    End If
	    
	Case MSCOMM_EV_CTS
	    If CommPort.CTSHolding Then
		LedCTS.ForeColor = LedOnColor
	    Else
		LedCTS.ForeColor = LedOffColor
	    End If

	Case MSCOMM_EV_DSR
	    If CommPort.DSRHolding Then
		LedDSR.ForeColor = LedOnColor
	    Else
		LedDSR.ForeColor = LedOffColor
	    End If

	Case MSCOMM_EV_CD
	    If CommPort.CDHolding Then
		LedCD.ForeColor = LedOnColor
		If connecting Then
		    ShowStatus "OnLine - COM" & CommPort.CommPort & ":" & CommPort.Settings, False
		    connecting = False
		End If
	    Else
		LedCD.ForeColor = LedOffColor
		If disconnecting Then
		    ShowStatus "Disconnected", False
		    disconnecting = False
		End If
	    End If

	Case MSCOMM_EV_RING
	Case MSCOMM_EV_EOF

	'--- Error messages
	Case MSCOMM_ER_BREAK
	Case MSCOMM_ER_CTSTO
	Case MSCOMM_ER_DSRTO
	Case MSCOMM_ER_FRAME
	    ERMsg$ = "Framing Error"
	Case MSCOMM_ER_OVERRUN
	    ERMsg$ = "Overrun Error"
	Case MSCOMM_ER_CDTO
	Case MSCOMM_ER_RXOVER
	    ERMsg$ = "Receive Buffer Overflow"
	Case MSCOMM_ER_RXPARITY
	    ERMsg$ = "Parity Error"
	Case MSCOMM_ER_TXFULL
	    ERMsg$ = "Transmit Buffer Full"
	Case Else
	    ERMsg$ = "Unknown error/event: " & CommPort.CommEvent
    End Select
    
    If Len(EVMsg$) Then
	ShowStatus EVMsg$, False
	EVMsg$ = ""
    ElseIf Len(ERMsg$) Then
	Beep
	ShowStatus ERMsg$, True
	ERMsg$ = ""
    End If

End Sub

Sub cursorBlinkTimer_Timer ()
    Static blinkOn As Integer

    If blinkOn Then SetCursorOff Else SetCursorOn
    blinkOn = Not blinkOn

End Sub

Sub CurTimeTimer_Timer ()

    CurrentTime.Caption = Format(Now, "h:mm AM/PM")
    ElapsedTime.Caption = Format(startTime - TimeValue(Now), "hh:mm:ss")
    
End Sub

Sub DeleteChar (ByVal byte As Integer)
    Static fieldH%, fieldV%
    Dim i%, j%, wrapChar$, wrapAttr$, wrapColor$

    Select Case seqPhase
	Case 1
	    fieldH = byte + margin.left
	Case 2
	    cmdSeq = 0
	    fieldV = byte + margin.top
	    If (fieldH <= margin.right) And (fieldV <= margin.bottom) Then
		i = sdI(curY)
		If curY = fieldV Then
		    Mid(scrnData(i), curX + 1, fieldH - curX + 1) = Mid(scrnData(i), curX + 2, fieldH - curX) & " "
		    Mid(scrnAttr(i), curX + 1, fieldH - curX + 1) = Mid(scrnAttr(i), curX + 2, fieldH - curX) & Chr$(curAttr)
		    Mid(scrnColor(i), curX + 1, fieldH - curX + 1) = Mid(scrnColor(i), curX + 2, fieldH - curX) & Chr$(curColor)
		    QScreenUpdate curX, curY, fieldH, curY
		Else
		    wrapChar = Mid(scrnData(sdI(i + 1)), margin.left + 1, 1)
		    wrapAttr = Mid(scrnAttr(sdI(i + 1)), margin.left + 1, 1)
		    wrapColor = Mid(scrnColor(sdI(i + 1)), margin.left + 1, 1)
		    Mid(scrnData(i), curX + 1, margin.right - curX + 1) = Mid(scrnData(i), curX + 2, margin.right - curX) & wrapChar
		    Mid(scrnAttr(i), curX + 1, margin.right - curX + 1) = Mid(scrnAttr(i), curX + 2, margin.right - curX) & wrapAttr
		    Mid(scrnColor(i), curX + 1, margin.right - curX + 1) = Mid(scrnColor(i), curX + 2, margin.right - curX) & wrapColor
		    For j = curY + 1 To fieldV
			i = sdI(j)
			If j = fieldV Then
			    Mid(scrnData(i), margin.left + 1, fieldH - margin.left + 1) = Mid(scrnData(i), margin.left + 2, fieldH - margin.left) & " "
			    Mid(scrnAttr(i), margin.left + 1, fieldH - margin.left + 1) = Mid(scrnAttr(i), margin.left + 2, fieldH - margin.left) & Chr$(curAttr)
			    Mid(scrnColor(i), margin.left + 1, fieldH - margin.left + 1) = Mid(scrnColor(i), margin.left + 2, fieldH - margin.left) & Chr$(curColor)
			Else
			    wrapChar = Mid(scrnData(sdI(j + 1)), margin.left + 1, 1)
			    wrapAttr = Mid(scrnAttr(sdI(j + 1)), margin.left + 1, 1)
			    wrapColor = Mid(scrnColor(sdI(j + 1)), margin.left + 1, 1)
			    Mid(scrnData(i), margin.left + 1, windowWidth) = Mid(scrnData(i), margin.left + 2, margin.right - margin.left) & wrapChar
			    Mid(scrnAttr(i), margin.left + 1, windowWidth) = Mid(scrnAttr(i), margin.left + 2, margin.right - margin.left) & wrapAttr
			    Mid(scrnColor(i), margin.left + 1, windowWidth) = Mid(scrnColor(i), margin.left + 2, margin.right - margin.left) & wrapColor
			End If
		    Next j
		    QScreenUpdate margin.left, curY, margin.right, fieldV
		End If
	    End If
	End Select

    seqPhase = seqPhase + 1

End Sub

Sub DisplayChar (ByVal char As String)
    Dim i%

    i = sdI(curY)

    Mid(scrnData(i), curX + 1, 1) = char
    Mid(scrnAttr(i), curX + 1, 1) = Chr$(curAttr)
    Mid(scrnColor(i), curX + 1, 1) = Chr$(curColor)
    If localCapture Then
	localCaptureLine = localCaptureLine & char
    End If

    If partialScrnUpdate Then
	QScreenUpdate curX, curY, curX, curY
    ElseIf curX < margin.right Then
	shortStr = shortStr & char
    Else
	Scrn.Print shortStr & char;
	shortStr = ""
	MoveCursor curX, curY
    End If
    If curX < margin.right Then
	curX = curX + 1
    End If

End Sub

Sub DupChar (ByVal byte As Integer)
    Static char%, i%

    Select Case seqPhase
	Case 1
	    char = byte
	Case 2
	    cmdSeq = 0
	    If (char <= &HFE) And (byte <= &HFE) Then
		For i = 1 To byte
		    DisplayChar Chr$(char)
		Next i
	    End If
	End Select

    seqPhase = seqPhase + 1

End Sub

Sub ElapsedTime_Click ()

    startTime = TimeValue(Now)
    ElapsedTime.Caption = Format(startTime - TimeValue(Now), "hh:mm:ss")

End Sub

Sub EraseToEOF ()
    Dim i%

    EraseToEOL
    If (margin.left = 0) And (margin.right = MaxColumn) Then
	For i = curY + 1 To margin.bottom
	    scrnData(sdI(i)) = blankLine
	    scrnAttr(sdI(i)) = String(CharsPerRow, curAttr)
	    scrnColor(sdI(i)) = String(CharsPerRow, curColor)
	Next i
    Else
	For i = curY + 1 To margin.bottom
	    Mid(scrnData(sdI(i)), margin.left + 1, windowWidth) = String(windowWidth, " ")
	    Mid(scrnAttr(sdI(i)), margin.left + 1, windowWidth) = String(windowWidth, curAttr)
	    Mid(scrnColor(sdI(i)), margin.left + 1, windowWidth) = String(windowWidth, curColor)
	Next i
    End If
    QScreenUpdate margin.left, curY, margin.right, margin.bottom

End Sub

Sub EraseToEOL ()

    Mid(scrnData(sdI(curY)), curX + 1, margin.right - curX + 1) = String(margin.right - curX + 1, " ")
    Mid(scrnAttr(sdI(curY)), curX + 1, margin.right - curX + 1) = String(margin.right - curX + 1, curAttr)
    Mid(scrnColor(sdI(curY)), curX + 1, margin.right - curX + 1) = String(margin.right - curX + 1, curColor)
    QScreenUpdate curX, curY, margin.right, curY

End Sub

Function FindUpperCaseChar () As Integer
    Dim row%, col%, i%, chCode%

    row = mouseUpY \ (Scrn.TextHeight("M") + lineSpacingExt) + MinRow
    If row > MaxRow Then row = MaxRow
    col = mouseUpX \ Scrn.TextWidth("M")
    If col > MaxColumn Then col = MaxColumn
    ' Look left
    For i = col To MinColumn Step -1
	chCode = Asc(Mid(scrnData(sdI(row)), i + 1, 1))
	If chCode = &H20 Then Exit For
	If IsCharUpper(chCode) <> 0 Then
	    FindUpperCaseChar = chCode
	    Exit Function
	End If
    Next i
    ' Not found left, so look right
    For i = col To MaxColumn
	chCode = Asc(Mid(scrnData(sdI(row)), i + 1, 1))
	If chCode = &H20 Then Exit For
	If IsCharUpper(chCode) <> 0 Then
	    FindUpperCaseChar = chCode
	    Exit Function
	End If
    Next i
    FindUpperCaseChar = 0

End Function

Sub FlushCapturedLine ()

    On Error GoTo prtFlushError
    Printer.Print localCaptureLine
    localCaptureLine = ""
    Exit Sub

prtFlushError:
    localCapture = False
    MFileScrCaptureBegin.Enabled = True
    MFileScrCaptureBegin.Visible = True
    MFileScrCaptureEnd.Enabled = False
    MFileScrCaptureEnd.Visible = False
    MFilePrintScreen.Enabled = True
    ShowStatus "Printer Error", True
    Resume Next

End Sub

Sub Form_Activate ()

    Select Case curConnectType
	Case CT_Async
	    If CommPort.PortOpen = False Then
		CommPort.Settings = curBaudRate & "," & curParity & "," & curDataBits & "," & curStopBits
		CommPort.CommPort = curCommPort
		CommPort.Handshaking = curHandShake
		If CommPort.DTREnable Then LedDTR.ForeColor = LedOnColor
		If CommPort.RTSEnable Then LedRTS.ForeColor = LedOnColor
		If CommPort.CDHolding Then LedCD.ForeColor = LedOnColor
		If CommPort.DSRHolding Then LedDSR.ForeColor = LedOnColor
		If CommPort.CTSHolding Then LedCTS.ForeColor = LedOnColor
	    End If
	    ShowStatus "COM" & CommPort.CommPort & ":" & CommPort.Settings, False
    End Select

End Sub

Sub Form_GotFocus ()

    Scrn.SetFocus

End Sub

Sub Form_KeyPress (KeyAscii As Integer)

    SendString Chr$(KeyAscii)
    KeyAscii = 0

End Sub

Sub Form_Load ()
    Dim rv%

    InitVars
    
    localCapture = False
    textSelected = False
    pasteInterval = TPaste.Interval
    pasteBurst = 5
    lastWindowState = FMain.WindowState

    normalBgColor = GetSysColor(COLOR_WINDOW)
    normalFgColor = GetSysColor(COLOR_WINDOWTEXT)
    normalHiColor = normalFgColor
    cursorColor = normalFgColor
    selTextFgColor = normalBgColor
    selTextBgColor = normalFgColor

    Portal.BorderStyle = 0
    Scrn.BorderStyle = 0

    LoadFromFile DefaultINI

    ' Get the following from the WIN.INI [sounds] section
    clickWav = GetOrSetWav(Appl_ClickWav, defaultClickWav)
    beepWav = GetOrSetWav(Appl_BeepWav, defaultBeepWav)


    ' If no default INI file has been created, then create one
    If curIniFilename = "" Then
	curIniFilename = "*.wtw"
	SaveToFile DefaultINI
	rv = WritePrivateProfileString(Key_Notes, Appl_CurrentIni, curIniFilename, DefaultINI)
    End If

    MoveCursor curX, curY
    SetCursorOff
    textCursorOn = False

    cmdSeq = 0

    startTime = TimeValue(Now)

    LedOnColor = QBColor(OnColor)
    LedOffColor = QBColor(OffColor)
    LedRX.ForeColor = LedOffColor
    LedTX.ForeColor = LedOffColor
    LedDTR.ForeColor = LedOffColor
    LedRTS.ForeColor = LedOffColor
    LedCD.ForeColor = LedOffColor
    LedDSR.ForeColor = LedOffColor
    LedCTS.ForeColor = LedOffColor

    MSessionDisconnect.Enabled = False

End Sub

Sub Form_Resize ()
    Dim tempSize%, minWidth%, maxWidth%, rv%

    If FMain.WindowState <> MINIMIZED Then

	' Only allow full line heights
	If FMain.WindowState <> MAXIMIZED Then
	    tempSize = FMain.Height - StatusBar.Height - sidesTB - HScrollBar.Height
	    tempSize = tempSize \ (Scrn.TextHeight("M") + lineSpacingExt)
	    FMain.Height = (tempSize * (Scrn.TextHeight("M") + lineSpacingExt)) + StatusBar.Height + sidesTB + HScrollBar.Height
	End If

	HScrollBar.SmallChange = Scrn.TextWidth("M")
	HScrollBar.LargeChange = HScrollBar.SmallChange * 10
	VScrollBar.SmallChange = Scrn.TextHeight("M") + lineSpacingExt
	VScrollBar.LargeChange = VScrollBar.SmallChange * 5

	minWidth = ModemPanel.Width + CurrentTime.Width + ElapsedTime.Width + 500
	maxWidth = CharsPerRow * Scrn.TextWidth("M") + sidesLR + VScrollBar.Width
	If minWidth > maxWidth Then maxWidth = minWidth
	If FMain.Width < minWidth Then
	    FMain.Width = minWidth
	ElseIf (FMain.Width > maxWidth) And (FMain.WindowState <> MAXIMIZED) Then
	    FMain.Width = maxWidth
	End If

	tempSize = FMain.Width - sidesLR - VScrollBar.Width
	HScrollBar.Max = (CharsPerRow * Scrn.TextWidth("M")) - tempSize
	HScrollBar.Enabled = (HScrollBar.Max > HScrollBar.Min)
	tempSize = (FMain.Height - StatusBar.Height - sidesTB - HScrollBar.Height)' - 30)
	VScrollBar.Max = ((MaxRow - MinRow + 1) * (Scrn.TextHeight("M") + lineSpacingExt)) - tempSize
	VScrollBar.Enabled = (VScrollBar.Max > VScrollBar.Min)


	StatusPanel.Width = FMain.ScaleWidth - StatusPanel.left - 30
	ElapsedTime.left = StatusPanel.Width - ElapsedTime.Width
	CurrentTime.left = ElapsedTime.left - CurrentTime.Width - 50

	HScrollBar.Width = FMain.Width - sidesLR - VScrollBar.Width
	HScrollBar.left = 0
	HScrollBar.top = FMain.Height - sidesTB - StatusBar.Height - HScrollBar.Height

	VScrollBar.top = 0
	VScrollBar.left = FMain.Width - sidesLR - VScrollBar.Width
	VScrollBar.Height = Abs(HScrollBar.top)

	Portal.top = FMain.ScaleTop
	Portal.left = FMain.ScaleLeft
	Portal.Width = VScrollBar.left
	Portal.Height = VScrollBar.Height
	Portal.BackColor = normalBgColor

	If (lastWindowState = MAXIMIZED) And (FMain.WindowState <> MAXIMIZED) Then
	    VScrollBar.Value = VScrollBar.Max
	End If

	Scrn.top = -VScrollBar.Value
	Scrn.left = -HScrollBar.Value
	Scrn.Width = CharsPerRow * Scrn.TextWidth("M")
	Scrn.Height = (MaxRow - MinRow + 1) * (Scrn.TextHeight("M") + lineSpacingExt)
	CalculateYPosValues

	visibleArea.bottom = MaxRow - (VScrollBar.Max - VScrollBar.Value) \ (Scrn.TextHeight("M") + lineSpacingExt)
	visibleArea.top = (visibleArea.bottom - (VScrollBar.Height \ (Scrn.TextHeight("M") + lineSpacingExt))) + 1
	visibleLines = visibleArea.bottom - visibleArea.top + 1
	ShowStatus visibleLines & " lines from " & Str$(visibleArea.top) & " through " & Trim$(Str$(visibleArea.bottom)) & " are visible", False

	SetClipRegion

    End If

    lastWindowState = FMain.WindowState
    If FMain.WindowState = NORMAL Then
	initLeft = FMain.left
	initTop = FMain.top
	initWidth = FMain.Width
	initHeight = FMain.Height
	rv = WritePrivateProfileString(Key_Notes, Appl_Width, Str$(initWidth), DefaultINI)
	rv = WritePrivateProfileString(Key_Notes, Appl_Height, Str$(initHeight), DefaultINI)
    End If
    
End Sub

Sub Form_Unload (Cancel As Integer)
    Dim rv%

    MFileScrCaptureEnd_Click

    If MSessionDisconnect.Enabled Then
	MSessionDisconnect_Click
    End If

    rv = WritePrivateProfileString(Key_Pref, Appl_MouseStyle, Str$(mouseStyle), DefaultINI)
    If FMain.WindowState = NORMAL Then
	rv = WritePrivateProfileString(Key_Notes, Appl_Top, Str$(FMain.top), DefaultINI)
	rv = WritePrivateProfileString(Key_Notes, Appl_Left, Str$(FMain.left), DefaultINI)
    End If
    
    End

End Sub

Function GetOrSetWav (keyWav$, dfltWav$) As String
    Dim rv%, pLen%, pStr As String * 256, wavName$

    pLen = GetProfileString("Sounds", keyWav, "", pStr, 255)
    wavName = Trim$(Left$(pStr, pLen))
    pLen = InStr(wavName, ",")
    If pLen > 0 Then
	wavName = Trim$(Left$(wavName, pLen - 1))
    End If
    If wavName = "" Then     'not installed yet or incorrect format, so let's install it
	rv = WriteProfileString("Sounds", keyWav, dfltWav & "," & keyWav)
	wavName = dfltWav
    End If

    GetOrSetWav = wavName

End Function

Sub HScrollBar_Change ()
    
    Scrn.left = -HScrollBar.Value

End Sub

Sub HScrollBar_GotFocus ()

    Scrn.SetFocus

End Sub

Sub InitVars ()
    Dim i%

    blankLine = String(CharsPerRow, " ")
    curAttrFullLine = String(CharsPerRow, ANormal)
    curAttr = ANormal
    curColor = CNormal
    For i = MinRow To MaxRow
	scrnData(i) = blankLine
	scrnAttr(i) = curAttrFullLine
	scrnColor(i) = String(CharsPerRow, CNormal)
	sdI(i) = i
    Next i

    sidesLR = FMain.Width - FMain.ScaleWidth
    sidesTB = FMain.Height - FMain.ScaleHeight

    curX = 0
    curY = 0
    ResetMargins

    qX1 = MaxColumn
    qY1 = MaxRow
    qX2 = 0
    qY2 = 0
    partialScrnUpdate = False

    queueTxData = ""

    lastMouseButton = 0
    mouseState = 0

    connecting = False
    disconnecting = False

    defaultClickWav = ""
    defaultBeepWav = ""

End Sub

Sub InsertChar (ByVal byte As Integer)
    Static fieldH%, fieldV%
    Dim headChar$, tailChar$, headAttr$, tailAttr$, headColor$, tailColor$, i%, j%

    Select Case seqPhase
	Case 1
	    fieldH = byte + margin.left
	Case 2
	    cmdSeq = 0
	    fieldV = byte + margin.top
	    If (fieldH <= margin.right) And (fieldV <= margin.bottom) Then
		i = sdI(curY)
		If curY = fieldV Then
		    Mid(scrnData(i), curX + 1, fieldH - curX + 1) = " " & Mid(scrnData(i), curX + 1, fieldH - curX)
		    Mid(scrnAttr(i), curX + 1, fieldH - curX + 1) = Chr$(curAttr) & Mid(scrnAttr(i), curX + 1, fieldH - curX)
		    Mid(scrnColor(i), curX + 1, fieldH - curX + 1) = Chr$(curColor) & Mid(scrnColor(i), curX + 1, fieldH - curX)
		    QScreenUpdate curX, curY, fieldH, curY
		Else
		    headChar = Mid(scrnData(i), margin.right + 1, 1)
		    headAttr = Mid(scrnAttr(i), margin.right + 1, 1)
		    headColor = Mid(scrnColor(i), margin.right + 1, 1)
		    Mid(scrnData(i), curX + 1, margin.right - curX + 1) = " " & Mid(scrnData(i), curX + 1, margin.right - curX)
		    Mid(scrnAttr(i), curX + 1, margin.right - curX + 1) = Chr$(curAttr) & Mid(scrnAttr(i), curX + 1, margin.right - curX)
		    Mid(scrnColor(i), curX + 1, margin.right - curX + 1) = Chr$(curColor) & Mid(scrnColor(i), curX + 1, margin.right - curX)
		    For j = curY + 1 To fieldV
			i = sdI(j)
			If i = fieldV Then
			    Mid(scrnData(i), margin.left + 1, fieldH - margin.left + 1) = headChar & Mid(scrnData(i), margin.left + 1, fieldH - margin.left)
			    Mid(scrnAttr(i), margin.left + 1, fieldH - margin.left + 1) = headAttr & Mid(scrnAttr(i), margin.left + 1, fieldH - margin.left)
			    Mid(scrnColor(i), margin.left + 1, fieldH - margin.left + 1) = headColor & Mid(scrnColor(i), margin.left + 1, fieldH - margin.left)
			Else
			    tailChar = Mid(scrnData(i), margin.right + 1, 1)
			    tailAttr = Mid(scrnAttr(i), margin.right + 1, 1)
			    tailColor = Mid(scrnColor(i), margin.right + 1, 1)
			    Mid(scrnData(i), margin.left + 1, windowWidth) = headChar & Mid(scrnData(i), margin.left + 1, margin.right - margin.left)
			    Mid(scrnAttr(i), margin.left + 1, windowWidth) = headAttr & Mid(scrnAttr(i), margin.left + 1, margin.right - margin.left)
			    Mid(scrnColor(i), margin.left + 1, windowWidth) = headColor & Mid(scrnColor(i), margin.left + 1, margin.right - margin.left)
			    headChar = tailChar
			    headAttr = tailAttr
			    headColor = tailColor
			End If
		    Next j
		    QScreenUpdate margin.left, curY, margin.right, fieldV
		End If
	    End If
	End Select

    seqPhase = seqPhase + 1

End Sub

Sub LoadFromFile (iniFile$)
    Dim pLen%, pStr As String * 256

    curCommPort = GetPrivateProfileInt(Key_Async, Appl_CommPort, 2, iniFile)

    curHandShake = GetPrivateProfileInt(Key_Async, Appl_HandShake, 2, iniFile)
    If (curHandShake > 2) Or (curHandShake < 0) Then
	curHandShake = 0
    End If

    pLen = GetPrivateProfileString(Key_Async, Appl_BaudRate, "9600", pStr, 6, iniFile)
    curBaudRate = Left(pStr, pLen)

    pLen = GetPrivateProfileString(Key_Async, Appl_Parity, "N", pStr, 2, iniFile)
    curParity = Left(pStr, pLen)

    pLen = GetPrivateProfileString(Key_Async, Appl_Databits, "8", pStr, 2, iniFile)
    curDataBits = Left(pStr, pLen)

    pLen = GetPrivateProfileString(Key_Async, Appl_Stopbits, "1", pStr, 2, iniFile)
    curStopBits = Left(pStr, pLen)

    asyncOutBufSize = GetPrivateProfileInt(Key_Async, Appl_OutBufSize, 512, iniFile)
    asyncInBufSize = GetPrivateProfileInt(Key_Async, Appl_InBufSize, 1024, iniFile)
    asyncPollInterval = GetPrivateProfileInt(Key_Async, Appl_Interval, 100, iniFile)


    pLen = GetPrivateProfileString(Key_Pref, Appl_ForeColor, Str$(normalFgColor), pStr, 11, iniFile)
    normalFgColor = CLng(Left(pStr, pLen))

    pLen = GetPrivateProfileString(Key_Pref, Appl_BackColor, Str$(normalBgColor), pStr, 11, iniFile)
    normalBgColor = CLng(Left(pStr, pLen))
    
    pLen = GetPrivateProfileString(Key_Pref, Appl_HiColor, Str$(normalHiColor), pStr, 11, iniFile)
    normalHiColor = CLng(Left(pStr, pLen))
    
    pLen = GetPrivateProfileString(Key_Pref, Appl_CursorColor, Str$(cursorColor), pStr, 11, iniFile)
    cursorColor = CLng(Left(pStr, pLen))

    pLen = GetPrivateProfileString(Key_Pref, Appl_SelTxtFgColor, Str$(selTextFgColor), pStr, 11, iniFile)
    selTextFgColor = CLng(Left(pStr, pLen))
					       
    pLen = GetPrivateProfileString(Key_Pref, Appl_SelTxtBgColor, Str$(selTextBgColor), pStr, 11, iniFile)
    selTextBgColor = CLng(Left(pStr, pLen))
					       
					       
    pLen = GetPrivateProfileString(Key_Pref, Appl_Font, "Terminal", pStr, 30, iniFile)
    Scrn.FontName = Left(pStr, pLen)

    Scrn.FontSize = GetPrivateProfileInt(Key_Pref, Appl_FontSize, 9, iniFile)

    lineSpacing = GetPrivateProfileInt(Key_Pref, Appl_LineSpacing, 0, iniFile)
    If lineSpacing > 10 Then lineSpacing = 10
    If lineSpacing < 0 Then lineSpacing = 0
    lineSpacingExt = lineSpacing * Screen.TwipsPerPixelY

    cursorBlinkTimer.Interval = GetPrivateProfileInt(Key_Pref, Appl_CursorBlink, 3, iniFile) * 100
    If cursorBlinkTimer.Interval > 1000 Then cursorBlinkTimer.Interval = 1000

    rollStyle = GetPrivateProfileInt(Key_Pref, Appl_RollStyle, BUFFERED, iniFile)
    MPrefRollBuffered.Checked = False
    MPrefRollImmediate.Checked = False
    MPrefRollSmart.Checked = False
    Select Case rollStyle
	Case IMMEDIATE
	    MPrefRollImmediate.Checked = True
	Case BUFFERED
	    MPrefRollBuffered.Checked = True
	Case Else
	    rollStyle = SMART
	    MPrefRollSmart.Checked = True
    End Select


    mouseStyle = GetPrivateProfileInt(Key_Pref, Appl_MouseStyle, MouseMenu, iniFile)
    
    
    ' The following commented code causes a General Protection Fault in GDI
    dPrtFontName = "Courier"
    pLen = GetPrivateProfileString(Key_Pref, Appl_PrtFontName, dPrtFontName, pStr, 30, iniFile)
    prtFontName = Left(pStr, pLen)
    'Printer.FontName = Left(pStr, pLen)
    dPrtFontSize = 12
    'Printer.FontSize = GetPrivateProfileInt(Key_Pref, Appl_PrtFontSize, dPrtFontSize, iniFile)
    prtFontSize = GetPrivateProfileInt(Key_Pref, Appl_PrtFontSize, dPrtFontSize, iniFile)


    pLen = GetPrivateProfileString(Key_Notes, Appl_CurrentIni, "", pStr, 255, iniFile)
    curIniFilename = Left(pStr, pLen)

    curConnectType = GetPrivateProfileInt(Key_Notes, Appl_ConnectType, CT_Async, iniFile)
    connectAtStartup = GetPrivateProfileInt(Key_Notes, Appl_AutoConnect, False, iniFile)

    initTop = GetPrivateProfileInt(Key_Notes, Appl_Top, 0, iniFile)
    initLeft = GetPrivateProfileInt(Key_Notes, Appl_Left, 0, iniFile)
    initWidth = GetPrivateProfileInt(Key_Notes, Appl_Width, 0, iniFile)
    initHeight = GetPrivateProfileInt(Key_Notes, Appl_Height, 0, iniFile)

    
    Scrn.BackColor = normalBgColor
    Scrn.ForeColor = normalFgColor
    ' Specifying COLOR_SCROLLBAR caused "invalid property" on Compaq's
    If GetSysColor(COLOR_SCROLLBAR) > &HFFFFFF Then
	FMain.BackColor = QBColor(G_LIGHT_GRAY)
    Else
	FMain.BackColor = GetSysColor(COLOR_SCROLLBAR)
    End If


    pixelHeight = (Scrn.TextHeight("M") / Screen.TwipsPerPixelY) + lineSpacing
    pixelWidth = Scrn.TextWidth("M") / Screen.TwipsPerPixelX
    
    If initHeight = 0 Then
	initHeight = (MaxRow + 1) * Scrn.TextHeight("M") + lineSpacingExt + StatusBar.Height + sidesTB + HScrollBar.Height '+ 30'25
    End If
    If initWidth = 0 Then
	initWidth = CharsPerRow * Scrn.TextWidth("M") + sidesLR + VScrollBar.Width '+ 30'25
    End If
    FMain.Move initLeft, initTop, initWidth, initHeight
    VScrollBar.Value = VScrollBar.Max

End Sub

Sub MColorSelTextBg_Click ()
    Dim rv%

    FMain.CMDialog1.DialogTitle = "Selected Text Background Color"
    FMain.CMDialog1.Color = selTextBgColor
    FMain.CMDialog1.Flags = CC_RGBINIT
    CMDialog1.CancelError = False
    FMain.CMDialog1.Action = 3

    selTextBgColor = FMain.CMDialog1.Color
    rv = WritePrivateProfileString(Key_Pref, Appl_SelTxtBgColor, Str$(selTextBgColor), DefaultINI)

End Sub

Sub MColorSelTextFg_Click ()
    Dim rv%

    FMain.CMDialog1.DialogTitle = "Selected Text Foreground Color"
    FMain.CMDialog1.Color = selTextFgColor
    FMain.CMDialog1.Flags = CC_RGBINIT
    CMDialog1.CancelError = False
    FMain.CMDialog1.Action = 3

    selTextFgColor = FMain.CMDialog1.Color
    rv = WritePrivateProfileString(Key_Pref, Appl_SelTxtFgColor, Str$(selTextFgColor), DefaultINI)

End Sub

Sub MEdit_Click ()

    MEditPaste.Enabled = Clipboard.GetFormat(CF_TEXT)
    MEditCopyAppend.Enabled = MEditPaste.Enabled And MEditCopy.Enabled
    MEditUnselect.Enabled = MEditCopy.Enabled

End Sub

Sub MEditCopy_Click ()
    Dim rowIndex%, lineLen%, s$

    lineLen = selTextLastCol - selTextCol1 + 1
    s = Mid(scrnData(sdI(selTextRow1)), selTextCol1 + 1, lineLen) & Chr$(13) & Chr$(10)
    For rowIndex = selTextRow1 + 1 To selTextLastRow
	s = s & Mid(scrnData(sdI(rowIndex)), selTextCol1 + 1, lineLen) & Chr$(13) & Chr$(10)
    Next rowIndex
    Clipboard.SetText s

    ReDisplayScreen selTextCol1, selTextRow1, selTextLastCol, selTextLastRow
    MEditCopy.Enabled = False
    textSelected = False

End Sub

Sub MEditCopyAppend_Click ()
    Dim rowIndex%, lineLen%, s$

    s = Clipboard.GetText(CF_TEXT)   ' Get current Clipboard text

    lineLen = selTextLastCol - selTextCol1 + 1
    s = s & Mid(scrnData(sdI(selTextRow1)), selTextCol1 + 1, lineLen) & Chr$(13) & Chr$(10)
    For rowIndex = selTextRow1 + 1 To selTextLastRow
	s = s & Mid(scrnData(sdI(rowIndex)), selTextCol1 + 1, lineLen) & Chr$(13) & Chr$(10)
    Next rowIndex
    Clipboard.SetText s

    ReDisplayScreen selTextCol1, selTextRow1, selTextLastCol, selTextLastRow
    MEditCopy.Enabled = False
    textSelected = False

End Sub

Sub MEditPaste_Click ()

    If TPaste.Enabled Then
	TPaste.Enabled = False
    Else
	pasteStr = Clipboard.GetText(CF_TEXT)   ' Get Clipboard text
	pasteLen = Len(pasteStr)
	If pasteLen > 0 Then
	    pasteIndex = 1
	    TPaste.Interval = pasteInterval
	    TPaste.Enabled = True
	End If
    End If

End Sub

Sub MEditShowClipboard_Click ()
    Dim cbStr$

    cbStr = Clipboard.GetText(CF_TEXT) ' Get Clipboard text
    MsgBox cbStr, MB_OK, "Current Clipboard Data"

End Sub

Sub MEditUnselect_Click ()

    ReDisplayScreen selTextCol1, selTextRow1, selTextLastCol, selTextLastRow
    MEditCopy.Enabled = False
    MEditUnselect.Enabled = False
    textSelected = False

End Sub

Sub MFile_Click ()

    MFileLoad.Enabled = MSessionConnect.Enabled

End Sub

Sub MFileExit_Click ()

    Unload FMain

End Sub

Sub MFileLoad_Click ()
    Dim rv%, fileToLoad$

    CMDialog1.Filename = curIniFilename
    CMDialog1.Filter = "WSPRTERM files (*.wtw) | *.wtw | All files (*.*) | *.*"
    CMDialog1.FilterIndex = 1
    CMDialog1.DefaultExt = "wtw"
    CMDialog1.Flags = OFN_HIDEREADONLY
    CMDialog1.CancelError = True

    On Error GoTo LoadCancelled
    CMDialog1.Action = 1            ' Open...

    If CMDialog1.Filename <> "" Then
	fileToLoad = CMDialog1.Filename
	FMain.Hide
	LoadFromFile fileToLoad
	curIniFilename = fileToLoad
	SaveToFile DefaultINI
	rv = WritePrivateProfileString(Key_Notes, Appl_CurrentIni, curIniFilename, DefaultINI)
	FMain.Show
	FMain.Refresh
	Form_Activate
    End If

    Exit Sub

LoadCancelled:
    Exit Sub

End Sub

Sub MFilePrintScreen_Click ()
    Dim row%, rowIndex%, col%, attr%, start%, count%

    On Error GoTo prtScrError

    ShowStatus "Printing screen...", False
    attr = ANormal
    Printer.FontBold = False
    Printer.FontUnderline = False
    Printer.FontName = prtFontName
    Printer.FontSize = prtFontSize

    For rowIndex = visibleArea.top To visibleArea.bottom
	row = sdI(rowIndex)
	start = 1

	count = 0
	For col = 1 To CharsPerRow
	    If attr = Asc(Mid(scrnAttr(row), col, 1)) Then
		count = count + 1
	    Else
		attr = Asc(Mid(scrnAttr(row), col, 1))
		Printer.Print Mid(scrnData(row), start, count);
		count = 1
		start = col
		Printer.FontBold = ((attr And ABold) <> 0)
		Printer.FontUnderline = ((attr And AUnderline) <> 0)
	    End If
	Next col
	Printer.Print Mid(scrnData(row), start, count)
    Next rowIndex

    Printer.FontBold = False
    Printer.FontUnderline = False
    Printer.EndDoc
    ShowStatus "Print screen completed.", False
    Exit Sub


prtScrError:
    ShowStatus "Printer Error", True
    Exit Sub

End Sub

Sub MFileRefresh_Click ()

    If (curAttr And ASysColors) = 0 Then
	Scrn.BackColor = QBColor((curColor And CBgColorMask) \ Shift4)
    End If
    ReDisplayScreen 0, MinRow, MaxColumn, MaxRow

End Sub

Sub MFileSave_Click ()
    Dim rv%

    CMDialog1.Filename = curIniFilename
    CMDialog1.Filter = "WSPRTERM files (*.wtw) | *.wtw | All files (*.*) | *.*"
    CMDialog1.FilterIndex = 1
    CMDialog1.DefaultExt = "wtw"
    CMDialog1.Flags = OFN_HIDEREADONLY Or OFN_OVERWRITEPROMPT Or OFN_PATHMUSTEXIST
    CMDialog1.CancelError = True

    On Error GoTo SaveCancelled
    CMDialog1.Action = 2            ' SaveAs...

    If CMDialog1.Filename <> "" Then
	curIniFilename = CMDialog1.Filename
	If FMain.WindowState = NORMAL Then
	    initLeft = FMain.left
	    initTop = FMain.top
	    initWidth = FMain.Width
	    initHeight = FMain.Height
	End If
	SaveToFile curIniFilename
	rv = WritePrivateProfileString(Key_Notes, Appl_CurrentIni, curIniFilename, DefaultINI)
    End If

    Exit Sub

SaveCancelled:
    Exit Sub

End Sub

Sub MFileScrCaptureBegin_Click ()

    If MFileScrCaptureBegin.Enabled Then
	localCaptureLine = ""
	localCapture = True
	Printer.FontBold = ((curAttr And ABold) <> 0)
	Printer.FontUnderline = ((curAttr And AUnderline) <> 0)
	Printer.FontName = prtFontName
	Printer.FontSize = prtFontSize
	MFileScrCaptureBegin.Enabled = False
	MFileScrCaptureBegin.Visible = False
	MFileScrCaptureEnd.Enabled = True
	MFileScrCaptureEnd.Visible = True
	MFilePrintScreen.Enabled = False
	ShowStatus "Screen Capture On", False
    End If

End Sub

Sub MFileScrCaptureEnd_Click ()

    If MFileScrCaptureEnd.Enabled Then
	FlushCapturedLine
	localCapture = False
	MFileScrCaptureBegin.Enabled = True
	MFileScrCaptureBegin.Visible = True
	MFileScrCaptureEnd.Enabled = False
	MFileScrCaptureEnd.Visible = False
	MFilePrintScreen.Enabled = True
	Printer.EndDoc
	ShowStatus "Screen Capture Off", False
    End If

End Sub

Sub MHelpAbout_Click ()

    FAbout.Show 1

End Sub

Sub MMouse_Click ()
    
    MMouseMenu.Checked = False
    MMouseEditor.Checked = False
    MMouseOff.Checked = False
    Select Case mouseStyle
	Case MouseMenu
	    MMouseMenu.Checked = True
	Case MouseEditor
	    MMouseEditor.Checked = True
	Case MouseOff
	    MMouseOff.Checked = True
    End Select
    
End Sub

Sub MMouseEditor_Click ()

    mouseStyle = MouseEditor
    Scrn.MousePointer = IBEAM

End Sub

Sub MMouseMenu_Click ()

    mouseStyle = MouseMenu
    Scrn.MousePointer = DEFAULT

End Sub

Sub MMouseOff_Click ()

    mouseStyle = MouseOff
    Scrn.MousePointer = NO_DROP

    If textSelected Then MEditUnselect_Click

End Sub

Sub MoveCursor (ByVal xVal%, ByVal yVal%)

    If Not partialScrnUpdate Then
	Scrn.CurrentX = Scrn.TextWidth(Left(scrnData(sdI(yVal)), xVal))
	Scrn.CurrentY = yPos(yVal)
    End If

End Sub

Sub MPrefColorBg_Click ()
    Dim rv%

    FMain.CMDialog1.DialogTitle = "Background Color"
    FMain.CMDialog1.Color = normalBgColor
    FMain.CMDialog1.Flags = CC_RGBINIT
    CMDialog1.CancelError = False
    FMain.CMDialog1.Action = 3

    normalBgColor = FMain.CMDialog1.Color
    rv = WritePrivateProfileString(Key_Pref, Appl_BackColor, Str$(normalBgColor), DefaultINI)
    
    Scrn.BackColor = normalBgColor
    curAttr = curAttr Or ASysColors
    ReDisplayScreen 0, MinRow, MaxColumn, MaxRow

End Sub

Sub MPrefColorCursor_Click ()
    Dim rv%

    FMain.CMDialog1.DialogTitle = "Cursor Color"
    FMain.CMDialog1.Color = cursorColor
    FMain.CMDialog1.Flags = CC_RGBINIT
    CMDialog1.CancelError = False
    FMain.CMDialog1.Action = 3

    cursorColor = FMain.CMDialog1.Color
    rv = WritePrivateProfileString(Key_Pref, Appl_CursorColor, Str$(cursorColor), DefaultINI)
    
    If textCursorOn Then SetCursorOn

End Sub

Sub MPrefColorFg_Click ()
    Dim rv%

    FMain.CMDialog1.DialogTitle = "Foreground (text) Color"
    FMain.CMDialog1.Color = normalFgColor
    FMain.CMDialog1.Flags = CC_RGBINIT
    CMDialog1.CancelError = False
    FMain.CMDialog1.Action = 3

    normalFgColor = FMain.CMDialog1.Color
    rv = WritePrivateProfileString(Key_Pref, Appl_ForeColor, Str$(normalFgColor), DefaultINI)
    
    Scrn.ForeColor = normalFgColor
    curAttr = curAttr Or ASysColors
    ReDisplayScreen 0, MinRow, MaxColumn, MaxRow

End Sub

Sub MPrefColorHi_Click ()
    Dim rv%

    FMain.CMDialog1.DialogTitle = "Highlight Color"
    FMain.CMDialog1.Color = normalHiColor
    FMain.CMDialog1.Flags = CC_RGBINIT
    CMDialog1.CancelError = False
    FMain.CMDialog1.Action = 3

    normalHiColor = FMain.CMDialog1.Color
    rv = WritePrivateProfileString(Key_Pref, Appl_HiColor, Str$(normalHiColor), DefaultINI)
    
    ReDisplayScreen 0, MinRow, MaxColumn, MaxRow

End Sub

Sub MPrefCursorBlink_Click ()

    FCursorBlink.Show 1
    If textCursorOn Then SetCursorOn

End Sub

Sub MPrefFontPrinter_Click ()
    Dim rv%

    Printer.FontName = prtFontName
    Printer.FontSize = prtFontSize

    FMain.CMDialog1.FontName = Printer.FontName
    FMain.CMDialog1.FontSize = Printer.FontSize
    FMain.CMDialog1.Flags = CF_PRINTERFONTS Or CF_FIXEDPITCHONLY Or CF_NOSTYLESEL
    CMDialog1.CancelError = False
    FMain.CMDialog1.Action = 4

    Printer.FontName = FMain.CMDialog1.FontName
    Printer.FontSize = FMain.CMDialog1.FontSize

    prtFontName = Printer.FontName
    prtFontSize = Printer.FontSize
    
    rv = WritePrivateProfileString(Key_Pref, Appl_PrtFontName, prtFontName, DefaultINI)
    rv = WritePrivateProfileString(Key_Pref, Appl_PrtFontSize, Str$(prtFontSize), DefaultINI)

End Sub

Sub MPrefFontScreen_Click ()
    Dim newHeight%, newWidth%, rv%

    Scrn.Cls

    FMain.CMDialog1.FontName = Scrn.FontName
    FMain.CMDialog1.FontSize = Scrn.FontSize
    FMain.CMDialog1.Flags = CF_SCREENFONTS Or CF_FIXEDPITCHONLY
    CMDialog1.CancelError = False
    FMain.CMDialog1.Action = 4

    Scrn.FontName = FMain.CMDialog1.FontName
    Scrn.FontSize = FMain.CMDialog1.FontSize
    Scrn.FontBold = FMain.CMDialog1.FontBold
    Scrn.FontItalic = FMain.CMDialog1.FontItalic
    rv = WritePrivateProfileString(Key_Pref, Appl_Font, Scrn.FontName, DefaultINI)
    rv = WritePrivateProfileString(Key_Pref, Appl_FontSize, Str$(Scrn.FontSize), DefaultINI)

    pixelHeight = (Scrn.TextHeight("M") / Screen.TwipsPerPixelY) + lineSpacing
    pixelWidth = Scrn.TextWidth("M") / Screen.TwipsPerPixelX

    newHeight = (MaxRow + 1) * (Scrn.TextHeight("M") + lineSpacingExt) + StatusBar.Height + sidesTB + HScrollBar.Height
    newWidth = CharsPerRow * Scrn.TextWidth("M") + sidesLR + VScrollBar.Width
    If (FMain.WindowState = NORMAL) And ((newWidth <> FMain.Width) Or (newHeight <> FMain.Height)) Then
	FMain.Move FMain.left, FMain.top, newWidth, newHeight
    End If
    VScrollBar.Value = VScrollBar.Max

    ReDisplayScreen 0, MinRow, MaxColumn, MaxRow

End Sub

Sub MPrefLineSpacing_Click ()

    FLineSpacing.Show 1

End Sub

Sub MPrefRollBuffered_Click ()
    Dim rv%

    rollStyle = BUFFERED
    rv = WritePrivateProfileString(Key_Pref, Appl_RollStyle, Str$(rollStyle), DefaultINI)

End Sub

Sub MPrefRollImmediate_Click ()
    Dim rv%

    rollStyle = IMMEDIATE
    rv = WritePrivateProfileString(Key_Pref, Appl_RollStyle, Str$(rollStyle), DefaultINI)

End Sub

Sub MPrefRollSmart_Click ()
    Dim rv%

    rollStyle = SMART
    rv = WritePrivateProfileString(Key_Pref, Appl_RollStyle, Str$(rollStyle), DefaultINI)

End Sub

Sub MPrefRollStyle_Click ()

    MPrefRollBuffered.Checked = False
    MPrefRollImmediate.Checked = False
    MPrefRollSmart.Checked = False
    Select Case rollStyle
	Case BUFFERED
	    MPrefRollBuffered.Checked = True
	Case IMMEDIATE
	    MPrefRollImmediate.Checked = True
	Case SMART
	    MPrefRollSmart.Checked = True
    End Select

End Sub

Sub MSession_Click ()

    MSessionAutoConnect.Checked = connectAtStartup

End Sub

Sub MSessionAsync_Click ()

    CommSettings.Show 1

End Sub

Sub MSessionAutoConnect_Click ()
    Dim rv%

    connectAtStartup = Not connectAtStartup
    rv = WritePrivateProfileString(Key_Notes, Appl_AutoConnect, Str$(connectAtStartup), DefaultINI)

End Sub

Sub MSessionConnect_Click ()

    InitVars
    ReDisplayScreen 0, MinRow, MaxColumn, MaxRow

    Select Case curConnectType

	Case CT_Async
	    CommPort.OutBufferSize = asyncOutBufSize
	    CommPort.InBufferSize = asyncInBufSize
	    CommPort.Interval = asyncPollInterval
	    CommPort.DTREnable = True
	    LedDTR.ForeColor = LedOnColor
	    CommPort.PortOpen = True
	    If CommPort.PortOpen Then
		MSessionConnect.Enabled = False
		MSessionDisconnect.Enabled = True
		CommPort.RTSEnable = True
		LedRTS.ForeColor = LedOnColor
		If CommPort.CDHolding Then
		    ShowStatus "OnLine - COM" & CommPort.CommPort & ":" & CommPort.Settings, False
		    LedCD.ForeColor = LedOnColor
		    If CommPort.CTSHolding Then
			LedCTS.ForeColor = LedOnColor
		    End If
		    If CommPort.DSRHolding Then
			LedDSR.ForeColor = LedOnColor
		    End If
		Else
		    connecting = True
		    ShowStatus "Connecting... using Async (COM" & CommPort.CommPort & ")", False
		End If
		SetCursorOn
		textCursorOn = True
		cursorBlinkTimer.Enabled = True
	    End If
	
    End Select
    
End Sub

Sub MSessionDisconnect_Click ()

    Select Case curConnectType

	Case CT_Async
	    ShowStatus "Disconnecting...", False
	    CommPort.RTSEnable = False
	    LedRTS.ForeColor = LedOffColor
	    CommPort.DTREnable = False
	    LedDTR.ForeColor = LedOffColor
	    CommPort.PortOpen = False

	    LedCTS.ForeColor = LedOffColor
	    LedDSR.ForeColor = LedOffColor
	    If CommPort.CDHolding Then
		disconnecting = True
	    Else
		ShowStatus "Disconnected", False
		LedCD.ForeColor = LedOffColor
	    End If

    End Select

    MSessionDisconnect.Enabled = False
    MSessionConnect.Enabled = True

    cursorBlinkTimer.Enabled = False
    SetCursorOff
    textCursorOn = False

End Sub

Sub OpenLine ()
    Dim i%

    cmdSeq = 0
    If curY < margin.bottom Then
	RollDown curY + 1, margin.bottom
	i = sdI(curY + 1)
	Mid(scrnData(i), curX + 1, margin.right - curX + 1) = Mid(scrnData(sdI(curY)), curX + 1, margin.right - curX + 1)
	Mid(scrnAttr(i), curX + 1, margin.right - curX + 1) = Mid(scrnAttr(sdI(curY)), curX + 1, margin.right - curX + 1)
	Mid(scrnColor(i), curX + 1, margin.right - curX + 1) = Mid(scrnColor(sdI(curY)), curX + 1, margin.right - curX + 1)
	QScreenUpdate curX, curY, margin.right, curY + 1
    End If
    EraseToEOL

End Sub

Sub Paste (s As String)

    pasteStr = s
    pasteLen = Len(pasteStr)
    If pasteLen > 0 Then
	pasteIndex = 1
	TPaste.Interval = pasteInterval
	TPaste.Enabled = True
    End If

End Sub

Sub QScreenUpdate (ByVal x1%, ByVal y1%, ByVal x2%, ByVal y2%)

    partialScrnUpdate = True
    If x1 < qX1 Then qX1 = x1
    If y1 < qY1 Then qY1 = y1
    If x2 > qX2 Then qX2 = x2
    If y2 > qY2 Then qY2 = y2

End Sub

Sub ReDisplayScreen (ByVal x1%, ByVal y1%, ByVal x2%, ByVal y2%)
    Dim i%, j%, Y%, attr%, Color%, start%, count%, lineLen%, matches%, remain%

    If y1 < visibleArea.top Then y1 = visibleArea.top
    If y2 > visibleArea.bottom Then y2 = visibleArea.bottom

    partialScrnUpdate = False
    attr = curAttr
    Color = curColor

    lineLen = x2 - x1 + 1
	
    For i = y2 To y1 Step -1
	MoveCursor x1, i
	Y = sdI(i)
	start = x1 + 1
	remain = lineLen
	Do While (remain > 0)
	    matches = MatchCount(Mid(scrnAttr(Y), start, remain), Mid(scrnColor(Y), start, remain), Chr$(attr), Chr$(Color), remain)
	    Scrn.Print Mid(scrnData(Y), start, matches);
		
	    remain = remain - matches
	    If remain > 0 Then
		start = start + matches
		attr = Asc(Mid(scrnAttr(Y), start, 1))
		Color = Asc(Mid(scrnColor(Y), start, 1))
		SetAttributes attr, Color
	    End If
	Loop
    Next i

    If visibleArea.bottom < margin.bottom Then
	qY1 = visibleArea.bottom
    Else
	qY1 = margin.bottom
    End If

    qX2 = 0
    If visibleArea.top > margin.top Then
	qY2 = visibleArea.top
    Else
	qY2 = 0
    End If

    SetAttributes curAttr, curColor
    MoveCursor curX, curY
    If textCursorOn Then SetCursorOn

End Sub

Sub ResetMargins ()
    Dim dummyInt%

    If rollCnt <> 0 Then
	rollCnt = 0
	QScreenUpdate margin.left, margin.top, margin.right, margin.bottom
    End If

    margin.top = LiveMinRow
    margin.bottom = LiveMaxRow
    margin.left = LiveMinCol
    margin.right = LiveMaxCol

    windowWidth = CharsPerRow

    SetClipRegion

End Sub

Sub RollDown (ByVal topLine As Integer, ByVal bottomLine As Integer)
    Dim i%, j%, temp%, dummyInt%

    If (margin.left = 0) And (margin.right = MaxColumn) Then
	temp = sdI(bottomLine)
	For i = bottomLine To topLine + 1 Step -1
	    sdI(i) = sdI(i - 1)
	Next i
	sdI(topLine) = temp
	scrnData(temp) = blankLine
	scrnAttr(temp) = String(CharsPerRow, curAttr)
	scrnColor(temp) = String(CharsPerRow, curColor)
    Else
	For j = bottomLine To topLine + 1 Step -1
	    i = sdI(j)
	    Mid(scrnData(i), margin.left + 1, windowWidth) = Mid(scrnData(sdI(j - 1)), margin.left + 1, windowWidth)
	    Mid(scrnAttr(i), margin.left + 1, windowWidth) = Mid(scrnAttr(sdI(j - 1)), margin.left + 1, windowWidth)
	    Mid(scrnColor(i), margin.left + 1, windowWidth) = Mid(scrnColor(sdI(j - 1)), margin.left + 1, windowWidth)
	Next j
	Mid(scrnData(sdI(topLine)), margin.left + 1, windowWidth) = Left(blankLine, windowWidth)
	Mid(scrnAttr(sdI(topLine)), margin.left + 1, windowWidth) = String(windowWidth, curAttr)
	Mid(scrnColor(sdI(topLine)), margin.left + 1, windowWidth) = String(windowWidth, curColor)
    End If

    Select Case rollStyle
	Case BUFFERED
	    QScreenUpdate margin.left, topLine, margin.right, bottomLine
	Case IMMEDIATE
	    If topLine = margin.top Then
		dummyInt = ScrollDC(Scrn.hDC, 0, pixelHeight, lprcScroll, liveClip, hRgnUpdate, lprcUpdate)
		QScreenUpdate margin.left, topLine, margin.right, qY2 + 1
	    Else
		QScreenUpdate margin.left, topLine, margin.right, bottomLine
	    End If
	Case SMART
	    If topLine = margin.top Then
		If rollCnt <= 0 Then
		    QScreenUpdate margin.left, topLine, margin.right, qY2 + 1
		End If
		rollCnt = rollCnt - 1
	    Else
		If rollCnt = 0 Then
		    QScreenUpdate margin.left, topLine, margin.right, bottomLine
		Else
		    rollCnt = 0
		    QScreenUpdate margin.left, margin.top, margin.right, margin.bottom
		End If
	    End If
    End Select

End Sub

Sub RollUp (ByVal topLine As Integer, ByVal bottomLine As Integer)
    Dim i%, j%, temp%, dummyInt%

    If (margin.left = 0) And (margin.right = MaxColumn) Then
	If topLine = 0 Then topLine = MinRow
	temp = sdI(topLine)
	For i = topLine + 1 To bottomLine
	    sdI(i - 1) = sdI(i)
	Next i
	sdI(bottomLine) = temp
	scrnData(temp) = blankLine
	scrnAttr(temp) = String(CharsPerRow, curAttr)
	scrnColor(temp) = String(CharsPerRow, curColor)
    Else
	For j = topLine + 1 To bottomLine
	    i = sdI(j - 1)
	    Mid(scrnData(i), margin.left + 1, windowWidth) = Mid(scrnData(sdI(j)), margin.left + 1, windowWidth)
	    Mid(scrnAttr(i), margin.left + 1, windowWidth) = Mid(scrnAttr(sdI(j)), margin.left + 1, windowWidth)
	    Mid(scrnColor(i), margin.left + 1, windowWidth) = Mid(scrnColor(sdI(j)), margin.left + 1, windowWidth)
	Next j
	Mid(scrnData(sdI(bottomLine)), margin.left + 1, windowWidth) = Left(blankLine, windowWidth)
	Mid(scrnAttr(sdI(bottomLine)), margin.left + 1, windowWidth) = String(windowWidth, curAttr)
	Mid(scrnColor(sdI(bottomLine)), margin.left + 1, windowWidth) = String(windowWidth, curColor)
    End If

    Select Case rollStyle
	Case BUFFERED
	    QScreenUpdate margin.left, topLine, margin.right, bottomLine
	Case IMMEDIATE
	    If (topLine = MinRow) Or (topLine = margin.top) Then
		dummyInt = ScrollDC(Scrn.hDC, 0, -pixelHeight, lprcScroll, fullClip, hRgnUpdate, lprcUpdate)
		QScreenUpdate margin.left, qY1 - 1, margin.right, bottomLine
	    Else
		QScreenUpdate margin.left, topLine, margin.right, bottomLine
	    End If
	Case SMART
	    If (topLine = MinRow) Or (topLine = margin.top) Then
		If rollCnt >= 0 Then
		    QScreenUpdate margin.left, qY1 - 1, margin.right, bottomLine
		End If
		rollCnt = rollCnt + 1
	    Else
		If rollCnt = 0 Then
		    QScreenUpdate margin.left, topLine, margin.right, bottomLine
		Else
		    rollCnt = 0
		    QScreenUpdate margin.left, margin.top, margin.right, margin.bottom
		End If
	    End If
    End Select

End Sub

Sub SaveToFile (iniFile$)
    Dim rv%

    rv = WritePrivateProfileString(Key_Async, Appl_CommPort, Str$(curCommPort), iniFile)
    rv = WritePrivateProfileString(Key_Async, Appl_HandShake, Str$(curHandShake), iniFile)
    rv = WritePrivateProfileString(Key_Async, Appl_BaudRate, curBaudRate, iniFile)
    rv = WritePrivateProfileString(Key_Async, Appl_Parity, curParity, iniFile)
    rv = WritePrivateProfileString(Key_Async, Appl_Databits, curDataBits, iniFile)
    rv = WritePrivateProfileString(Key_Async, Appl_Stopbits, curStopBits, iniFile)
    rv = WritePrivateProfileString(Key_Async, Appl_OutBufSize, Str$(asyncOutBufSize), iniFile)
    rv = WritePrivateProfileString(Key_Async, Appl_InBufSize, Str$(asyncInBufSize), iniFile)
    rv = WritePrivateProfileString(Key_Async, Appl_Interval, Str$(asyncPollInterval), iniFile)

    rv = WritePrivateProfileString(Key_Pref, Appl_ForeColor, Str$(normalFgColor), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_BackColor, Str$(normalBgColor), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_HiColor, Str$(normalHiColor), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_CursorColor, Str$(cursorColor), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_SelTxtFgColor, Str$(selTextFgColor), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_SelTxtBgColor, Str$(selTextBgColor), iniFile)

    rv = WritePrivateProfileString(Key_Pref, Appl_Font, Scrn.FontName, iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_FontSize, Str$(Scrn.FontSize), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_LineSpacing, Str$(lineSpacing), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_CursorBlink, Str$(cursorBlinkTimer.Interval \ 100), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_RollStyle, Str$(rollStyle), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_MouseStyle, Str$(mouseStyle), iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_PrtFontName, prtFontName, iniFile)
    rv = WritePrivateProfileString(Key_Pref, Appl_PrtFontSize, Str$(prtFontSize), iniFile)

    rv = WritePrivateProfileString(Key_Notes, Appl_ConnectType, Str$(curConnectType), iniFile)
    rv = WritePrivateProfileString(Key_Notes, Appl_AutoConnect, Str$(connectAtStartup), iniFile)
    rv = WritePrivateProfileString(Key_Notes, Appl_Top, Str$(initTop), iniFile)
    rv = WritePrivateProfileString(Key_Notes, Appl_Left, Str$(initLeft), iniFile)
    rv = WritePrivateProfileString(Key_Notes, Appl_Width, Str$(initWidth), iniFile)
    rv = WritePrivateProfileString(Key_Notes, Appl_Height, Str$(initHeight), iniFile)

End Sub

Sub Scrn_Click ()
    Dim row%, col%, i%, chCode%, xDir%, yDir%, keys$, rowCnt%, colCnt%

    If lastMouseButton = LEFT_BUTTON Then

	row = mouseUpY \ (Scrn.TextHeight("M") + lineSpacingExt) + MinRow
	If row < 0 Then
	    row = 0
	ElseIf row > MaxRow Then
	    row = MaxRow
	End If
	rowCnt = Abs(curY - row)
	col = mouseUpX \ Scrn.TextWidth("M")
	If col > MaxColumn Then col = MaxColumn
	colCnt = Abs(curX - col)
    
	If (row = selTextRow1) And (col = selTextCol1) Then
	
	    Select Case mouseStyle
    
		Case MouseMenu
		    chCode = FindUpperCaseChar()
		    If chCode <> 0 Then
			SendString Chr$(chCode)
		    End If
    
		Case MouseEditor
		    If row > curY Then yDir = KEY_DOWN Else yDir = KEY_UP
		    If col > curX Then xDir = KEY_RIGHT Else xDir = KEY_LEFT
		    keys = String(rowCnt, Chr$(yDir))
		    keys = keys & String(colCnt, Chr$(xDir))
		    SendString keys
    
	    End Select
    
	End If

    End If

End Sub

Sub Scrn_DblClick ()

    If lastMouseButton = LEFT_BUTTON Then
	Select Case mouseStyle
	    Case MouseMenu
		SendString Chr$(KEY_RETURN)
	    Case MouseEditor
	End Select
    End If

End Sub

Sub Scrn_GotFocus ()

    If connectAtStartup And MSessionConnect.Enabled Then
	MSessionConnect_Click
    End If

    Do
	DoEvents
	If LedRX.ForeColor = LedOnColor Then
	    LedRX.ForeColor = LedOffColor
	End If
    Loop

End Sub

Sub Scrn_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    
    mouseState = mouseState Or Button
    If mouseState = (LEFT_BUTTON Or RIGHT_BUTTON) Then
	Button = MIDDLE_BUTTON
    End If
    lastMouseButton = Button

    If mouseStyle <> MouseOff Then

	If X < 0 Then mouseDwnX = 0 Else mouseDwnX = X
	If Y < 0 Then mouseDwnY = 0 Else mouseDwnY = Y

	If Button = LEFT_BUTTON Then

	    If MEditCopy.Enabled Then MEditUnselect_Click
	    selTextRow1 = mouseDwnY \ (Scrn.TextHeight("M") + lineSpacingExt) + MinRow
	    If selTextRow1 < MinRow Then
		selTextRow1 = MinRow
	    ElseIf selTextRow1 > MaxRow Then
		selTextRow1 = MaxRow
	    End If
	    selTextLastRow = selTextRow1

	    selTextCol1 = mouseDwnX \ Scrn.TextWidth("M")
	    If selTextCol1 > MaxColumn Then selTextCol1 = MaxColumn
	    selTextLastCol = selTextCol1

	End If

    End If

End Sub

Sub Scrn_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim row2%, col2%, deltaX%, deltaY%, rowIndex%
    Dim savedBgColor&, savedFgColor&, dummyColor&

    If (mouseStyle <> MouseOff) And (Button = LEFT_BUTTON) Then
	row2 = Y \ (Scrn.TextHeight("M") + lineSpacingExt) + MinRow
	If row2 < MinRow Then
	    row2 = MinRow
	ElseIf row2 > MaxRow Then
	    row2 = MaxRow
	End If
	If row2 < selTextRow1 Then selTextRow1 = row2

	col2 = X \ Scrn.TextWidth("M")
	If col2 < 0 Then
	    col2 = 0
	ElseIf col2 > MaxColumn Then
	    col2 = MaxColumn
	End If
	If col2 < selTextCol1 Then selTextCol1 = col2

	If (row2 <> selTextLastRow) Or (col2 <> selTextLastCol) Then
	    MEditCopy.Enabled = True
	    textSelected = True
	    savedBgColor = SetBkColor(Scrn.hDC, selTextBgColor)
	    savedFgColor = SetTextColor(Scrn.hDC, selTextFgColor)
	    If col2 > selTextLastCol Then
		deltaX = col2 - selTextLastCol + 1
		For rowIndex = selTextRow1 To row2
		    MoveCursor selTextLastCol, rowIndex
		    Scrn.Print Mid(scrnData(sdI(rowIndex)), selTextLastCol + 1, deltaX);
		Next rowIndex
		selTextLastCol = col2
	    ElseIf col2 < selTextLastCol Then
		dummyColor = SetBkColor(Scrn.hDC, savedBgColor)
		dummyColor = SetTextColor(Scrn.hDC, savedFgColor)
		ReDisplayScreen col2 + 1, selTextRow1, selTextLastCol, selTextLastRow
		dummyColor = SetBkColor(Scrn.hDC, selTextBgColor)
		dummyColor = SetTextColor(Scrn.hDC, selTextFgColor)
		selTextLastCol = col2
	    End If
	    If row2 > selTextLastRow Then
		deltaX = Abs(col2 - selTextCol1) + 1
		For rowIndex = selTextLastRow To row2
		    MoveCursor selTextCol1, rowIndex
		    Scrn.Print Mid(scrnData(sdI(rowIndex)), selTextCol1 + 1, deltaX);
		Next rowIndex
		selTextLastRow = row2
	    ElseIf row2 < selTextLastRow Then
		dummyColor = SetBkColor(Scrn.hDC, savedBgColor)
		dummyColor = SetTextColor(Scrn.hDC, savedFgColor)
		ReDisplayScreen selTextCol1, row2 + 1, selTextLastCol, selTextLastRow
		dummyColor = SetBkColor(Scrn.hDC, selTextBgColor)
		dummyColor = SetTextColor(Scrn.hDC, selTextFgColor)
		selTextLastRow = row2
	    End If
	    dummyColor = SetBkColor(Scrn.hDC, savedBgColor)
	    dummyColor = SetTextColor(Scrn.hDC, savedFgColor)
	    MoveCursor curX, curY
	End If
    End If

End Sub

Sub Scrn_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)

    If (mouseState And Button) <> 0 Then
	mouseState = mouseState Xor Button
    End If
    If lastMouseButton = MIDDLE_BUTTON Then
	If mouseState = 0 Then
	    lastMouseButton = 0
	    Button = MIDDLE_BUTTON
	Else
	    Button = 0
	End If
    End If

    If mouseStyle <> MouseOff Then

	If X < 0 Then mouseUpX = 0 Else mouseUpX = X
	If Y < 0 Then mouseUpY = 0 Else mouseUpY = Y

	Select Case Button

	    Case MIDDLE_BUTTON

	    Case RIGHT_BUTTON
		Select Case mouseStyle
		    Case MouseMenu
			mouseStyle = MouseEditor
			Scrn.MousePointer = IBEAM
		    Case MouseEditor
			mouseStyle = MouseMenu
			Scrn.MousePointer = DEFAULT
		    Case Else
			mouseStyle = MouseOff
			Scrn.MousePointer = NO_DROP
		End Select

	End Select

    End If

End Sub

Sub Scrn_Paint ()

    ReDisplayScreen MinColumn, MinRow, MaxColumn, MaxRow

End Sub

Sub SendString (s As String)

    Select Case curConnectType

	Case CT_Async
	    If CommPort.PortOpen Then
		If CommPort.OutBufferCount > 0 Then
		    queueTxData = queueTxData & s
		Else
		    LedTX.ForeColor = LedOnColor
		    CommPort.Output = queueTxData & s
		    queueTxData = ""
		    If CommPort.OutBufferCount <= 1 Then
			LedTX.ForeColor = LedOffColor
		    End If
		End If
	    End If

    End Select

End Sub

Sub SetAttributes (ByVal attr%, ByVal Color%)
    Dim dummyColor&, fgColor&, newFgColor&, newBgColor&, newHiColor&

    If attr And ASysColors Then
	newFgColor = normalFgColor
	newBgColor = normalBgColor
	newHiColor = normalHiColor
    Else
	newFgColor = QBColor(Color And &H7)
	newBgColor = QBColor((Color / Shift4) And &H7)
	newHiColor = QBColor((Color And &H7) Or &H8)
    End If

    If attr And ABold Then
	fgColor = newHiColor
    Else
	fgColor = newFgColor
    End If
    If attr And AInverse Then
	dummyColor = SetTextColor(Scrn.hDC, newBgColor)
	dummyColor = SetBkColor(Scrn.hDC, fgColor)
    Else
	dummyColor = SetTextColor(Scrn.hDC, fgColor)
	dummyColor = SetBkColor(Scrn.hDC, newBgColor)
    End If
    If attr And AUnderline Then
	Scrn.FontUnderline = True
    Else
	Scrn.FontUnderline = False
    End If
    If attr And ABlink Then
    End If

End Sub

Sub SetCapturedLineAttr ()

    Printer.Print localCaptureLine;
    localCaptureLine = ""
    Printer.FontBold = ((curAttr And ABold) <> 0)
    Printer.FontUnderline = ((curAttr And AUnderline) <> 0)

End Sub

Sub SetClipRegion ()
    Dim limitTop%

	lprcScroll.top = 0
	lprcScroll.left = 0
	lprcScroll.bottom = Rows * pixelHeight
	lprcScroll.right = CharsPerRow * pixelWidth

	' Calculate "live area" clip region (for roll down and scrolls)
	liveClip.top = (margin.top - MinRow) * pixelHeight
	liveClip.bottom = (margin.bottom - MinRow + 1) * pixelHeight
	liveClip.left = margin.left * pixelWidth
	liveClip.right = (margin.right + 1) * pixelWidth

	' Calculate "full (live + visible) area" clip region (for roll up)
	If (margin.top = LiveMinRow) And (visibleArea.top < LiveMinRow) Then
	    limitTop = visibleArea.top
	Else
	    limitTop = margin.top
	End If
	fullClip.top = (limitTop - MinRow) * pixelHeight
	fullClip.bottom = (margin.bottom - MinRow + 1) * pixelHeight
	fullClip.left = margin.left * pixelWidth
	fullClip.right = (margin.right + 1) * pixelWidth

End Sub

Sub SetCursorOff ()
    Dim saveX%

    saveX = Scrn.CurrentX
    SetAttributes Asc(Mid(scrnAttr(sdI(curY)), curX + 1, 1)), Asc(Mid(scrnColor(sdI(curY)), curX + 1, 1))
    Scrn.Print Mid(scrnData(sdI(curY)), curX + 1, 1);
    SetAttributes curAttr, curColor
    Scrn.CurrentX = saveX

End Sub

Sub SetCursorOn ()
    Dim saveX%, savedBgColor&, savedFgColor&, dummyColor&

    saveX = Scrn.CurrentX
    savedBgColor = SetBkColor(Scrn.hDC, cursorColor)
    savedFgColor = SetTextColor(Scrn.hDC, normalBgColor)
    Scrn.Print Mid(scrnData(sdI(curY)), curX + 1, 1);
    dummyColor = SetBkColor(Scrn.hDC, savedBgColor)
    dummyColor = SetTextColor(Scrn.hDC, savedFgColor)
    Scrn.CurrentX = saveX

End Sub

Sub SetLRMargins (ByVal byte As Integer)
    Dim dummyInt%

    Select Case seqPhase
	Case 1
	    If rollCnt <> 0 Then
		rollCnt = 0
		QScreenUpdate margin.left, margin.top, margin.right, margin.bottom
	    End If
	    margin.left = byte
	Case 2
	    cmdSeq = 0
	    margin.right = byte
	    If (margin.right > LiveMaxCol) Or (margin.left > margin.right) Then
		margin.left = 0
		margin.right = MaxColumn
	    End If
	    windowWidth = margin.right - margin.left + 1

	    SetClipRegion

	End Select

    seqPhase = seqPhase + 1

End Sub

Sub SetMargins (ByVal byte As Integer)
    Dim dummyInt%

    Select Case seqPhase
	Case 1
	    If rollCnt <> 0 Then
		rollCnt = 0
		QScreenUpdate margin.left, margin.top, margin.right, margin.bottom
	    End If
	    margin.top = byte
	Case 2
	    margin.bottom = byte
	Case 3
	    margin.left = byte
	Case 4
	    margin.right = byte
	    cmdSeq = 0
    End Select

    If cmdSeq <> 0 Then
	seqPhase = seqPhase + 1
    Else
	If (margin.bottom > MaxRow) Or (margin.top > margin.bottom) Then
	    margin.top = 0
	    margin.bottom = MaxRow
	End If
	If (margin.right > LiveMaxCol) Or (margin.left > margin.right) Then
	    margin.left = 0
	    margin.right = MaxColumn
	End If
	windowWidth = margin.right - margin.left + 1

	SetClipRegion

    End If

End Sub

Sub SetTBMargins (ByVal byte As Integer)
    Dim dummyInt%

    Select Case seqPhase
	Case 1
	    If rollCnt <> 0 Then
		rollCnt = 0
		QScreenUpdate margin.left, margin.top, margin.right, margin.bottom
	    End If
	    margin.top = byte

	Case 2
	    cmdSeq = 0
	    margin.bottom = byte
	    If (margin.bottom > MaxRow) Or (margin.top > margin.bottom) Then
		margin.top = 0
		margin.bottom = MaxRow
	    End If

	    SetClipRegion

	End Select

    seqPhase = seqPhase + 1

End Sub

Sub ShowStatus (s As String, isError As Integer)

    If isError Then
	StatusPanel.BackColor = QBColor(G_Red)
    Else
	StatusPanel.BackColor = QBColor(G_BLACK)
    End If
    StatusPanel.Caption = s

End Sub

Sub StatusPanel_Click ()

    ShowStatus "", False

End Sub

Sub TPaste_Timer ()
    Dim c$, burst%
    
    For burst = 1 To pasteBurst
	c = Mid(pasteStr, pasteIndex, 1)
	SendString c
	If pasteIndex >= pasteLen Then
	    TPaste.Enabled = False
	    Exit For
	Else
	    pasteIndex = pasteIndex + 1
	End If
    Next burst

End Sub

Sub VScrollBar_Change ()
    
    Scrn.top = -VScrollBar.Value

    visibleArea.bottom = MaxRow - (VScrollBar.Max - VScrollBar.Value) \ (Scrn.TextHeight("M") + lineSpacingExt)
    visibleArea.top = (visibleArea.bottom - (VScrollBar.Height \ (Scrn.TextHeight("M") + lineSpacingExt))) + 1
    visibleLines = visibleArea.bottom - visibleArea.top + 1
    ShowStatus visibleLines & " lines from " & Str$(visibleArea.top) & " through " & Trim$(Str$(visibleArea.bottom)) & " are visible", False
    
    SetClipRegion

End Sub

Sub VScrollBar_GotFocus ()

    Scrn.SetFocus

End Sub

