VERSION 2.00
Begin Form FLineSpacing 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Line Spacing Setup"
   ClientHeight    =   3240
   ClientLeft      =   3030
   ClientTop       =   2085
   ClientWidth     =   3300
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   3705
   Left            =   2940
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3240
   ScaleWidth      =   3300
   Top             =   1710
   Width           =   3480
   Begin VScrollBar VScroll1 
      Height          =   1320
      LargeChange     =   2
      Left            =   2520
      Max             =   10
      TabIndex        =   2
      Top             =   900
      Value           =   10
      Width           =   240
   End
   Begin PictureBox MLineSpacingSample 
      FontTransparent =   0   'False
      Height          =   1320
      Left            =   540
      ScaleHeight     =   1290
      ScaleWidth      =   1965
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   900
      Width           =   1995
   End
   Begin CommandButton CmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   1845
      TabIndex        =   1
      Top             =   2520
      Width           =   915
   End
   Begin CommandButton CmdOk 
      Caption         =   "&Ok"
      Default         =   -1  'True
      Height          =   375
      Left            =   540
      TabIndex        =   0
      Top             =   2520
      Width           =   915
   End
   Begin Label MLineSpacingValue 
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      Height          =   240
      Left            =   2790
      TabIndex        =   6
      Top             =   270
      Width           =   420
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Sample:"
      Height          =   195
      Left            =   540
      TabIndex        =   5
      Top             =   675
      Width           =   690
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Additional Line Pixel Spacing:"
      Height          =   195
      Left            =   180
      TabIndex        =   3
      Top             =   270
      Width           =   2550
   End
End
Option Explicit

Dim newLineSpacing As Integer

Sub CmdCancel_Click ()

    Unload FLineSpacing

End Sub

Sub CmdOK_Click ()
    Dim newHeight%, rv%

    If lineSpacing <> newLineSpacing Then
        FMain.Scrn.Cls
        lineSpacing = newLineSpacing
        lineSpacingExt = lineSpacing * Screen.TwipsPerPixelY
        pixelHeight = (FMain.Scrn.TextHeight("M") / Screen.TwipsPerPixelY) + lineSpacing
        pixelWidth = FMain.Scrn.TextWidth("M") / Screen.TwipsPerPixelX
        newHeight = (MaxRow + 1) * (FMain.Scrn.TextHeight("M") + lineSpacingExt) + FMain.StatusBar.Height + sidesTB + FMain.HScrollBar.Height + 25
        If FMain.WindowState = 0 Then
            FMain.Move FMain.Left, FMain.Top, FMain.Width, newHeight
        End If
        FMain.VScrollBar.Value = FMain.VScrollBar.Max
    End If
    rv = WritePrivateProfileString(Key_Pref, Appl_LineSpacing, Str$(lineSpacing), DefaultINI)

    Unload FLineSpacing

End Sub

Sub displaySample ()
    Dim i%

    MLineSpacingSample.Cls
    MLineSpacingSample.CurrentX = 0
    MLineSpacingSample.CurrentY = 0
    For i = 1 To 15
        MLineSpacingSample.CurrentY = MLineSpacingSample.CurrentY + (newLineSpacing * Screen.TwipsPerPixelY)
        MLineSpacingSample.Print "   " & Chr$(179) & " Sample Text " & Chr$(179)
    Next i

End Sub

Sub Form_Activate ()

    VScroll1.Value = VScroll1.Max - newLineSpacing
    displaySample

End Sub

Sub Form_Load ()

    CenterForm FLineSpacing

    newLineSpacing = lineSpacing
    MLineSpacingSample.FontName = FMain.Scrn.FontName
    MLineSpacingSample.FontSize = FMain.Scrn.FontSize
    MLineSpacingSample.BackColor = FMain.Scrn.BackColor
    MLineSpacingSample.ForeColor = FMain.Scrn.ForeColor
    MLineSpacingValue.Caption = Str(newLineSpacing)

End Sub

Sub VScroll1_Change ()

    newLineSpacing = VScroll1.Max - VScroll1.Value
    MLineSpacingValue.Caption = Str(newLineSpacing)
    displaySample

End Sub

Sub VScroll1_GotFocus ()

    CmdOk.SetFocus

End Sub

Sub VScroll1_Scroll ()

    newLineSpacing = VScroll1.Max - VScroll1.Value
    MLineSpacingValue.Caption = Str(newLineSpacing)
    displaySample

End Sub

