#include <windows.h>
#include <stdlib.h>
#include "resource.h"

#define MAX_HWND			32
#define IDM_QUIT			0xFFFF
#define IDM_ALWAYSONTOP	0xFFFE

// Global Variables
char 			szAppName[] = "TaskMenu";
char			szSystemIni[] = "SYSTEM.INI";
HINSTANCE   hinst;
HMENU			hmenu = NULL;
HWND			hwndTop[MAX_HWND];	
HWND			hwnd;

// functions:
long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;
void UpdateMenu();

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{  	
	MSG         msg ;
	WNDCLASS    wndclass ;
	int			Xpos, Ypos;
   
   hinst = hInstance;
	if (!hPrevInstance) 
	{
		wndclass.style         = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc   = WndProc ;
		wndclass.cbClsExtra    = 0 ;
		wndclass.cbWndExtra    = 0 ;
		wndclass.hInstance     = hInstance ;
		wndclass.hIcon         = LoadIcon (hInstance,MAKEINTRESOURCE(IDI_TARGET)) ;
		wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
		wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
		wndclass.lpszMenuName  = NULL ;
		wndclass.lpszClassName = szAppName ;

		RegisterClass (&wndclass) ;
	}

	hwnd = CreateWindow (	szAppName, 			// class
     								szAppName,			// window text
									WS_OVERLAPPEDWINDOW | WS_MINIMIZE,		// style
									CW_USEDEFAULT, CW_USEDEFAULT,		// x, y start
									CW_USEDEFAULT, CW_USEDEFAULT,		// width, height
									NULL, 			// parent window handle
									NULL, 			// menu handle
									hInstance, 		// instance handle
									NULL );			// long pointer to creation data

		// where was the last position?	
	Xpos = GetPrivateProfileInt(szAppName, "Xpos", 
								GetSystemMetrics(SM_CXFULLSCREEN) + GetSystemMetrics(SM_CXICONSPACING),
								szSystemIni );

	Ypos = GetPrivateProfileInt(szAppName, "Ypos", 
								GetSystemMetrics(SM_CYFULLSCREEN) - GetSystemMetrics(SM_CYICON)
								- GetSystemMetrics(SM_CYICONSPACING),
								szSystemIni );
   	
		// make sure it's within the bounds of the screen 
		//			(in case screen resolution has been changed)
	if (Xpos < 0 || Xpos > GetSystemMetrics(SM_CXFULLSCREEN) - 10)
		Xpos = 0;
	
	if (Ypos < 0 || Ypos > GetSystemMetrics(SM_CYFULLSCREEN) - 10)
		Ypos = 0;
	
	SetWindowPos(	hwnd, HWND_TOPMOST, 
						Xpos, Ypos, NULL, NULL,
						SWP_NOSIZE ); 
	
	ShowWindow( hwnd, SW_SHOWMINNOACTIVE);		
						
	UpdateWindow (hwnd) ;
	
	while (GetMessage (&msg, NULL, 0, 0))
	{
	TranslateMessage (&msg) ;
	DispatchMessage (&msg) ;
	}
	
	return msg.wParam ;
}


long FAR PASCAL _export WndProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
	HDC				hdc;
	PAINTSTRUCT		ps;  	
	POINT				point;	
	char				szBuffer[8];
	RECT				rect;
	HWND				hwndCur;
	     
	switch (message)
	{			
		case WM_PAINT:
			hdc = BeginPaint (hwnd, &ps) ;  
               
			EndPaint (hwnd, &ps) ;
		return 0 ;
		   					// WM_QUERYOPEN is called when an attemp is made to open the icon.
		   					// (eg., dblclks)....
		case WM_QUERYOPEN:// do not allow the window to be opened (return = 0)				
			GetCursorPos(&point);		// set up lParam so that it reflects the current pos of the mouse
			lParam = MAKELPARAM(point.x, point.y);			
								// instead.... open up the menu
		case WM_NCRBUTTONDOWN:          		      	   
      	point = MAKEPOINT(lParam); 
         UpdateMenu(NULL);
			TrackPopupMenu (hmenu, TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
               			point.x, point.y, 0, hwnd, NULL) ;
			return 0 ;                    

		case WM_COMMAND:  
			switch (wParam)
			{
				case IDM_QUIT:
					SendMessage(hwnd, WM_CLOSE, 0, 0l);	
					return 0;
				
				case IDM_ALWAYSONTOP:
					hwndCur = GetActiveWindow();
					SetWindowPos(hwnd, 
						(GetMenuState(hmenu, IDM_ALWAYSONTOP, MF_BYCOMMAND)&MF_CHECKED) ?
							HWND_NOTOPMOST : HWND_TOPMOST,
						NULL, NULL, NULL, NULL, 
						SWP_NOMOVE | SWP_NOSIZE );
					SetActiveWindow(hwndCur);						
					return 0;
				
				default:  
				ShowWindow(hwndTop[wParam], SW_SHOWNORMAL);
				SetActiveWindow(hwndTop[wParam]);
				return 0;
			}               			
			return 0;
      
      case WM_ENDSESSION:	// wParam = 1 session is ending... save position.
      	if (!wParam)	
      		return 0;
		case WM_DESTROY:   
			GetWindowRect(hwnd, &rect);
			WritePrivateProfileString(szAppName, "Xpos", itoa(rect.left, szBuffer, 10), szSystemIni);
			WritePrivateProfileString(szAppName, "Ypos", itoa(rect.top, szBuffer, 10), szSystemIni);
			PostQuitMessage (0) ;
			return 0 ;
	}

	return DefWindowProc (hwnd, message, wParam, lParam) ;
}  // end of WndProc     

void UpdateMenu()
{
	int		i;
	HWND		hwndCur;		// current window being examined
	HWND		hwndActive;	// currently active window
	char		szText[64]; // menu text
		   			
 	if (hmenu)
 	{
 		DestroyMenu(hmenu);
 	}

	hmenu = CreatePopupMenu();
		
	i=0;                
	hwndActive = GetActiveWindow();
	hwndCur = GetWindow(hwndActive, GW_HWNDLAST);	// start at the bottom of the list
		
	while (	NULL != (hwndTop[i] = GetNextWindow(hwndCur, GW_HWNDPREV)) // search upwards in the list
				&& i < MAX_HWND)	
	{  		      
		hwndCur = hwndTop[i];
		GetWindowText(hwndTop[i], szText, 64);
		          
		if (	szText[0]=='\0' || 	// if it has no name or
				hwndTop[i]==hwnd ||	// if this is the Taskmenu program or				
				!IsWindowVisible(hwndTop[i]) || // if it isn't visible or				
				GetParent(hwndTop[i])	// if this is a child window...
			)	
			continue;		// don't list it in the menu...			
			
			// This is a visible parent window, add it to the menu...
	 	AppendMenu(hmenu, MF_ENABLED | MF_STRING, i, 
	 					szText);	 	   
	 					
	 		// This is the active window, put a check mark beside it
		if ( hwndActive == hwndTop[i] )
			CheckMenuItem(hmenu, i, MF_BYCOMMAND | MF_CHECKED);
	 	i++;
	}
	
	// TaskMenu program options...
	AppendMenu(hmenu, MF_SEPARATOR, NULL, NULL);
	AppendMenu(hmenu, MF_ENABLED | MF_STRING, IDM_ALWAYSONTOP, "TaskMenu on Top");
	CheckMenuItem(hmenu, IDM_ALWAYSONTOP, MF_BYCOMMAND | 
							((GetWindowLong(hwnd, GWL_EXSTYLE)&WS_EX_TOPMOST) ? 
									MF_CHECKED : MF_UNCHECKED ) );
	AppendMenu(hmenu, MF_ENABLED | MF_STRING, IDM_QUIT, "Quit TaskMenu");
                   		 	
}

