/****************************************************************************/
/* PowerBBS Development Add-On DLL					    */
/* (c) 1994 by Russell E. Frey						    */
/*									    */
/* This source code may be freely distributed.				    */
/* You may create a 3rd party DLL add-on to PowerBBS, and		    */
/* distribute it ROYALTY FREE.						    */
/*									    */
/* You may even modify this code and distribute it, so long as you	    */
/* note the modifications at the top of the code and keep ALL the	    */
/* comments here at the top.						    */
/*									    */
/* Be sure to announce your product on our BBS: 516-822-7396 and/or	    */
/* distribute shareware versions of your DLL on our BBS.  We will do	    */
/* our best to help you distribute your product!			    */
/*									    */
/* If you translate this code to a different language, please consider	    */
/* making your translation FREEWARE and upload it to the BBS.  Be sure	    */
/* to thoroughly debug your translation (you do not want to mess up	    */
/* the users record or they will not be happy!)				    */
/*									    */
/* This code can easily be translated to ANY language capable to make a DLL */
/* To run this DLL, in PowerBBS MENU SETUP at the CGM option place a D [For */
/* DLL!].  Then in the description of command put the NAME of the actual    */
/* DLL created.  For example this file: POWRDLL.DLL would be placed in	    */
/* the description.							    */
/*									    */
/* When a user now selects the command PowerBBS will dynamically load	    */
/* POWRDLL.DLL.  It will execute VERY FAST.  This is an easy way to create  */
/* a 3rd party add-on as if it was written inside of PowerBBS!  The user    */
/* will notice NO SLOWDOWN!						    */
/*									    */
/* PowerLang's RUN_DLL command may also be used to execute the DLL	    */
/*									    */
/* We welcome ALL your comments on the Power of PowerBBS's DLL		    */
/* We also welcome any questions you might have, but due to time	    */
/* constraints may not be able to help you in some cases (including	    */
/* debugging your code, etc).						    */
/*									    */
/* Be aware that this product is provided AS IS.  We are not		    */
/* liable for ANY problems this DLL may cause.				    */
/*									    */
/****************************************************************************/


//---------------------------------------------------------------------------
// User types to directly manipulate user information.                        
// NEVER MANIPULATE any information unless you are SURE of what you are doing!
//---------------------------------------------------------------------------

// Notes for 'C' DLL developers:
// Define a couple of commonly used string sizes. Note that Pascal uses
// two types of strings, one where all bytes in the string contains the
// actual data, and one where the first byte is a length byte and the
// following contains that number of characters. In the following
// structures, where the second type of strings are used these are
// declared in the 'C' struture as:
//     unsigned char HelloLen[1];
//     char Hello[30];
// The support function in the PowerDLL.C, LPSTR PascalToCString (), is used
// to extract this type of string. The pointer, PascalString, should point
// to the length byte, HelloLen in above example. The Max parameter for this
// function indicates the maximum length of the buffer, supplied by the
// caller, to prevent buffer overrun.

typedef char Packed2Chars[2];
typedef char Packed3Chars[3];
typedef char Packed4Chars[4];
typedef char Packed5Chars[5];
typedef char Packed6Chars[6];
typedef char Packed7Chars[7];
typedef char Packed8Chars[8];
typedef char Packed9Chars[9];
typedef char Packed10Chars[10];
typedef char Packed11Chars[11];
typedef char Packed12Chars[12];
typedef char Packed13Chars[13];
typedef char Packed14Chars[14];
typedef char Packed15Chars[15];
typedef char Packed16Chars[16];
typedef char Packed19Chars[19];
typedef char Packed20Chars[20];
typedef char Packed23Chars[23];
typedef char Packed24Chars[24];
typedef char Packed25Chars[25];
typedef char Packed30Chars[30];
typedef char Packed32Chars[32];
typedef char Packed35Chars[35];
typedef char Packed39Chars[39];
typedef char Packed40Chars[40];
typedef char Packed45Chars[45];
typedef char Packed78Chars[78];
typedef char Packed128Chars[128];


// Specification of the PowerUser_Rec. variable which stores the current
// users information.

typedef struct _tagPowrUserRecord
{
    Packed25Chars name;		    // {Name}
    Packed20Chars Location;	    // {City/Location}
    Packed15Chars Computer;	    // {Computer Type}
    Packed14Chars Phone_Number;	    // {Phone Number} {Home}
    Packed10Chars Password;	    // {Password}
    Packed8Chars  Birthday;	    // {Date of birthday, DD/MM/YY}
    Packed8Chars  First_Call;	    // {Date of first call, DD/MM/YY}
    Packed8Chars  Last_File_Scan;   // {Date of last file search, DD/MM/YY}
    Packed8Chars  Expiration_Date;  // {Expiration Date}
    Packed8Chars  Last_Call;	    // {Date of last call, DD/MM/YY}
    Packed5Chars  Last_Time;	    // {Time of last call, HH:MM}
    int           Calls;	    // {Total number of calls}
    int           uploads;	    // {Total number of uploads}
    int           downloads;        // {Total number of downloads}
    int           Time_On;          // {Minutes used TODAY}
    double        Today_Bytes;	    // {Bytes downloaded TODAY}
    double        Download_Bytes;   // {Total bytes downloaded}
    double	  Upload_Bytes;	    // {Total bytes uploaded}
    char          FFU [820];        // array[1..820] of byte;
    unsigned char Qwk_Init;	    // byte
    unsigned char QWK_Flag1,
		  QWK_Flag2;	    // byte;
    unsigned int  QWK_Flag3,
                  QWK_Flag4;	    // word;
    unsigned char internaluse;	    // byte;
    unsigned int  waiting_messages; // word; { number of messages waiting }
    unsigned char reservedb;	    // byte;
    long          reservedl;	    // longint;
    unsigned char handle_new;	    // byte;
    unsigned char info_in_new_numbs;// if<>200 then just junk in next fields:
    char          chat_use_handle;  // boolean;
    char	  qwk_msg_use_handle;// boolean;
    Packed14Chars data_phone;	    
    Packed14Chars business_number;
    Packed14Chars fax_number;
    unsigned char bchat_exit;	    // {if=200 use string}
    char          chat_exit_len;    // length of chat exit string
    char          chat_exit [60];   // String[60];
    unsigned char bchat_entry;	    // Byte; {if=200 use string}
    char          chat_entry_len;   // legth of chat entry string
    char          chat_entry [60];  // String[60];
    unsigned char Access;	    // {Access Level}
    unsigned char Expiration_Access;// {Expired Access Level}
    unsigned char Screen_Lines;	    // {Length of a page}
    unsigned char Safe_Total;	    // {Time in Bank}
    unsigned char Options;	    // {Option bits}
// bit value 1 = expert; 4 = dead; 8 = hasmail
//           16=TRUE,64=TRUE then 32=TRUE[MALE];FALSE[FEMALE]
    char          Xproto;	    // {Protocol}
    char          Monitor_Type;	    // {Monitor? (M)onocrome (C)olor (N)one}
    unsigned int  Messages_Left;    // {total messages left by user}
    double        downbytes_month;  // {total bytes downloaded/month}
    unsigned char downbytesmonth;   // byte;
    unsigned int  downbytes_month_max;// {max downbytes/month}
    Packed5Chars  truebps2;	    // {true baud rate}
    unsigned char lang_num;	    // {current language number}
    unsigned char is_focused;	    // {used internally}
    unsigned char powercomm_connect;// {true if PowerComm connect}
    unsigned char color_mode_connect;// {true if PowerComm/color_mode connect}
    unsigned char last_forum_on2;   // {last forum joined}
    long          credits;	    // {amount of credits left}
    char          anony_name_len;   // Junk
    char          anony_name2[14];  // {JUNK}
    char          script[37];       // {used for scripts}
    char          auto_forum_join_set;// { = 10 means use auto forum join! }
    int           auto_forum_join;  //
    unsigned char set_up_int_msgs;  // { = 10 if use next two options! }
    unsigned int  max_internet_msgs_month;
    unsigned int  current_internet_msgs_month;
    unsigned char the_internet_month;

    unsigned char allow_FTPmail;    // {allow if = 10}
    unsigned int  dollars;
    unsigned char call_verified;
    char          anonymous_name[20];
    char          has_anonyname;    // { if true, set to 10 }
    char          has_address;	    // { if true, set to 10 }
    char          last_menu_code;
    char          QWK_Net_User;	    // { if true, set to 10 }
    char          area_backnum[3];
    int		  last_forum_on;
    char	  created_rec;	    // { if true, set to 10 }
    unsigned int  PowerUser_Ext_Num;
    char          address[50];	    // {address} {location above}
    char          state[10];	    // {state}
    char	  zip[10];	    // {zip}
    char          call_backnum[7];  // {Called Number}
} POWRUSER_RECORD, FAR * LPPOWRUSER_RECORD;

#define HIGHEST_EXT_FORUM_NUMBER 1000

typedef struct _tagforum_data_options_record
{
    unsigned char Options;
// bit value 1 = member
//           2 = 2
//          16 = join_it
    float Message_Pointer;
} FORUM_DATA_OPTIONS_RECORD, FAR * LPFORUM_DATA_OPTIONS_RECORD;

typedef struct _tagPowrUser_Record_Extension
{
    unsigned char Delete_This;
    FORUM_DATA_OPTIONS_RECORD Forum_Data [HIGHEST_EXT_FORUM_NUMBER];
    long          user_name;
    unsigned char junk;
} POWRUSER_RECORD_EXTENSION, FAR * LPPOWRUSER_RECORD_EXTENSION;



// Specification of the Power_CallInfo_Rec; holds the current caller's
// information (The USERINFO.BBS File)
typedef struct _tagPower_CallInfo_Rec
{
    Packed25Chars     name;	    // {User Name}
    int               User_Pointer; // {User Record # starting at 1}
    Packed5Chars      BaudRate;     // {Baud Rate to Send at}
    char              Com_Number;   // {Com Number to Send at}
    unsigned char     What_Menu;    // {Current Menu}
    char              color_mode;   // {Gcolor_modeType:
//                                        'C' => Color
//                                        'M' => Monochrome
//                                        'N' => None}
    unsigned char     Access;       // {User Access Level}
    unsigned char     ForumNum2;    // {Current Forum Number}
    Packed5Chars      Logon_Time;   // {hh:mm Time of Logon}
    int               Logon_Mins;   // {Time the user logged on in mins}
    int               Used_Today;   // {Time the user used in
                                    //  previous calls so far today}
    int               time_limit;   // {Maximum mins permitted on BBS}
    int               KDownload_Maximum; // {Maximum download bytes in K}
    int               Upload_Credit;// {Minutes given for Uploading}
    int               Minutes_Useable;// {Maximum time left for Caller}
    int               Node_Num;     // {Node number of this CallInfo File}
    char              PathDataLen;  // Length of string to follow...
    char              Path_Data[28];// {Path to PowrBBS.DAT}
    int               Forum_Num;    // integer;
    char              Whatsdoing2;  // {'P' - Live Program
//                                      'G' - Goodbye after transfer
//                                      'T' - Transfer}
    char              Trans_Type;   // {set to U for upload or D for download}
    char              Protocol;     // {protocol # for transfers}
    long              Started;      // {transfer, 'P' - Live Program}
} POWER_CALLINFO_REC, FAR * LPPOWER_CALLINFO_REC;

				    
// structure of the forum setup
    
typedef struct _tagPowerBBS_Forum_Structure
{
    unsigned char   forum_name_len[1];          // Length of forum name      
    char            forum_name[20];             // {name of forum}
    Packed23Chars   forum_subsysop;             // {sub-sysop if any}
    char            is_anonymous;               // {true if anonymous
                                                //  messages may be entered}
    char            all_messages_public;        // {true if no private mail}
    char            forum_public;               // {true if open to all users}
    int             forum_min_access_level;     // {min access needed for
                                                //  forum no matter what}
    unsigned char   forum_mb_path_len[1];       // Length of following path 
    char            forum_messagebase_path[31]; // {path/filename of message
                                                //  base file}
    unsigned char   forum_newsfile_len[1];      // Length of following path
    char            forum_newsfile[31];         // {path/filename to news}
    unsigned char   forum_filelist_len[1];      // Length of file list path
    char            forum_filelisting[31];      // {path/filename to listing
                                                //  of file areas available}
    unsigned char   furum_file_data_len[1];     // Length of list data path
    char            forum_filelisting_data[31]; // {path/filename to data
                                                //  file containing
                                                //  information as to where
                                                //  file lists are}
    unsigned char   forum_download_dirs_len[1]; // Length of download path
    char            forum_download_dirs[31];    // {list of download
                                                //  directories, that one
                                                //  may access to download
                                                //  files from}
    unsigned char   forum_upload_direct_len[1]; // Length of upload dir path
    char            forum_upload_directory[31]; // {upload directory}
    unsigned char   forum_upload_list_len[1];   // Length of upload list len
    char            forum_upload_listing[31];   // {listing of uploaded
                                                //  files}
} POWERBBS_FORUM_STRUCTURE, FAR * LPPOWERBBS_FORUM_STRUCTURE;


// MOST of the information located in the PowrBBS.Dat file 
// Note that MANY variables contained in this record may contain JUNK
// or is part of something else used in PowerBBS.Dat.  Be careful
// with what you use!
						
typedef struct _tagPBBSRECORD
{
     unsigned char BBS_NameLen[1];
     char BBS_Name[30];
     unsigned char Sysop_FirstNameLen[1];
     char Sysop_FirstName [10];
     unsigned char Sysop_LastNameLen[1];
     char Sysop_Last_Name[15];
     unsigned char end_defaultLen[1];
     char end_default[4];
     int MAX_Obey_Ratio;
     int Min_Msgs_Ratio;
     int Min_Downfile_Ratio;
     int Min_Downbyte_Ratio;
     int Min_Msgs_Ratio2;
     int Min_Downfile_Ratio2;
     int Min_Downbyte_Ratio2;
     int New_User_Level;
     unsigned char AccessLevelInfoLen[1];
     char Access_Level_Info[30];
     unsigned char DownloadRestrictFileLen[1];
     char Download_Restrict_File[30];
     unsigned char UploadAccessFileLen[1];
     char Upload_Access_File[30];
     unsigned char UsersPathLen[1];
     char Users_Path[30];
     unsigned char UsersPath2Len[1];
     char Users_Path2[30];
     unsigned char ForumDataFileLen[1];
     char Forum_Data_File[30];
     unsigned char Protocolinfo_fileLen[1];
     char Protocolinfo_file[30];
     unsigned char Transfer_FileList_FileLen[1];
     char Transfer_FileList_File[30];
     unsigned char Security_FileLen[1];
     char Security_File[30];
     unsigned char Transfer_DirectoryLen[1];
     char Transfer_Directory[50];
     unsigned char Activity_LogLen[1];
     char Activity_Log [30];
     unsigned char Tranlog_PathLen[1];
     char Tranlog_Path[30];
     unsigned char OpeningLen[1];
     char Opening[30];
     unsigned char HelloLen[1];
     char Hello[30];
     unsigned char Birthday_FileLen[1];
     char Birthday_File [30];
     unsigned char Expired_FileLen[1];
     char Expired_File [30];
     unsigned char Sysop_FileLen[1];
     char Sysop_File [30];
     unsigned char Forum_MenuLen[1];
     char Forum_Menu [30];
     unsigned char NewUser_TextLen[1];
     char NewUser_Text [30];
     unsigned char No_Sysop_ChatLen[1];
     char No_Sysop_Chat [30];
     unsigned char enter_chat_fileLen[1];
     char enter_chat_file [30];
     unsigned char exit_chat_FileLen[1];
     char exit_chat_File [30];
     unsigned char Script_TextLen[1];
     char Script_Text [30];
     unsigned char QScript_FileLen[1];
     char QScript_File [30];
     unsigned char BadUsers_NamesLen[1];
     char BadUsers_Names [30];
     unsigned char Read_Help_FileLen[1];
     char Read_Help_File [30];
     unsigned char Mail_PrefixLen[1];
     char Mail_Prefix [8];
     int Most_Msgs_Downloadable;
     unsigned char OS_Shell_FileLen[1];
     char OS_Shell_File [30];
     unsigned char Begin_Download_FileLen[1];
     char Begin_Download_File [30];
     unsigned char Begin_Upload_FileLen[1];
     char Begin_Upload_File [30];
     unsigned char Freefile_ListLen[1];
     char Freefile_List [30];
     unsigned char Start_BatchLen[1];
     char Start_Batch [30];
     unsigned char Init_Modem_Command1Len[1];
     char Init_Modem_Command1 [55];
     unsigned char Init_Modem_Command2Len[1];
     char Init_Modem_Command2 [55];
     unsigned char Nodes_Users_InfoLen[1];
     char Nodes_Users_Info [30];
     unsigned char chatstatfileLen[1];
     char chatstatfile [30];
     unsigned char chattalkfileLen[1];
     char chattalkfile [30];
     unsigned char onetoonefileLen[1];
     char onetoonefile[30];
     unsigned char roominfofileLen[1];
     char roominfofile[30];
     unsigned char run_xmodem1kLen[1];
     char run_xmodem1k[30];
     unsigned char script_for_newusersLen[1];
     char script_for_newusers[30];
     unsigned char answer_to_scriptLen[1];
     char answer_to_script [30];
     unsigned char credit_system[1];
     unsigned char more_creditsLen[1];
     char more_credits[30];
     unsigned char anony_infoLen[1];
     char anony_info [30];
     unsigned char runanonybbs;
     unsigned char lowbaudinfoscreenLen[1];
     char lowbaudinfoscreen [30];
     int minimum_sec_to_abort_intro;
     unsigned char screen_enter_script_modeLen[1];
     char screen_enter_script_mode[30];
     unsigned char screen_end_script_modeLen[1];
     char screen_end_script_mode [30];
     unsigned char Live_Programs_MenuLen[1];
     char Live_Programs_Menu [30];
     unsigned char Live_Programs_DataFileLen[1];
     char Live_Programs_DataFile [30];
     unsigned char Chat_Help_FileLen[1];
     char Chat_Help_File [30];
     int Most_Lines_Msg;
     long minimum_baud;
     unsigned char Modem_OffhookLen[1];
     char Modem_Offhook [30];
     unsigned char Read_Mail_MenuLen[1];
     char Read_Mail_Menu [30];
     UINT aux_addr1;
     UINT cardtype;
     UINT cardseg;
/* --------------------Event Information------------------------------*/
     unsigned char old_active_event;
     unsigned char old_time_of_eventLen[1];
     char old_time_of_event[5];
     unsigned char old_Wait_For_Event;
/* --------------------- Test Files ----------------------------------*/
     unsigned char TestFiles;
     unsigned char TestBatchLen[1];
     char TestBatch [30];
     unsigned char TestFile1Len[1];
     char TestFile1 [30];
     unsigned char TestFile2Len[1];
     char TestFile2 [30];
/*--------------------------------------------------------------------*/
     unsigned char Private_Uploads_Only;
     unsigned char Private_Upload_DirectoryLen[1];
     char Private_Upload_Directory [30];
     unsigned char Private_Upload_ListLen[1];
     char Private_Upload_List[30];
     unsigned char Bulletins_MenuLen[1];
     char Bulletins_Menu [30];
     unsigned char Bulletins_DataLen[1];
     char Bulletins_Data [30];
     char Baud_Rate_Open_At [5];
     unsigned char LockBaud;
     unsigned char ClosedBBS;
     unsigned char Port_NumberLen[1];
     char Port_Number [6];
     unsigned char Port_Number2Len[1];
     char Port_Number2 [6];
     char Port_Number3[7];
     unsigned char RingAnswer;
     int Max_Pause_Time;
     unsigned char UseRealName;
     unsigned char AllowBadChars;
     unsigned char Permit_Ansi_Messages;
     unsigned char News_New;
     unsigned Turn_Off_FreeCheck;
     int Minimum_Space_Uploads;
     unsigned char Default_AnsiColorLen[1];
     char Default_AnsiColor [4];
     unsigned char Default_AnsiIntensityLen[1];
     char Default_AnsiIntensity [4];
     float Transfer_Figure_Time;
     unsigned char Pack_QWK_FilesLen[1];
     char Pack_QWK_Files [30];
     unsigned char View_ZIP_FileLen[1];
     char View_ZIP_File [50];
     unsigned char Test_ZIP_FileLen[1];
     char Test_ZIP_File[50];
     unsigned char Bad_archiveLen[1];
     char Bad_archive [50];
     unsigned char IndexPathLen[1];
     char IndexPath [30];
     unsigned char IndexRamdiskPathLen[1];
     char IndexRamdiskPath [30];
     unsigned char StatsScreenLen;
     char StatsScreen [30];
     unsigned char PowerInfoPathLen[1];
     char PowerInfoPath [30];
     unsigned char SerialNumberLen[1];
     char SerialNumber [255];
     unsigned char AskBirthdate;
     char NonEchoChar;
     unsigned char DeleteDropUploads;
     unsigned char FilesRatiosScreenLen[1];
     char FilesRatiosScreen [30];
     unsigned char LogFileNameLen[1];
     char LogFileName [30];
     unsigned char TranStringLen[1];
     char TranString [30];
     unsigned char NSPathLen[1];
     char NSPath [30];
     unsigned char Monitor_FileLen[1];
     char Monitor_File [30];
     unsigned char PermitHandles;
     unsigned char FrontDoorBatchLen[1];
     char FrontDoorBatch [30];
     unsigned char QuitBatchFileLen[1];
     char QuitBatchFile [30];
     unsigned char TheListPathLen[1];
     char TheListPath [30];
     unsigned char UpdateScreenLen[1];
     char UpdateScreen [30];
     unsigned char ClockScreenLen[1];
     char ClockScreen [30];
     unsigned char QuestionClosedLen[1];
     char QuestionClosed [30];
     unsigned char AnswerClosedLen[1];
     char AnswerClosed [30];
     unsigned char LangInfoFileLen[1];
     char LangInfoFile [30];
     unsigned char BadRatioFileLen[1];
     char BadRatioFile [30];
     unsigned char Source_MNU_POW_DirLen[1];
     char Source_MNU_POW_Dir [30];
     unsigned char irq_modemLen[1];
     char irq_modem [30];
     WORD modem_base1;
     unsigned char modem_base2Len[1];
     char modem_base2 [30];
     unsigned char MultiLanguage;
     unsigned char UseDtr;
     unsigned char UsePowerMail;
     unsigned char UseFrontDoor;
     unsigned char Expiration_WarningLen[1];
     char Expiration_Warning[30];
     unsigned char PNET_TaglineLen[1];
     char PNET_Tagline[60];
     unsigned char MODEM_ATHOLen[1];
     char MODEM_ATHO [30];
     unsigned char date_format;	    // { 0 = US MM-DD-YY; 1 = DD-MM-YY }
     unsigned char event_data_fileLen[1];
     char event_data_file [30];
     int minimum_sec_new_files;
     unsigned char use_fax;
     unsigned char show_whose_online;
     unsigned char show_dialog_on_startup;
     unsigned char doorsys_pathLen[1];
     char doorsys_path [30];
     unsigned char track_gender;
     unsigned char Start_Up_Minimized;
     unsigned char Internet_Connection;
     unsigned char PowerBase_CodeLen[1];
     char PowerBase_Code [30];
     unsigned char SysopPage_DataFileLen[1];
     char SysopPage_DataFile [30];
     unsigned char TheWavLen[1];
     char TheWav [100];
     WORD Bytes_upload_Credit;
     WORD Bytes_Dn_Up_Credit;
     WORD Credits_To_Uploader;
     unsigned char Caller_ID;
     unsigned char Show_Stats;
     int Minimum_Access_For_Internet;
     unsigned char forum_network_fileLen[1];
     char forum_network_file [30];
     unsigned char cbv_onoff;
     unsigned char blts_onoff;
     unsigned char Caller_ID_NameLen[1];
     char Caller_ID_Name [100];
     unsigned char Caller_ID_PhoneLen[1];
     char Caller_ID_Phone [100];
     unsigned char areacodefileLen[1];
     char areacodefile [100];
     unsigned char callbackfileLen[1];
     char callbackfile [100];
     unsigned char begincallbackLen[1];
     char begincallback [100];
     unsigned char badnumbersLen[1];
     char badnumbers [100];
     unsigned char security_changeLen[1];
     char security_change [100];
     unsigned char tempoLen[1];
     char tempo [255];	
     unsigned char Start_PowerBBS_DirectoryLen[1];
     char Start_PowerBBS_Directory [100];
     unsigned char lastdirlLen[1];
     char lastdirl [90];

     unsigned char    QWK_Blts;
     unsigned char    QWK_NewFiles;
     unsigned char    QWK_UpNewFiles;
     unsigned char    QWK_ALLNewFiles;
     unsigned char    QWK_GOODBYE;
     unsigned char    QWK_NEWS;
     unsigned char    QWK_WELCOME;
     unsigned char    QWK_FileEnclos;
     unsigned char    QWK_ALLFileEnclos;
     unsigned char    QWK_PromptFileEnclos;
     unsigned char    QWK_Logoff;
  
     WORD QWK_MaxConf;
     WORD QWK_Max_QWK;

     unsigned char marked_mailLen[1];
     char marked_mail[255];
     unsigned char credit_nameLen[1];
     char credit_name[30];
     unsigned char credit_bytesLen[1];
     char credit_bytes[30];
     unsigned char temps1Len[1];
     char temps1 [255];
     unsigned char temps2Len[1];
     char temps2 [255];
     unsigned char temps3Len[1];
     char temps3 [255];
     unsigned char temps4Len[1];
     char temps4 [255];
     unsigned char temps5Len[1];
     char temps5 [255];
} PBBSRECORD, FAR * LPPBBSRECORD;
			    
    
#define PBBS_PRINTMODEM	    10001
#define PBBS_GET_ENTER      10002
#define PBBS_ASK_USER       10003
#define PBBS_CLS            10004						
#define PBBS_PAUSE_STOP     10005
#define PBBS_GET_KEY        10006
#define PBBS_GET_YN         10007
#define PBBS_GET_YNQ        10008
#define PBBS_GET_HOT	    10009
#define PBBS_TYPE_FILE	    10010     
#define PBBS_TIMED_KEY	    10011
#define PBBS_MODEM_CMD	    10012
#define PBBS_NOT_ONLINE	    10013
#define PBBS_EXEC_PRG	    10014
#define PBBS_KEY_WAITING    10015
#define PBBS_VERIF_TIME	    10017
#define PBBS_TIME_LEFT	    10016
     
     