/****************************************************************************/
/* PowerBBS Development Add-On DLL					    */
/* (c) 1994 by Russell E. Frey						    */
/*									    */
/* This source code may be freely distributed.				    */
/* You may create a 3rd party DLL add-on to PowerBBS, and		    */
/* distribute it ROYALTY FREE.						    */
/*									    */
/* You may even modify this code and distribute it, so long as you	    */
/* note the modifications at the top of the code and keep ALL the	    */
/* comments here at the top.						    */
/*									    */
/* Be sure to announce your product on our BBS: 516-822-7396 and/or	    */
/* distribute shareware versions of your DLL on our BBS.  We will do	    */
/* our best to help you distribute your product!			    */
/*									    */
/* If you translate this code to a different language, please consider	    */
/* making your translation FREEWARE and upload it to the BBS.  Be sure	    */
/* to thoroughly debug your translation (you do not want to mess up	    */
/* the users record or they will not be happy!)				    */
/*									    */
/* Sample code in Borland Pascal 7.0 on writing an add-on DLL for PowerBBS  */
/*									    */
/* This code can easily be translated to ANY language capable to make a DLL */
/* To run this DLL, in PowerBBS MENU SETUP at the CGM option place a D [For */
/* DLL!].  Then in the description of command put the NAME of the actual    */
/* DLL created.  For example this file: POWRDLL.DLL would be placed in	    */
/* the description.							    */
/*									    */
/* When a user now selects the command PowerBBS will dynamically load	    */
/* POWRDLL.DLL.  It will execute VERY FAST.  This is an easy way to create  */
/* a 3rd party add-on as if it was written inside of PowerBBS!  The user    */
/* will notice NO SLOWDOWN!						    */
/*									    */
/* PowerLang's RUN_DLL command may also be used to execute the DLL	    */
/*									    */
/* We welcome ALL your comments on the Power of PowerBBS's DLL		    */
/* We also welcome any questions you might have, but due to time	    */
/* constraints may not be able to help you in some cases (including	    */
/* debugging your code, etc).						    */
/*									    */
/* Be aware that this product is provided AS IS.  We are not		    */
/* liable for ANY problems this DLL may cause.				    */
/*									    */
/****************************************************************************/

/****************************************************************************/
/*									    */
/* PowerBBS Development Add-On DLL					    */
/* (c) 1994 by Russell E. Frey						    */
/*									    */
/****************************************************************************/

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "powrdll.h"

/****************************************************************************/
/* Note to 'C' programmers:                                                 */
/* You should have knowledge about the special behavior of a DLL. Remember  */
/* that multiple instances of a DLL share the same data segment so that if  */
/* you make a DLL that can be called by several nodes at the same time you  */
/* will need to take into acount that all nodes will use the same data.     */
/* You can handle this by using arays for the data that is to be unique     */
/* for each node and use the node number to index into the data. Since      */
/* PowerBBS can handle up to nine nodes plus another 15 Telnet nodes you    */
/* would need to have a lot of static data allocated that in most cases     */
/* would not be used. It may be better to allocate a structure dynamically  */
/* as the DLL start up for a node and pass a pointer to this structure to   */
/* all functions where the data would be needed.                            */
/* Also remember that a DLL runs of the stack of the calling program. This  */
/* means that you should be restrictive of using too much automatic         */
/* variables and that such variables, if the address of these are passed    */
/* to other functions, MUST be passed as FAR pointers.                      */
/****************************************************************************/

// Need Colors?  Use the following in your Print_Modem calls:
//
//  @1@ Blue
//  @2@ Green
//  @3@ Cyan
//  @4@ Red
//  @5@ Magenta
//  @6@ Gray
//  @7@ Yellow
//  @8@ Brown
//  @9@ White
//  @10@ Light Blue
//  @11@ Light Green
//  @12@ Light Cyan
//  @13@ Light Red
//  @14@ Light Magenta
//  @15@ Light Gray
//  @16@ Default Color
//
//  Colors will ONLY be used if the caller has ANSI capabilities.

HINSTANCE hInst;

// The LibMain function is called by Windows when it is loaded. If you
// need to initialize anything, e.g., register a window class, here is
// the place to do it.
int FAR PASCAL LibMain (HANDLE hinstance, WORD wdataseg,
                        WORD cbheapsize, LPSTR lpszcmdline)
{
    hInst = hinstance;
    return 1;
}

// The corresponding function, called by Windows when the DLL is unloaded
// from memory.

int FAR PASCAL WEP (int nparamater)
{
    return(TRUE);
}

//--------------------------------------------------------------------------
// Support routine to convert an ASCII string to a numeric value. It is
// similar to the atoi() function but can be used inside a small model
// DLL with automatic variables since it is expecting a LPSTR (FAR *).
//--------------------------------------------------------------------------

int asc_to_int (LPSTR pIn)
{
    LPSTR p = pIn;
    int Value = 0;
    
    while ((* p) && (* p == ' ')) p ++;
    while (* p)
    {
	if ((* p < '0') || (* p > '9'))
	    break;
	Value *= 10;
	Value += (int) ((* p) - '0');
	p ++;
    }
    return Value;
}

//--------------------------------------------------------------------------
// Support function to convert a Pascal formated string to a null terminated
// 'C' string. The function returns a pointer to the user suplied buffer
// so that it may be used in functions that takes a string pointer as
// an argument, e.g., wsprintf(). The pascal pointer should point to the
// length byte of the string. The Max is the size of the allocated 'C'
// string.
//--------------------------------------------------------------------------

LPSTR PascalToCString (unsigned char FAR * PascalString, LPSTR CString,
		       unsigned int Max)
{
    unsigned int Len = * PascalString ++;
    
    Max --;
    if (Max <= 0)
    {
	* CString = '\0';
	return CString;
    }
    if (Len > Max)
	Len = Max;
    _fmemcpy (CString, PascalString, Len);
    CString [Len] = '\0';
    return CString;
}
 
//--------------------------------------------------------------------------
// Support function to convert a Pascal formated string to a null terminated
// 'C' string. The function returns a pointer to the user suplied buffer
// so that it may be used in functions that takes a string pointer as
// an argument, e.g., wsprintf(). This function is used with Pascal strings
// that does not have a length byte. The size should for this function be
// the size of the string as declared in the structure.
//--------------------------------------------------------------------------

LPSTR PackedToCString (LPSTR PackedString, LPSTR CString, int Size)
{
    if (Size <= 0)
    {
	* CString = '\0';
	return CString;
    }
    _fmemcpy (CString, PackedString, Size);
    CString [Size] = '\0';
    return CString;
}


//--------------------------------------------------------------------------
// Sample procedures to interface with PowerBBS.
//--------------------------------------------------------------------------

void Print_Modem(HWND PBBSWin, LPSTR ToWrite)
{
// Prints the String TOWRITE to the screen and caller
    SendMessage(PBBSWin, WM_COMMAND, PBBS_PRINTMODEM, (LONG) ToWrite);
}

//--------------------------------------------------------------------------
void PrintLn_Modem(HWND PBBSWin, LPSTR ToWrite)
{
// Prints the String TOWRITE followed by a carriage return to
// screen and caller
    char Temp [255];
    lstrcpy (Temp, ToWrite);
    lstrcat (Temp, "\r");
    SendMessage(PBBSWin, WM_COMMAND, PBBS_PRINTMODEM, (LONG)(LPSTR) Temp);
}

//---------------------------------------------------------------------------
void Get_Enter_Key(HWND PBBSWin)
{
// Outputs to the user to press their enter key, waits till its pressed,
// and clears the output that says Press [Enter]:

    SendMessage(PBBSWin, WM_COMMAND, PBBS_GET_ENTER, 0);
}

//---------------------------------------------------------------------------
void Ask_User(HWND PBBSWIN, LPSTR InputS, int MaxIn)
{
// Inputs characters from a user.

  char pIn[255];

  wsprintf (pIn, "%d", MaxIn);
  SendMessage(PBBSWIN, WM_COMMAND, PBBS_ASK_USER, (LONG)(LPSTR) pIn);
  lstrcpy (InputS, pIn);
// Note that command 10003 you send PowerBBS the maximum number of
// input chars.  It then uses this SAME pointer to send back the
// actual input from the user.
}


//---------------------------------------------------------------------------
void ClearScreen(HWND PBBSWIN)
{
// Clears the ANSI screen 

  SendMessage(PBBSWIN, WM_COMMAND, PBBS_CLS, 0);
}

//---------------------------------------------------------------------------
BOOL PauseStop(HWND PBBSWIN)
{
// this function will display ::: Pause [S]top, [C]ontinue ::: if
// the user is beyond their max lines/page.  If the user presses
// S to Stop this function returns TRUE.  Otherwise FALSE is
//  pressed

  char pIn [255];

  SendMessage(PBBSWIN, WM_COMMAND, PBBS_PAUSE_STOP, (LONG)(LPSTR) pIn);
  if (pIn[0] == 'Y')
      return TRUE;
  return FALSE;
}

//---------------------------------------------------------------------------
char Get_Key(HWND PBBSWIN)
{
// Waits for a key from the user.  Returns the key pressed (note that
// if the carrier dropped carrier it returns char #255).
//  *RETURNS THE UPPERCASE CHARACTER OF KEYPRESSED*

  char pIn [6];

  SendMessage(PBBSWIN, WM_COMMAND, PBBS_GET_KEY, (LONG)(LPSTR) pIn);
  return (pIn[0] & 0xFF);
}


//---------------------------------------------------------------------------
BOOL Get_YN(HWND PBBSWIN)
{
// Waits until the user presses Yes or No.  (note that it COULD be
// different from a Y if a different LANGUAGE is being used)
    
  char pIn[6];

  SendMessage(PBBSWIN, WM_COMMAND, PBBS_GET_YN, (LONG)(LPSTR) pIn);
  if (pIn [0] == 'Y')
      return TRUE;
  return FALSE;
}

//---------------------------------------------------------------------------
BOOL Get_YesNoQ(HWND PBBSWIN, LPSTR TheQues, BOOL Default)
{
// Outputs the question THEQUES to the user.  Then waits for a Y/N answer,
// with Default being the answer if the user presses the [ENTER] key.
// Returns the result 

    char PIn [255];

    if (Default)
	lstrcpy (PIn, "Y");
    else
	lstrcpy (PIn, "N");
    lstrcat (PIn, TheQues);
    
    SendMessage(PBBSWIN, WM_COMMAND, PBBS_GET_YNQ, (LONG)(LPSTR) PIn);
    if (PIn [0] == 'Y')
	return TRUE;
    return FALSE;
}

//---------------------------------------------------------------------------
char Get_Hot(HWND PBBSWIN, LPSTR OKChars)
{
// Waits till the user presses a valid char in the OKChars string and
// returns that char (note: may not return a valid char if the user
// drops carrier).  Ex: Get_Hot(PBBSWIN, 'YN') to wait for Y or N.
//  Use UPPERCASE

    char PIn [255];

  lstrcpy (PIn, OKChars);
  SendMessage(PBBSWIN, WM_COMMAND, PBBS_GET_HOT, (LONG)(LPSTR) PIn);
  return PIn [0];
}

//---------------------------------------------------------------------------
void Type_File_To_Modem (HWND PBBSWIN, LPSTR FName)
{
// Types the file specified to the modem.

  SendMessage(PBBSWIN, WM_COMMAND, PBBS_TYPE_FILE, (LONG) (LPSTR) FName);
}

//---------------------------------------------------------------------------
char Input_Key_Time(HWND PBBSWIN, int MaxTime)
{
// Waits up to MaxTime (in milliseconds) for a character to be entered.
// If the user does NOT press a key in this time, character #255 is
// returned. 
    

    char PIn [255];
    wsprintf (PIn, "%d", MaxTime);
    SendMessage(PBBSWIN, WM_COMMAND, PBBS_TIMED_KEY, (LONG)(LPSTR) PIn);
    return PIn [0];
}


//---------------------------------------------------------------------------
void Send_Modem_Command(HWND PBBSWIN, LPSTR commands)
{
// Sends commands to the modem and does NOT print commands on the local
//  screen.

    SendMessage(PBBSWIN, WM_COMMAND, PBBS_MODEM_CMD, (LPARAM)(LPSTR) commands);
}


//--------------------------------------------------------------------------
BOOL No_User_Online(HWND PBBSWIN)
{
//  This is an IMPORTANT function.  If this boolean is ever TRUE it should
//  be the end of your DLL!  So this NEEDS to be included in all loops,
//  repeats, etc.  If TRUE, then exit the loop, etc..  Example:
//    Repeat
//    Until (..) or (No_User_Online);


    char pIn [6];

    SendMessage(PBBSWIN, WM_COMMAND, PBBS_NOT_ONLINE, (LONG)(LPSTR) pIn);
    if (pIn [0] == 'Y')
	return TRUE;
    return FALSE;
}

//---------------------------------------------------------------------------
void Execute_Prog(HWND PBBSWIN, LPSTR commands)
{
//  Closes the com port.  Executes commands, re-opens, and returns.

  SendMessage(PBBSWIN, WM_COMMAND, PBBS_EXEC_PRG, (LPARAM)(LPSTR) commands);
}

//---------------------------------------------------------------------------
BOOL Key_Waiting(HWND PBBSWIN)
{
// Returns true if a key is waiting (could be either from the sysop's
//  local keyboard or remote

    char pIn [6];

    SendMessage(PBBSWIN, WM_COMMAND, PBBS_KEY_WAITING, (LONG)(LPSTR) pIn);
    if (pIn[0] == 'Y')
	return TRUE;
    return FALSE;
}

//---------------------------------------------------------------------------
void Verify_Time_Left(HWND PBBSWIN)
{
// PowerBBS checks the time left by User.  If it is 0, the user is
// told their time is out.   (No_User_Online would then be TRUE).

  SendMessage(PBBSWIN, WM_COMMAND, PBBS_VERIF_TIME, 0L);
}

//--------------------------------------------------------------------------
int Time_Left(HWND PBBSWIN)
{
// Returns the time that the user has left

  char pIn [255];

  SendMessage(PBBSWIN, WM_COMMAND, PBBS_TIME_LEFT, (LONG)(LPSTR) pIn);
  return (asc_to_int (pIn));
}

//--------------------------------------------------------------------------

void Write_ActLog(HWND PBBSWIN, LPSTR ToWrite)
{
// Writes TOWRITE to the activity Log 
  SendMessage(PBBSWIN, WM_COMMAND, 10019, (LONG) ToWrite);
}

//---------------------------------------------------------------------------
void Convert_Macros(HWND PBBSWIN, LPSTR ToConv)
{
// Converts all |MACROS|
    SendMessage(PBBSWIN, WM_COMMAND, 10020, (LONG) (LPSTR) ToConv);
}

//--------------------------------------------------------------------------
void Change_Forum(HWND PBBSWIN, int InI)
{
// Change to Forum InI

    char pIn [254];

    wsprintf (pIn, "%d", InI);
    SendMessage(PBBSWIN, WM_COMMAND, 10021, (LPARAM)(LPSTR) pIn);
}


//{--------------------------------------------------------------------------
void Run_Menu_Command(HWND PBBSWIN, int InI)
{
// Run_Menu_Command InI 

    char pIn [254];

    wsprintf (pIn, "%d", InI);
    SendMessage(PBBSWIN, WM_COMMAND, 10022, (LPARAM)(LPSTR) pIn);
}

//---------------------------------------------------------------------------
void Run_PowerBase(HWND PBBSWIN, int InI)
{
// Run PowerBase InI
    
    char pIn[254];

    wsprintf (pIn, "%d", InI);
    SendMessage(PBBSWIN, WM_COMMAND, 10023, (LPARAM)(LPSTR) pIn);
}


//---------------------------------------------------------------------------
void Back_Spaces(HWND PBBSWIN, int Num)
{
// This procedure is used to back up and clear text.  For example you could
// use: Press [ENTER]: then after ENTER is pressed, used this procedure to
//  back up
    
    char pIn[254];

    wsprintf (pIn, "%d", Num);
    SendMessage(PBBSWIN, WM_COMMAND, 10025, (LPARAM)(LPSTR) pIn);
}

//---------------------------------------------------------------------------
void Send_File(HWND PBBSWIN, LPSTR Fname, int mode)
{
// Sends filename FNAME [be sure to include full path/filename!]
//  Mode:
//    1: zmodem
//    2: xmodem/crc
//    3: xmodem/1k
//    4: xmodem/1kg
//    5: ymodem
//    6: ymodemg
//    7: kermit    

    char pIn[254];
    wsprintf (pIn, "%d~%s", mode, (LPSTR)Fname);
    SendMessage(PBBSWIN, WM_COMMAND, 10026, (LPARAM)(LPSTR) pIn);
}

//---------------------------------------------------------------------------
void Receive_File(HWND PBBSWIN, LPSTR Fname, int mode)
{
// Receives Fname.  Only uses the FILENAME in Fname.  The file
// is placed in the transfer directory.  BBS_RECORD.Transfer_Dir
//  Mode:
//    1: zmodem
//    2: xmodem/crc
//    3: xmodem/1k
//    4: xmodem/1kg
//    5: ymodem
//    6: ymodemg
//    7: kermit
    
    char pIn [254];
	
    wsprintf (pIn, "%d~%s", mode, (LPSTR)Fname);
    SendMessage(PBBSWIN, WM_COMMAND, 10027, (LPARAM)(LPSTR) pIn);
}

//---------------------------------------------------------------------------
char Monitor_Mode(HWND PBBSWIN)
{
// Returns the color mode:
//  'R' = RIP
//  'C' = ANSI
//  'M' = ASCII
//  Note that RIP is also ANSI compatible.

    char pIn [11];

    SendMessage(PBBSWIN, WM_COMMAND, 10028, (LPARAM)(LPSTR) pIn);
    return pIn[0];
}

//-------------------------------------------------------------------------
LPPOWRUSER_RECORD Get_UserRec(HWND PBBSWIN)
{
//  Gives you the pointer to the actual location of the user record in memory.
//  By changing the actual information in this record you are able to change
//  the current user information!  (BE CAREFUL ON WHAT YOU DO!)

    
    LPPOWRUSER_RECORD  lpUser;
    char pIn [254];
    
    SendMessage(PBBSWIN, WM_COMMAND, 10030, (LPARAM)(LPSTR) pIn);
    lpUser = (LPPOWRUSER_RECORD) * (LONG *) pIn;
    return lpUser;
}

//---------------------------------------------------------------------------
LPPOWRUSER_RECORD_EXTENSION Get_ForumUserRec(HWND PBBSWIN)
{
//  Gives you the pointer to the actual location of the user forum record in
//  memory.  This record contains the user's last read pointers along with
//  the information containing which forums the user has access to.


    LPPOWRUSER_RECORD_EXTENSION  lpExt;
    char pIn [254];
    
    SendMessage(PBBSWIN, WM_COMMAND, 10031, (LPARAM)(LPSTR) pIn);
    lpExt = (LPPOWRUSER_RECORD_EXTENSION) * (LONG *) pIn;
    return lpExt;
}

//---------------------------------------------------------------------------
LPPOWER_CALLINFO_REC Get_CallInfo(HWND PBBSWIN)
{
//  Gives you the pointer to the actual location of the caller info record in
//  memory.
    
    LPPOWER_CALLINFO_REC lpCallInf;
    char pIn [254];

    SendMessage(PBBSWIN, WM_COMMAND, 10032, (LPARAM)(LPSTR) pIn);
    lpCallInf = (LPPOWER_CALLINFO_REC) * (LONG *) pIn;
    return lpCallInf;
}


//---------------------------------------------------------------------------
LPPOWERBBS_FORUM_STRUCTURE Get_Current_ForumInfo(HWND PBBSWIN)
{
    
    LPPOWERBBS_FORUM_STRUCTURE  lpForum;
    char pIn [254];
    
    SendMessage(PBBSWIN, WM_COMMAND, 10033, (LPARAM)(LPSTR) pIn);
    lpForum = (LPPOWERBBS_FORUM_STRUCTURE) * (LONG *) pIn;
    return lpForum;
}

//--------------------------------------------------------------------------
LPPBBSRECORD Get_BBS_Record(HWND PBBSWIN)
{
    
    LPPBBSRECORD  lpBBSRec;
    char pIn [254];

    SendMessage(PBBSWIN, WM_COMMAND, 10034, (LPARAM)(LPSTR) pIn);
    lpBBSRec = (LPPBBSRECORD) * (LONG *) pIn;
    return lpBBSRec;
}


//---------------------------------------------------------------------------
void End_Call(HWND PBBSWIN)
{
// End The Call

    SendMessage(PBBSWIN, WM_COMMAND, 10024, 0);
}

//--------------------------------------------------------------------------
int Search_UserName(HWND PBBSWIN, LPSTR TheName)
{
// Searches the UserDatabase for TheName.  If not found, returns 0.
//  If found, returns the record number that TheName is contained within. }

    char pIn[254];

    lstrcpy (pIn, TheName);
    SendMessage(PBBSWIN, WM_COMMAND, 10040, (LPARAM)(LPSTR) pIn);
    return (asc_to_int (pIn));
}

//--------------------------------------------------------------------------
void Load_UserRec(HWND PBBSWIN, LPPOWRUSER_RECORD user, int usernum)
{
//  You must allocate memory for user before calling this routine!
//  UserNum signifies the actual user record number (ask returned
//  by Search_UserName)

    char pIn [254];

    wsprintf (pIn, "%d", usernum);
    SendMessage(PBBSWIN, WM_COMMAND, 10041, (LPARAM)(LPSTR) pIn);
    SendMessage(PBBSWIN, WM_COMMAND, 10042, (LPARAM)(LPSTR) user);
}

//---------------------------------------------------------------------------
void Save_UserRec(HWND PBBSWIN, LPPOWRUSER_RECORD user, int usernum)
{
//  You must allocate memory for user before calling this routine!
//  UserNum signifies the actual user record number (as returned
//  by Search_UserName)

    char pIn [254];


    wsprintf (pIn, "%d", usernum);
    SendMessage(PBBSWIN, WM_COMMAND, 10041, (LPARAM)(LPSTR) pIn);
    SendMessage(PBBSWIN, WM_COMMAND, 10043, (LPARAM)(LPSTR) user);
}

//---------------------------------------------------------------------------
void Close_ComPort(HWND PBBSWIN)
{
// Closes the com port.

    SendMessage(PBBSWIN, WM_COMMAND, 10044, 0);
}

//---------------------------------------------------------------------------
void Open_ComPort(HWND PBBSWIN)
{
// Opens up the Com Port.

    SendMessage(PBBSWIN, WM_COMMAND, 10045, 0);
}

//---------------------------------------------------------------------------
void HangUp_Caller(HWND PBBSWIN)
{
// Attempts to hangup the caller.
//  (Note that after 4 tries it gives up, if the caller is still on-line)

    SendMessage(PBBSWIN, WM_COMMAND, 10046, 0);
}

//---------------------------------------------------------------------------
int Number_Users_Online(HWND PBBSWIN)
{
// Returns the number of users currently on-line.
// Only returns NON-ZERO nodes (So if a sysop has a BBS with a node 0 that
// node is not counted.

    char PIn [30];

    SendMessage(PBBSWIN, WM_COMMAND, 10047, (LONG)(LPSTR) PIn);
    return (asc_to_int (PIn));
}

//--------------------------------------------------------------------------
//
// In order to send a message first call Init_Message with the header.
// Then call Message_Line TOTAL_LINES Number of times.  Each with the
// actual line of text for the message.
// Then call Save_Message.

void Init_Message(HWND PBBSWIN,
		  LPSTR From,		// Person Sending Message 
		  LPSTR Tou,		// Message destination
		  LPSTR Topic,		// Subject of message
		  int Total_Lines,	// Total lines in message
		  int Forum_Num,	// Forum number to save in
		  BOOL Private)	        // TRUE = Private message
{		  
    char Pin [255];
    wsprintf (Pin, "%s~%s~%s~%d~%d%c", From, Tou, Topic, Total_Lines,
	      Forum_Num, (Private ? 'Y' : 'N'));
    
    SendMessage(PBBSWIN, WM_COMMAND, 10050, (LPARAM)(LPSTR) Pin);
}

void Message_Line(HWND PBBSWIN, LPSTR TheLine)
{
  SendMessage(PBBSWIN, WM_COMMAND, 10051, (LPARAM)(LPSTR) TheLine);
}

void Save_Message(HWND PBBSWIN)
{
    SendMessage(PBBSWIN, WM_COMMAND, 10052, 0);
}


//---------------------------------------------------------------------------
void Set_Node_Description(HWND PBBSWIN, LPSTR Doing)
{
// Sets the WHO IS ONLINE RECORD to what the user is doing.
// Ex: Set_Node_Description(PBBSWIN, 'Using 3rd party door.');

    SendMessage(PBBSWIN, WM_COMMAND, 10053, (LPARAM)(LPSTR) Doing);
}


BOOL Is_User_Online(HWND PBBSWIN, LPSTR thename)
{
// Checks if THENAME is currently on-line as a user.  If THENAME is on-line
//  returns TRUE 

    char pIn [255];

    lstrcpy (pIn, thename);
    SendMessage(PBBSWIN, WM_COMMAND, 10054, (LPARAM)(LPSTR) pIn);
    return (pIn[0] == 'Y');
}


// Common code for the DLL. This is just a demo and does not do anything
// real useful. The common code is separate so that it can be called from
// two different entry points, see below about POWERBBS_MAIN and
// POWERBBS_PMAIN entry points.

void DoCode (HWND PBBSWin, LPSTR Stuff)
{
    
    char			Inputs[255];
    char			TBuff [255];
    unsigned char		Counter;
    LPPOWRUSER_RECORD		Puser;
    LPPOWRUSER_RECORD_EXTENSION Fuser;
    LPPOWER_CALLINFO_REC	Cuser;
    LPPOWERBBS_FORUM_STRUCTURE	forum;
    LPPBBSRECORD		bbs;
    int				unum;
    LPPOWRUSER_RECORD		Puser2;


    if (lstrlen (Stuff))
    {
	Print_Modem(PBBSWin, "Parameter: ");
	PrintLn_Modem(PBBSWin, Stuff);
    }
    ClearScreen(PBBSWin);
    Write_ActLog(PBBSWin, "Entering Our Test .DLL!");
    lstrcpy (Inputs, "|NAME|");
    Convert_Macros(PBBSWin, Inputs);
    Print_Modem(PBBSWin, "Welcome ");
    PrintLn_Modem(PBBSWin, Inputs);
    PrintLn_Modem(PBBSWin, "PowerDLL (c)1994 by Russell E. Frey");
    PrintLn_Modem(PBBSWin, "This demo does NOTHING special, other than "
		  "TEST the capabilities of the DLL.");
    PrintLn_Modem(PBBSWin, "");
    Print_Modem(PBBSWin, "Run Demo? ");
    if (! Get_YN(PBBSWin))
	return;
    
    // Now Test Pause
    
    for (Counter = 0; Counter < 13; Counter ++)
    {
	PrintLn_Modem(PBBSWin, "This module is a DLL linked dynamically "
		      "to PowerBBS!");
	PrintLn_Modem(PBBSWin, "Now easily write addons in Visual Basic, "
		      "C, C++, Pascal!");
	
	if (PauseStop(PBBSWin))
	    break;
	if (No_User_Online(PBBSWin))
	    return;
    }
    Print_Modem(PBBSWin, "What do you like about this? ");
    Ask_User(PBBSWin, Inputs, 20);
    Print_Modem(PBBSWin, "You inputted [");
    Print_Modem(PBBSWin, Inputs);
    PrintLn_Modem(PBBSWin, "]");

    Print_Modem(PBBSWin, "Press ONE KEY:: ");
    Inputs[0] = Get_Key(PBBSWin);
    Back_Spaces(PBBSWin, 17);

    if (Get_YesNoQ(PBBSWin, "Did you like this program?", TRUE))
	PrintLn_Modem(PBBSWin, "Thanks!");
    else
	PrintLn_Modem(PBBSWin, "Thats ok.  Oh BTW I just locked you out!");
    Inputs [1] = '\0';
    PrintLn_Modem(PBBSWin, Inputs);
    Print_Modem(PBBSWin, "Press A B or C: ");
    Inputs[0] = Get_Hot(PBBSWin, "ABC");
    Inputs [1] = '\0';
    PrintLn_Modem(PBBSWin, Inputs);
    Type_File_To_Modem(PBBSWin, "C:\\Autoexec.Bat");
    Print_Modem(PBBSWin, "Press ONE KEY (within two seconds):: ");
    Inputs[0] = Input_Key_Time(PBBSWin, 2000);
    Inputs [1] = '\0';
    if ((unsigned char) Inputs[0] == (unsigned char) 0xFF)
	PrintLn_Modem(PBBSWin, "TimeOut!");
    else
	PrintLn_Modem(PBBSWin, Inputs);
    
    Send_Modem_Command(PBBSWin, ">>");
//    Execute_Prog(PBBSWin, "C:\\TEMP.BAT");
    if (Key_Waiting(PBBSWin))
	PrintLn_Modem(PBBSWin, "Key Waiting");
    else
	PrintLn_Modem(PBBSWin, "NO KEY WAITING");
    
    Change_Forum(PBBSWin, 3);
    Run_Menu_Command(PBBSWin, 1);
//    Run_PowerBase(PBBSWin, 1);
    Print_Modem(PBBSWin, "Time Left: ");
    unum = Time_Left(PBBSWin);
    wsprintf (Inputs, "%d", unum);
    PrintLn_Modem(PBBSWin, Inputs);

    Puser = Get_UserRec(PBBSWin);

    Print_Modem(PBBSWin, "Name = ");
    PrintLn_Modem(PBBSWin, PackedToCString (Puser -> name, TBuff, 25));
    Print_Modem(PBBSWin, "ZIP = ");
    PrintLn_Modem(PBBSWin, PackedToCString (Puser -> zip, TBuff, 10));

    Fuser = Get_ForumUserRec(PBBSWin);
    
    if (Fuser -> Forum_Data[3].Options & 1)
	PrintLn_Modem(PBBSWin, " You have access to forum #3!");
    else
	PrintLn_Modem(PBBSWin, " You do NOT have access to forum #3. <g>");

    Cuser = Get_CallInfo(PBBSWin);
    Print_Modem(PBBSWin, "You are on at ");
    Print_Modem(PBBSWin, PackedToCString (Cuser -> BaudRate, TBuff, 5));
    PrintLn_Modem(PBBSWin, " bps! ");

    forum = Get_Current_ForumInfo(PBBSWin);
    Print_Modem(PBBSWin, "Current Forum Name: ");
    PrintLn_Modem(PBBSWin, PascalToCString (forum->forum_name_len, TBuff, 30));

    bbs = Get_BBS_Record(PBBSWin);
    PrintLn_Modem(PBBSWin, "Opening File: ");
    PrintLn_Modem(PBBSWin, PascalToCString (bbs -> OpeningLen, TBuff, 35));
    if (Monitor_Mode(PBBSWin) == 'R')
	PrintLn_Modem(PBBSWin, "Using RIP");
    else if (Monitor_Mode(PBBSWin) == 'C')
	PrintLn_Modem(PBBSWin, "Using ANSI");
    else
	PrintLn_Modem(PBBSWin, "Using ASCII");

    Print_Modem(PBBSWin, "Rec # of GF = ");
    wsprintf (Inputs, "%d", Search_UserName(PBBSWin, "GLEN FREY"));
    PrintLn_Modem(PBBSWin, Inputs);
    
    unum = Search_UserName(PBBSWin, "GLEN FREY");
    
    if (unum != 0)
    {
	HANDLE hTemp = GlobalAlloc (GMEM_MOVEABLE|GMEM_ZEROINIT,
				    (LONG) sizeof (POWRUSER_RECORD));
	
MessageBox (0, "Hm, found GLEN FREY!!!", "DEBUG", MB_OK);
    
	if (hTemp)
	{
	    Puser2 = (LPPOWRUSER_RECORD) GlobalLock (hTemp);
	    if (Puser2)
	    {
		Load_UserRec(PBBSWin, Puser2, unum);
		Print_Modem(PBBSWin, "Password = ");
		PrintLn_Modem(PBBSWin, PackedToCString (Puser2 -> Password,
		    TBuff, 11));
//		Puser2^.Password[1] := 'N';
//		Save_UserRec(PBBSWin, Puser2, unum);
		GlobalUnlock (hTemp);
	    }
	    GlobalFree (hTemp);
	}
    }

    Init_Message(PBBSWin, "SYSOP", "TEST USER", "Thanks!", 2, 0, FALSE);
    Message_Line(PBBSWin, "Hi Test User!");
    Message_Line(PBBSWin, " ... The SysOp ");
    Save_Message(PBBSWin);

    Set_Node_Description(PBBSWin, "In PowerDLL");
    lstrcpy (Inputs, "|WHO-ON|");
    Convert_Macros(PBBSWin, Inputs);

    if (Is_User_Online(PBBSWin, "GLEN FREY"))
	PrintLn_Modem (PBBSWin, "Glen is On-Line!");
    Print_Modem(PBBSWin, "Number Users Online: ");
    wsprintf (Inputs, "%d", Number_Users_Online(PBBSWin));
    PrintLn_Modem(PBBSWin, Inputs);
    PrintLn_Modem(PBBSWin, "Exiting to PowerBBS...");
    Get_Enter_Key(PBBSWin);
//    End_Call(PBBSWin);
}


//-- Main DLL Module --
//-- This procedure MUST be named as PowerBBS_Main.  PowerBBS assumes this
//   procedure exists as this is the name that it calls when dynamically
//   loading the DLL upon call from the BBS. ---
// If the application is to be started from a PowerLanguage (.POW) program
// you may also have an entry procedure that can take parameters. When
// starting the DLL from PowerLanguage PowerBBS will check if the DLL has
// an entry called POWERBBS_PMAIN and, if so, the PowerLanguage string
// variables S1, S2, S3, S4 and S5 is passed in as far string pointers,
// defined in windows as LPSTR. Even if, as in this example, only one
// is used you MUST declare all five in the function, if not the DLL
// may crash on exit.
// If no POWERBBS_PMAIN is found or if called from a menu the normal
// POWERBBS_MAIN function is called without any optional parameters.
//
// These two entry functions call a common function, the POWERBBS_MAIN
// sends in a empty string while POWERBBS_PMAIN sends in the first
// parameter S1 to the common function.

void _export WINAPI POWERBBS_MAIN (HWND PBBSWin)
{
    DoCode (PBBSWin, "");
}

void _export WINAPI POWERBBS_PMAIN (HWND PBBSWin, LPSTR s1, LPSTR s2,
				    LPSTR s3, LPSTR s4, LPSTR s5)
{
    DoCode (PBBSWin, s1);
}
