// Copyright (c) 1994, William Wagner
// All Rights reserved.
//
// This source is a portion of a shareware program.  It may be distributed
// only in its entirety.  The copyright statements must be included with any 
// reproduction of this source.
// 

// printvie.h : header file
//

#ifndef __PRINTVIE_H__
#define __PRINTVIE_H__

/////////////////////////////////////////////////////////////////////////////
// CPrintView view
//
// This class is responsible for the display of the print display
// of the document.
//

class CPrintView : public CScrollView
{
	DECLARE_DYNCREATE(CPrintView)
protected:
	CPrintView();			// protected constructor used by dynamic creation

friend class CMainFrame; // The CMainFrame class can call the print routines.  

// Attributes
public:
	//Return a pointer to the document.  This is 
	// non-const to avoid hiding the base class, and
	// is instead a new function.
	CCassetteDoc* GetDocument ();

private:
//All of the data is a set of rectangles for text drawing and hit tests.
	// Text drawing rectangles
	const CRect m_Side1Rect;
	const CRect m_Side2Rect; 
	const CRect m_ArtistTextRect; 
	const CRect m_AlbumTextRect; 
	const CRect m_NotesTextRect;
		
	// Hit Test rectangles for the double clicks
	const CRect m_SongsRect;
	const CRect m_ArtistRect;
	const CRect m_AlbumRect;
	const CRect m_NotesRect;
	
// Operations
public:
	
// Implementation
private:
	void DrawLines (CDC* pDC) const;
	void DrawTextData (CDC* pDC, const CCassetteDoc* pDoc) const;
	

protected:
	//Destroy this.
	virtual ~CPrintView();
	// overridden to draw this view
	virtual	void OnDraw(CDC* pDC);
	//Receive updates.
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	//First update:
	virtual	void OnInitialUpdate();
	//Prepare for printing.
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);

	// Generated message map functions
	//The Double click is used to change the fonts for this tape.	
	//{{AFX_MSG(CPrintView)
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG // debug version in printvie.cpp
inline CCassetteDoc* CPrintView::GetDocument()
   { return (CCassetteDoc*) m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
#endif
