// Copyright (c) 1994, William Wagner
// All Rights reserved.
//
// This source is a portion of a shareware program.  It may be distributed
// only in its entirety.  The copyright statements must be included with any 
// reproduction of this source.
// 

// printvie.cpp : implementation file
//

#include "stdafx.h"
#include "cassette.h"
#include "printvie.h"

#include "cassedoc.h"

//Constants for the sizes of the visual effects on the tape J-Card.
const int TAPE_X = 390;
const int TAPE_Y = 375;
const int FRONT_Y = 260;
const int FACE_Y = 50;

const int SIDE_2 = 200;
const int BORDER = 20;
const int TEXT_XSPACING = 11;
const int TEXT_YSPACING = 5;
const int OVERLAP = 50;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrintView

IMPLEMENT_DYNCREATE(CPrintView, CScrollView)

//Initialize the const rectangles.
CPrintView::CPrintView() : 
	m_Side1Rect (BORDER+TEXT_XSPACING, -(BORDER + TEXT_YSPACING), 
		BORDER + SIDE_2 + OVERLAP, -(BORDER+FRONT_Y-TEXT_YSPACING)),
	m_Side2Rect (BORDER + SIDE_2 - OVERLAP, -(BORDER + TEXT_YSPACING),
		BORDER + TAPE_X - TEXT_XSPACING, -(BORDER+FRONT_Y-TEXT_YSPACING)),
	m_ArtistTextRect (BORDER+TEXT_XSPACING, -(BORDER+FRONT_Y+TEXT_YSPACING), 
		BORDER + TAPE_X - TEXT_XSPACING, -(BORDER+FRONT_Y+FACE_Y-TEXT_YSPACING)),
	m_AlbumTextRect (BORDER+TEXT_XSPACING, -(BORDER+FRONT_Y+TEXT_YSPACING),
		BORDER + TAPE_X - TEXT_XSPACING, -(BORDER+FRONT_Y+FACE_Y-TEXT_YSPACING)),
	m_NotesTextRect (BORDER+TEXT_XSPACING, -(BORDER+FRONT_Y+FACE_Y+TEXT_YSPACING),
		BORDER+TAPE_X - TEXT_XSPACING, -(BORDER+TAPE_Y-TEXT_YSPACING)),
	m_SongsRect (BORDER, -(BORDER+FRONT_Y), BORDER + TAPE_X, -BORDER),
    m_ArtistRect (BORDER, -(BORDER+FRONT_Y+FACE_Y), BORDER + SIDE_2,
    	-(BORDER+FRONT_Y)),
	m_AlbumRect (BORDER+SIDE_2, -(BORDER+FRONT_Y+FACE_Y), BORDER + TAPE_X,
		-(BORDER+FRONT_Y)),
	m_NotesRect (BORDER, -(BORDER+TAPE_Y), BORDER+TAPE_X,
	-(BORDER+FRONT_Y+FACE_Y))
{
}

//Destroy things.  No pointers, so it doesn't matter.
CPrintView::~CPrintView()
{
}

BEGIN_MESSAGE_MAP(CPrintView, CScrollView)
	//{{AFX_MSG_MAP(CPrintView)
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrintView drawing
#ifdef _DEBUG
CCassetteDoc* CPrintView::GetDocument() // non-debug version is inline
{
ASSERT_VALID (this);
ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCassetteDoc)));
return (CCassetteDoc*) m_pDocument;
}
#endif

//The initial Update.
// Set the scroll sizes.  The sizes are size of the tape pluse
// twice the border.
//Don't call the base class, that passes a NULL OnUpdate.
//Invalidate the entire window instead.
void CPrintView::OnInitialUpdate()
{
ASSERT_VALID (this);

CSize sizeTotal (TAPE_X + 2 * BORDER, TAPE_Y + 2 * BORDER);

SetScrollSizes(MM_LOENGLISH, sizeTotal);
InvalidateRect (NULL);
}

//Handle the updates.
// So, depending on the rectangle that has changed,
// invalidate the proper parts of the window.  That will
// cause the window to be redrawn.
void CPrintView::OnUpdate (CView*, LPARAM lHint, CObject*)
{
ASSERT_VALID (this);

CRect DeviceRect (0,0,0,0);
CDC* pDC = GetDC ();

ASSERT_VALID (pDC);

pDC->SetMapMode (MM_LOENGLISH);

switch (lHint)
	{
	case ALBUM1_CHANGE:
	case ALBUM2_CHANGE:
	case FONT_ALBUM_CHANGE:
		DeviceRect = m_AlbumTextRect;
		break;
		
	case ARTIST1_CHANGE:
	case ARTIST2_CHANGE:   
	case FONT_ARTIST_CHANGE:
		DeviceRect = m_ArtistTextRect;
		break;
		
	case SONGS1_CHANGE:
		DeviceRect = m_Side1Rect;
		break;
		
	case SONGS2_CHANGE:
		DeviceRect = m_Side2Rect;
		break;
	
	case NOTES_CHANGE:
	case FONT_NOTES_CHANGE:
		DeviceRect = m_NotesTextRect;
		break;

	case FONT_SONGS_CHANGE:
		{
		//This is slightly different, there are two different 
		//rectangles that need to be invalidated/
		DeviceRect = m_Side1Rect;
		pDC->LPtoDP (DeviceRect);
		InvalidateRect (DeviceRect);
		DeviceRect = m_Side2Rect;
		}
		break;
		
	default:
		ASSERT (FALSE);
	}
pDC->LPtoDP (DeviceRect);
ReleaseDC (pDC);
InvalidateRect (DeviceRect);
}

//Draw the lines surrounding the tape label.
// Just some GDI work.
void CPrintView::DrawLines (CDC* pDC) const
{
ASSERT_VALID (this);
ASSERT_VALID (pDC);

// Draw the border
CPen OutLinePen(PS_SOLID, 7, GetSysColor (COLOR_WINDOWTEXT));
CPen InteriorLinePen (PS_SOLID, 5, GetSysColor (COLOR_WINDOWTEXT));

ASSERT_VALID (&OutLinePen);
ASSERT_VALID (&InteriorLinePen);

CPen* pOldPen;
    
pOldPen = pDC->SelectObject (&OutLinePen);

ASSERT_VALID (pOldPen);

pDC->MoveTo (BORDER,-BORDER);
pDC->LineTo (TAPE_X+BORDER , -BORDER);	
pDC->LineTo (TAPE_X+BORDER, -(TAPE_Y+BORDER));
pDC->LineTo (BORDER, -(TAPE_Y+BORDER));
pDC->LineTo (BORDER, -BORDER);
	
// Middle Lines
pDC->SelectObject (&InteriorLinePen);
pDC->MoveTo (BORDER, -(BORDER + FRONT_Y));
pDC->LineTo (TAPE_X+BORDER, -(BORDER + FRONT_Y));
pDC->MoveTo (BORDER, -(BORDER + FRONT_Y + FACE_Y));
pDC->LineTo (TAPE_X+BORDER, -(BORDER + FRONT_Y + FACE_Y));
pDC->SelectObject (pOldPen);
}

//Draw the text for this J Card.
// Like draw lines, just some GDI programming.
void CPrintView::DrawTextData (CDC* pDC, const CCassetteDoc* pDoc) const
{
ASSERT_VALID (this);
ASSERT_VALID (pDC);
ASSERT_VALID (pDoc);

CFont SongsFont;
CFont ArtistFont;
CFont AlbumFont;
CFont NotesFont;
CFont* pOldFont;

SongsFont.CreateFontIndirect (&(pDoc->m_lfontSongs));
ArtistFont.CreateFontIndirect (&(pDoc->m_lfontArtist));
AlbumFont.CreateFontIndirect (&(pDoc->m_lfontAlbum));
NotesFont.CreateFontIndirect (&(pDoc->m_lfontNotes));

ASSERT_VALID (&SongsFont);
ASSERT_VALID (&ArtistFont);
ASSERT_VALID (&AlbumFont);
ASSERT_VALID (&NotesFont);

// Songs on side 1
pOldFont = pDC->SelectObject (&SongsFont);
ASSERT_VALID (pOldFont);

pDC->DrawText (pDoc->m_csSongs1, pDoc->m_csSongs1.GetLength (), m_Side1Rect, DT_LEFT); 
pDC->DrawText (pDoc->m_csSongs2, pDoc->m_csSongs2.GetLength (), m_Side2Rect, DT_RIGHT);	

// Artist rectangle
pDC->SelectObject (&ArtistFont);
CString Artists = pDoc->m_csArtist1;
if (!pDoc->m_csArtist2.IsEmpty())
	Artists += "\n" + pDoc->m_csArtist2;
pDC->DrawText (Artists, Artists.GetLength (), m_ArtistTextRect, DT_LEFT);	

// Album rectangle
pDC->SelectObject (&AlbumFont);
CString Albums = pDoc->m_csAlbum1;
if (!pDoc->m_csAlbum2.IsEmpty())
	Albums += "\n" + pDoc->m_csAlbum2;
pDC->DrawText (Albums, Albums.GetLength (), m_AlbumTextRect, DT_RIGHT);

// Notes rectangle
pDC->SelectObject (&NotesFont);
pDC->DrawText (pDoc->m_csNotes, pDoc->m_csNotes.GetLength (), m_NotesTextRect, DT_CENTER);	

//Restore the original font.
pDC->SelectObject (pOldFont);
}

//Handle the drawing.  
//Get a pointer to the document.  Call some
//little helper functions to put things on the screen.
void CPrintView::OnDraw(CDC* pDC)
{
ASSERT_VALID (this);
ASSERT_VALID (pDC);

CCassetteDoc* pDoc = GetDocument();

ASSERT_VALID (pDoc);

DrawLines (pDC);
DrawTextData (pDC, pDoc);

ASSERT_VALID (pDoc);
ASSERT_VALID (pDC);
}

//Prepare the printing.  We only have one page.
// So, set the max pages.  
BOOL CPrintView::OnPreparePrinting(CPrintInfo* pInfo)
{
ASSERT_VALID (this);
pInfo->SetMaxPage (1);
return DoPreparePrinting(pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CPrintView message handlers

//Double Click handlers.
// Determine if the user clicked on one of the hit rectangles.
// If so, call the document's print command handler.
void CPrintView::OnLButtonDblClk(UINT , CPoint point)
{
ASSERT_VALID (this);
int WhichFont = 0;

CDC* pDC = GetDC ();

ASSERT_VALID (pDC);

pDC->SetMapMode (MM_LOENGLISH);
pDC->DPtoLP (&point);
ReleaseDC (pDC);

if (m_SongsRect.PtInRect (point))
	WhichFont = FONT_SONGS_CHANGE;
else if (m_ArtistRect.PtInRect (point))
	WhichFont = FONT_ARTIST_CHANGE;
else if (m_AlbumRect.PtInRect (point))
	WhichFont = FONT_ALBUM_CHANGE;
else if (m_NotesRect.PtInRect (point))
	WhichFont = FONT_NOTES_CHANGE;
else
	return;
ASSERT_VALID (GetDocument ());
GetDocument ()->DoFontCommand (WhichFont);
}
